/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.TrackingDfaMemoryState;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckNotNullInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EndOfInitializerInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaRelation;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackingRunner
extends DataFlowRunner {
    private TrackingDfaMemoryState.MemoryStateChange myHistoryForContext;
    private final PsiExpression myExpression;
    private final List<DfaInstructionState> afterStates;
    private final List<TrackingDfaMemoryState> killedStates;

    private TrackingRunner(@NotNull PsiElement context, PsiExpression expression2, boolean unknownMembersAreNullable, boolean ignoreAssertions) {
        if (context == null) {
            TrackingRunner.$$$reportNull$$$0(0);
        }
        super(context.getProject(), context, unknownMembersAreNullable, ignoreAssertions);
        this.myHistoryForContext = null;
        this.afterStates = new ArrayList<DfaInstructionState>();
        this.killedStates = new ArrayList<TrackingDfaMemoryState>();
        this.myExpression = expression2;
    }

    @Override
    protected void beforeInstruction(Instruction instruction) {
        this.afterStates.clear();
        this.killedStates.clear();
    }

    @Override
    protected void afterInstruction(Instruction instruction) {
        if (this.afterStates.size() <= 1 && this.killedStates.isEmpty()) {
            return;
        }
        Map instructionToState = StreamEx.of(this.afterStates).mapToEntry(s -> s.getInstruction(), s -> (TrackingDfaMemoryState)s.getMemoryState()).grouping();
        if (instructionToState.size() <= 1 && this.killedStates.isEmpty()) {
            return;
        }
        instructionToState.forEach((target, memStates) -> {
            List bridgeChanges = ((StreamEx)StreamEx.of(this.afterStates).filter(s -> s.getInstruction() != target)).map(s -> (TrackingDfaMemoryState)s.getMemoryState()).append(this.killedStates).toList();
            for (TrackingDfaMemoryState state : memStates) {
                state.addBridge(instruction, bridgeChanges);
            }
        });
    }

    @Override
    @NotNull
    protected DfaMemoryState createMemoryState() {
        return new TrackingDfaMemoryState(this.getFactory());
    }

    @Override
    protected DfaInstructionState @NotNull [] acceptInstruction(@NotNull InstructionVisitor visitor2, @NotNull DfaInstructionState instructionState) {
        ExpressionPushingInstruction pushing;
        DfaInstructionState[] states;
        if (visitor2 == null) {
            TrackingRunner.$$$reportNull$$$0(1);
        }
        if (instructionState == null) {
            TrackingRunner.$$$reportNull$$$0(2);
        }
        Instruction instruction = instructionState.getInstruction();
        TrackingDfaMemoryState memState = (TrackingDfaMemoryState)instructionState.getMemoryState().createCopy();
        for (DfaInstructionState state : states = super.acceptInstruction(visitor2, instructionState)) {
            this.afterStates.add(state);
            ((TrackingDfaMemoryState)state.getMemoryState()).recordChange(instruction, memState);
        }
        if (states.length == 0) {
            this.killedStates.add(memState);
        }
        if (instruction instanceof ExpressionPushingInstruction && (pushing = (ExpressionPushingInstruction)instruction).getExpression() == this.myExpression && pushing.getExpressionRange() == null) {
            for (DfaInstructionState state : states) {
                TrackingDfaMemoryState.MemoryStateChange history = ((TrackingDfaMemoryState)state.getMemoryState()).getHistory();
                this.myHistoryForContext = this.myHistoryForContext == null ? history : this.myHistoryForContext.merge(history);
            }
        }
        if (states == null) {
            TrackingRunner.$$$reportNull$$$0(3);
        }
        return states;
    }

    @Nullable
    public static CauseItem findProblemCause(boolean unknownAreNullables, boolean ignoreAssertions, PsiExpression expression2, DfaProblemType type2) {
        PsiElement body2 = DfaUtil.getDataflowContext(expression2);
        if (body2 == null) {
            return null;
        }
        TrackingRunner runner = new TrackingRunner(body2, expression2, unknownAreNullables, ignoreAssertions);
        if (!runner.analyze(expression2, body2)) {
            return null;
        }
        return runner.findProblemCause(expression2, type2);
    }

    private boolean analyze(PsiExpression expression2, PsiElement body2) {
        PsiCodeBlock ctorBody;
        PsiMethod ctor;
        final ArrayList endOfInitializerStates = new ArrayList();
        StandardInstructionVisitor visitor2 = new StandardInstructionVisitor(true){

            @Override
            public DfaInstructionState[] visitEndOfInitializer(EndOfInitializerInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
                if (!instruction.isStatic()) {
                    endOfInitializerStates.add(state.createCopy());
                }
                return super.visitEndOfInitializer(instruction, runner, state);
            }
        };
        RunnerResult result = this.analyzeMethodRecursively(body2, visitor2);
        if (result != RunnerResult.OK) {
            return false;
        }
        if (body2 instanceof PsiClass && (ctor = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) != null && ctor.isConstructor() && (ctorBody = ctor.getBody()) != null) {
            PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)ctor);
            List initialStates = JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)call) || call == null && DfaUtil.hasImplicitImpureSuperCall((PsiClass)body2, ctor) ? Collections.singletonList(this.createMemoryState()) : StreamEx.of(endOfInitializerStates).map(DfaMemoryState::createCopy).toList();
            return this.analyzeBlockRecursively((PsiElement)ctorBody, initialStates, visitor2) == RunnerResult.OK;
        }
        return true;
    }

    @Nullable
    private CauseItem findProblemCause(PsiExpression expression2, DfaProblemType type2) {
        if (this.myHistoryForContext == null) {
            return null;
        }
        CauseItem cause = null;
        do {
            CauseItem item = new CauseItem(type2, (PsiElement)expression2);
            TrackingDfaMemoryState.MemoryStateChange history = this.myHistoryForContext.getNonMerge();
            if (history.getExpression() == expression2) {
                item.addChildren(type2.findCauses(this, expression2, history));
            }
            if (cause == null) {
                cause = item;
                continue;
            }
            if ((cause = cause.merge(item)) != null) continue;
            return null;
        } while (this.myHistoryForContext.advance());
        return cause;
    }

    private CauseItem @NotNull [] findConstantValueCause(PsiExpression expression2, TrackingDfaMemoryState.MemoryStateChange history, Object expectedValue) {
        TrackingDfaMemoryState.MemoryStateChange change;
        Object constValue;
        if (expression2 instanceof PsiLiteralExpression) {
            return new CauseItem[0];
        }
        Object constantExpressionValue = ExpressionUtils.computeConstantExpression(expression2);
        DfaValue value2 = history.myTopOfStack;
        if (constantExpressionValue != null && constantExpressionValue.equals(expectedValue)) {
            CauseItem[] causeItemArray = new CauseItem[]{new CauseItem("it's compile-time constant which evaluates to '" + value2 + "'", (PsiElement)expression2)};
            if (causeItemArray == null) {
                TrackingRunner.$$$reportNull$$$0(4);
            }
            return causeItemArray;
        }
        if (value2.getDfType() instanceof DfConstantType && Objects.equals(constValue = ((DfConstantType)value2.getDfType()).getValue(), expectedValue) && constValue instanceof Boolean) {
            CauseItem[] causeItemArray = this.findBooleanResultCauses(expression2, history, (Boolean)constValue);
            if (causeItemArray == null) {
                TrackingRunner.$$$reportNull$$$0(5);
            }
            return causeItemArray;
        }
        if (value2 instanceof DfaVariableValue && (change = history.findRelation((DfaVariableValue)value2, rel -> rel.myRelationType == RelationType.EQ && DfConstantType.isConst(rel.myCounterpart.getDfType(), expectedValue), false)) != null) {
            PsiExpression varSourceExpression = change.getExpression();
            Instruction instruction = change.myInstruction;
            if (instruction instanceof AssignInstruction && change.myTopOfStack == value2) {
                PsiExpression rValue = ((AssignInstruction)instruction).getRExpression();
                CauseItem item = TrackingRunner.createAssignmentCause((AssignInstruction)instruction, value2);
                TrackingDfaMemoryState.MemoryStateChange push = change.findSubExpressionPush(rValue);
                if (push != null) {
                    item.addChildren(this.findConstantValueCause(rValue, push, expectedValue));
                }
                CauseItem[] causeItemArray = new CauseItem[]{item};
                if (causeItemArray == null) {
                    TrackingRunner.$$$reportNull$$$0(6);
                }
                return causeItemArray;
            }
            if (varSourceExpression != null) {
                CauseItem[] causeItemArray = new CauseItem[]{new CauseItem("'" + value2 + " == " + expectedValue + "' was established from condition", (PsiElement)varSourceExpression)};
                if (causeItemArray == null) {
                    TrackingRunner.$$$reportNull$$$0(7);
                }
                return causeItemArray;
            }
        }
        return new CauseItem[0];
    }

    @NotNull
    @Contract(value="_, _ -> new")
    private static CauseItem createAssignmentCause(AssignInstruction instruction, DfaValue target) {
        PsiExpression rExpression = instruction.getRExpression();
        PsiJavaToken anchor = null;
        String targetName = target.toString();
        if (rExpression != null) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)rExpression.getParent());
            if (parent instanceof PsiAssignmentExpression) {
                anchor = ((PsiAssignmentExpression)parent).getOperationSign();
                targetName = ((PsiAssignmentExpression)parent).getLExpression().getText();
            } else if (parent instanceof PsiVariable) {
                ASTNode node = parent.getNode();
                if (node instanceof CompositeElement) {
                    anchor = ((CompositeElement)node).findChildByRoleAsPsiElement(20);
                }
                targetName = ((PsiVariable)parent).getName();
            }
            if (anchor == null) {
                anchor = rExpression;
            }
        }
        PsiExpression stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)rExpression);
        String suffix = "";
        if (stripped instanceof PsiLiteralExpression) {
            suffix = " to '" + StringUtil.shortenTextWithEllipsis((String)stripped.getText(), (int)40, (int)5) + "'";
        }
        return new CauseItem("'" + targetName + "' was assigned" + suffix, (PsiElement)anchor);
    }

    private CauseItem[] findBooleanResultCauses(PsiExpression expression2, TrackingDfaMemoryState.MemoryStateChange history, boolean value2) {
        PsiInstanceOfExpression instanceOfExpression;
        PsiExpression operand2;
        TrackingDfaMemoryState.MemoryStateChange operandHistory;
        PsiBinaryExpression binOp;
        RelationType relationType;
        IElementType tokenType;
        boolean and;
        TrackingDfaMemoryState.MemoryStateChange negatedPush;
        PsiExpression negated;
        if (BoolUtils.isNegation(expression2) && (negated = BoolUtils.getNegated(expression2)) != null && (negatedPush = history.findExpressionPush(negated)) != null) {
            CauseItem cause = new CauseItem("value '" + negated.getText() + "' is always '" + !value2 + "'", (PsiElement)negated);
            cause.addChildren(this.findConstantValueCause(negated, negatedPush, !value2));
            return new CauseItem[]{cause};
        }
        if (expression2 instanceof PsiPolyadicExpression && ((and = (tokenType = ((PsiPolyadicExpression)expression2).getOperationTokenType()).equals(JavaTokenType.ANDAND)) || tokenType.equals(JavaTokenType.OROR))) {
            PsiExpression[] operands2 = ((PsiPolyadicExpression)expression2).getOperands();
            ArrayList<CauseItem> operandCauses = new ArrayList<CauseItem>();
            for (int i = 0; i < operands2.length; ++i) {
                PsiExpression operand3 = operands2[i];
                TrackingDfaMemoryState.MemoryStateChange push = history.findExpressionPush(operand3 = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand3));
                if (push == null || (!(push.myInstruction instanceof ConditionalGotoInstruction) || !((ConditionalGotoInstruction)push.myInstruction).isTarget(value2, history.myInstruction)) && !DfConstantType.isConst(push.myTopOfStack.getDfType(), value2)) continue;
                CauseItem cause = new CauseItem("operand #" + (i + 1) + " of " + (and ? "&&" : "||") + "-chain is " + value2, (PsiElement)operand3);
                cause.addChildren(this.findBooleanResultCauses(operand3, push, value2));
                operandCauses.add(cause);
            }
            if (value2 != and && !operandCauses.isEmpty()) {
                return new CauseItem[]{(CauseItem)operandCauses.get(0)};
            }
            if (operandCauses.size() == operands2.length) {
                return operandCauses.toArray(new CauseItem[0]);
            }
        }
        if (expression2 instanceof PsiBinaryExpression && (relationType = RelationType.fromElementType((binOp = (PsiBinaryExpression)expression2).getOperationTokenType())) != null) {
            if (!value2) {
                relationType = relationType.getNegated();
            }
            PsiExpression leftOperand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
            PsiExpression rightOperand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
            TrackingDfaMemoryState.MemoryStateChange leftChange = history.findExpressionPush(leftOperand2);
            TrackingDfaMemoryState.MemoryStateChange rightChange = history.findExpressionPush(rightOperand2);
            if (leftChange != null && rightChange != null) {
                DfaValue leftValue = leftChange.myTopOfStack;
                DfaValue rightValue = rightChange.myTopOfStack;
                CauseItem[] causes = this.findRelationCause(relationType, leftChange, rightChange);
                if (causes.length > 0) {
                    return causes;
                }
                if (leftValue == rightValue && (leftValue instanceof DfaVariableValue || leftValue.getDfType() instanceof DfConstantType)) {
                    ArrayList constCauses = new ArrayList();
                    CauseItem leftCause = TrackingRunner.constantInitializerCause(leftValue, leftChange.getExpression());
                    CauseItem rightCause = TrackingRunner.constantInitializerCause(rightValue, rightChange.getExpression());
                    ContainerUtil.addAllNotNull(constCauses, (Object[])new CauseItem[]{leftCause, rightCause});
                    if (constCauses.isEmpty()) {
                        return new CauseItem[]{new CauseItem("comparison arguments are the same", (PsiElement)binOp.getOperationSign())};
                    }
                    return constCauses.toArray(new CauseItem[0]);
                }
                if (leftValue != rightValue && relationType.isInequality() && leftValue.getDfType() instanceof DfConstantType && rightValue.getDfType() instanceof DfConstantType) {
                    CauseItem causeItem = new CauseItem("comparison arguments are different constants", (PsiElement)binOp.getOperationSign());
                    causeItem.addChildren(TrackingRunner.constantInitializerCause(leftValue, leftChange.getExpression()), TrackingRunner.constantInitializerCause(rightValue, rightChange.getExpression()));
                    return new CauseItem[]{causeItem};
                }
            }
        }
        if (expression2 instanceof PsiInstanceOfExpression && (operandHistory = history.findExpressionPush(operand2 = (instanceOfExpression = (PsiInstanceOfExpression)expression2).getOperand())) != null) {
            PsiType type2;
            CauseItem causeItem;
            PsiTypeElement typeElement;
            DfaValue operandValue = operandHistory.myTopOfStack;
            if (!value2) {
                TrackingDfaMemoryState.FactDefinition<DfaNullability> nullability = operandHistory.findFact(operandValue, TrackingDfaMemoryState.FactExtractor.nullability());
                if (nullability.myFact == DfaNullability.NULL) {
                    CauseItem causeItem2 = new CauseItem("value '" + operand2.getText() + "' is always 'null'", (PsiElement)operand2);
                    causeItem2.addChildren(this.findConstantValueCause(operand2, operandHistory, null));
                    return new CauseItem[]{causeItem2};
                }
            }
            if ((typeElement = instanceOfExpression.getCheckType()) != null && (causeItem = TrackingRunner.findTypeCause(operandHistory, type2 = typeElement.getType(), value2)) != null) {
                return new CauseItem[]{causeItem};
            }
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            return new CauseItem[]{this.fromCallContract(history, (PsiCallExpression)((PsiMethodCallExpression)expression2), ContractReturnValue.returnBoolean(value2))};
        }
        return new CauseItem[0];
    }

    private static CauseItem constantInitializerCause(DfaValue value2, PsiExpression ref) {
        PsiExpression initializer;
        PsiElement target;
        if (!(value2.getDfType() instanceof DfConstantType)) {
            return null;
        }
        if (ref instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)ref).resolve()) instanceof PsiVariable && ((PsiVariable)target).hasModifierProperty("final") && (initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiVariable)target).getInitializer())) != null) {
            return new CauseItem(TrackingRunner.getElementTitle(target) + " '" + ((PsiVariable)target).getName() + "' is initialized to " + initializer.getText(), (PsiElement)(initializer.getContainingFile() == ref.getContainingFile() ? initializer : ref));
        }
        return null;
    }

    @Nullable
    private static CauseItem findTypeCause(TrackingDfaMemoryState.MemoryStateChange operandHistory, PsiType type2, boolean isInstance) {
        TrackingDfaMemoryState.MemoryStateChange prevHistory;
        TrackingDfaMemoryState.MemoryStateChange causeLocation;
        TypeConstraint constraint;
        String explanation;
        PsiExpression operand2 = Objects.requireNonNull(operandHistory.getExpression());
        TypeConstraint wanted = TypeConstraints.instanceOf(type2);
        PsiType operandType = operand2.getType();
        if (operandType != null && (explanation = (constraint = TypeConstraints.instanceOf(operandType)).getAssignabilityExplanation(wanted, isInstance)) != null) {
            String name2 = "an expression";
            if (operand2 instanceof PsiMethodCallExpression) {
                name2 = "method return";
            } else if (operand2 instanceof PsiReferenceExpression) {
                name2 = TrackingRunner.getElementTitle(((PsiReferenceExpression)operand2).resolve());
            }
            if (constraint.equals(wanted)) {
                explanation = "type is " + constraint.toShortString();
            }
            return new CauseItem(name2 + " " + explanation, (PsiElement)operand2);
        }
        DfaValue operandValue = operandHistory.myTopOfStack;
        TrackingDfaMemoryState.FactDefinition<TypeConstraint> fact = operandHistory.findFact(operandValue, TrackingDfaMemoryState.FactExtractor.constraint());
        String explanation2 = ((TypeConstraint)fact.myFact).getAssignabilityExplanation(wanted, isInstance);
        while (explanation2 != null && (causeLocation = fact.myChange) != null && (prevHistory = causeLocation.getPrevious()) != null) {
            fact = prevHistory.findFact(operandValue, TrackingDfaMemoryState.FactExtractor.constraint());
            TypeConstraint prevConstraint = (TypeConstraint)fact.myFact;
            String prevExplanation = prevConstraint.getAssignabilityExplanation(wanted, isInstance);
            if (prevExplanation == null) {
                TrackingDfaMemoryState.MemoryStateChange rValuePush;
                PsiExpression rExpression;
                if (causeLocation.myInstruction instanceof AssignInstruction && causeLocation.myTopOfStack == operandValue && (rExpression = ((AssignInstruction)causeLocation.myInstruction).getRExpression()) != null && (rValuePush = causeLocation.findSubExpressionPush(rExpression)) != null) {
                    CauseItem assignmentItem = TrackingRunner.createAssignmentCause((AssignInstruction)causeLocation.myInstruction, operandValue);
                    assignmentItem.addChildren(TrackingRunner.findTypeCause(rValuePush, type2, isInstance));
                    return assignmentItem;
                }
                CauseItem causeItem = new CauseItem("an object " + explanation2, (PsiElement)operand2);
                causeItem.addChildren(new CauseItem("type of '" + operand2.getText() + "' is known from #ref", causeLocation));
                return causeItem;
            }
            explanation2 = prevExplanation;
        }
        return null;
    }

    private static String getElementTitle(PsiElement target) {
        return JavaElementKind.fromElement((PsiElement)target).subject();
    }

    private CauseItem @NotNull [] findRelationCause(RelationType relationType, TrackingDfaMemoryState.MemoryStateChange leftChange, TrackingDfaMemoryState.MemoryStateChange rightChange) {
        return this.findRelationCause(relationType, leftChange, leftChange.myTopOfStack, rightChange, rightChange.myTopOfStack);
    }

    private CauseItem @NotNull [] findRelationCause(RelationType relationType, TrackingDfaMemoryState.MemoryStateChange leftChange, DfaValue leftValue, TrackingDfaMemoryState.MemoryStateChange rightChange, DfaValue rightValue) {
        TrackingDfaMemoryState.Relation relation;
        TrackingDfaMemoryState.MemoryStateChange change;
        ProgressManager.checkCanceled();
        TrackingDfaMemoryState.FactDefinition<DfaNullability> leftNullability = leftChange.findFact(leftValue, TrackingDfaMemoryState.FactExtractor.nullability());
        TrackingDfaMemoryState.FactDefinition<DfaNullability> rightNullability = rightChange.findFact(rightValue, TrackingDfaMemoryState.FactExtractor.nullability());
        if (leftNullability.myFact == DfaNullability.NULL && rightNullability.myFact == DfaNullability.NOT_NULL || rightNullability.myFact == DfaNullability.NULL && leftNullability.myFact == DfaNullability.NOT_NULL) {
            CauseItem[] causeItemArray = new CauseItem[]{this.findNullabilityCause(leftChange, (DfaNullability)((Object)leftNullability.myFact)), this.findNullabilityCause(rightChange, (DfaNullability)((Object)rightNullability.myFact))};
            if (causeItemArray == null) {
                TrackingRunner.$$$reportNull$$$0(8);
            }
            return causeItemArray;
        }
        TrackingDfaMemoryState.FactDefinition<LongRangeSet> leftRange = leftChange.findFact(leftValue, TrackingDfaMemoryState.FactExtractor.range());
        TrackingDfaMemoryState.FactDefinition<LongRangeSet> rightRange = rightChange.findFact(rightValue, TrackingDfaMemoryState.FactExtractor.range());
        LongRangeSet fromRelation = ((LongRangeSet)rightRange.myFact).fromRelation(relationType.getNegated());
        if (fromRelation != null && !fromRelation.intersects((LongRangeSet)leftRange.myFact)) {
            CauseItem[] causeItemArray = new CauseItem[]{TrackingRunner.findRangeCause(leftChange, leftValue, (LongRangeSet)leftRange.myFact, "left operand is %s"), TrackingRunner.findRangeCause(rightChange, rightValue, (LongRangeSet)rightRange.myFact, "right operand is %s")};
            if (causeItemArray == null) {
                TrackingRunner.$$$reportNull$$$0(9);
            }
            return causeItemArray;
        }
        if (leftValue instanceof DfaVariableValue && (change = TrackingRunner.findRelationAddedChange(leftChange, (DfaVariableValue)leftValue, relation = new TrackingDfaMemoryState.Relation(relationType, rightValue))) != null) {
            DfaValue target;
            PsiExpression expression2;
            TrackingDfaMemoryState.MemoryStateChange assignmentChange;
            Instruction instruction;
            CauseItem cause = this.findRelationCause(change, (DfaVariableValue)leftValue, relation, rightChange);
            if (cause != null && (instruction = change.myInstruction) instanceof AssignInstruction && (assignmentChange = change.findExpressionPush(expression2 = ((AssignInstruction)instruction).getRExpression())) != null && (target = change.myTopOfStack) == rightValue) {
                CauseItem[] causeItemArray = (CauseItem[])ArrayUtil.prepend((Object)cause, (Object[])this.findRelationCause(relationType, leftChange, assignmentChange));
                if (causeItemArray == null) {
                    TrackingRunner.$$$reportNull$$$0(10);
                }
                return causeItemArray;
            }
            CauseItem[] causeItemArray = new CauseItem[]{cause};
            if (causeItemArray == null) {
                TrackingRunner.$$$reportNull$$$0(11);
            }
            return causeItemArray;
        }
        if (rightValue instanceof DfaVariableValue && (change = TrackingRunner.findRelationAddedChange(rightChange, (DfaVariableValue)rightValue, relation = new TrackingDfaMemoryState.Relation(Objects.requireNonNull(relationType.getFlipped()), leftValue))) != null) {
            CauseItem[] causeItemArray = new CauseItem[]{this.findRelationCause(change, (DfaVariableValue)rightValue, relation, leftChange)};
            if (causeItemArray == null) {
                TrackingRunner.$$$reportNull$$$0(12);
            }
            return causeItemArray;
        }
        if (relationType == RelationType.NE) {
            DfaValue rightSpecial;
            DfaValue leftSpecial;
            CauseItem[] specialCause;
            SpecialField leftField = SpecialField.fromQualifier(leftValue);
            SpecialField rightField = SpecialField.fromQualifier(rightValue);
            if (leftField != null && leftField == rightField && (specialCause = this.findRelationCause(relationType, leftChange, leftSpecial = leftField.createValue(this.getFactory(), leftValue), rightChange, rightSpecial = rightField.createValue(this.getFactory(), rightValue))).length > 0) {
                CauseItem item = new CauseItem("values cannot be equal because " + leftValue + "." + leftField + " != " + rightValue + "." + rightField, (PsiElement)null);
                item.addChildren(specialCause);
                CauseItem[] causeItemArray = new CauseItem[]{item};
                if (causeItemArray == null) {
                    TrackingRunner.$$$reportNull$$$0(13);
                }
                return causeItemArray;
            }
        }
        return new CauseItem[0];
    }

    private CauseItem findRelationCause(TrackingDfaMemoryState.MemoryStateChange change, DfaVariableValue value2, TrackingDfaMemoryState.Relation relation, TrackingDfaMemoryState.MemoryStateChange counterPartChange) {
        PsiExpression expression2;
        Instruction instruction = change.myInstruction;
        String condition2 = value2 + " " + relation;
        if (instruction instanceof AssignInstruction) {
            DfaValue target = change.myTopOfStack;
            PsiExpression rValue = ((AssignInstruction)instruction).getRExpression();
            CauseItem item = TrackingRunner.createAssignmentCause((AssignInstruction)instruction, target);
            if (target == value2) {
                TrackingDfaMemoryState.MemoryStateChange rValuePush = change.findSubExpressionPush(rValue);
                if (rValuePush != null) {
                    item.addChildren(this.findRelationCause(relation.myRelationType, rValuePush, counterPartChange));
                }
                return item;
            }
            if (target == relation.myCounterpart) {
                return item;
            }
        }
        if ((expression2 = change.getExpression()) != null) {
            List<DfaRelation> chain;
            DfaRelation rel;
            Collection<DfaRelation> relations = Collections.emptyList();
            if (expression2 instanceof PsiBinaryExpression && (rel = TrackingRunner.getBinaryExpressionRelation(change, (PsiBinaryExpression)expression2)) != null) {
                if (TrackingRunner.isSameRelation(rel, value2, relation)) {
                    return new CauseItem((DfaProblemType)new CustomDfaProblemType("condition '" + condition2 + "' was checked before"), (PsiElement)expression2);
                }
                relations = Collections.singleton(rel);
            }
            if (expression2 instanceof PsiCallExpression) {
                relations = this.getCallRelations((PsiCallExpression)expression2);
            }
            if (!(chain = TrackingRunner.findDeductionChain(change, relations, value2, relation)).isEmpty()) {
                Object[] result = new CauseItem[]{};
                for (DfaRelation deduced : chain) {
                    Object[] cause = this.findRelationCause(deduced.getRelation(), change, deduced.getLeftOperand(), change, deduced.getRightOperand());
                    result = (CauseItem[])ArrayUtil.mergeArrays((Object[])result, (Object[])cause);
                }
                if (result.length > 1) {
                    CauseItem item = new CauseItem((DfaProblemType)new CustomDfaProblemType("condition '" + condition2 + "' was deduced"), (PsiElement)null);
                    item.addChildren((CauseItem[])result);
                    return item;
                }
            }
            return new CauseItem((DfaProblemType)new CustomDfaProblemType("it's known that '" + condition2 + "' from #ref"), (PsiElement)expression2);
        }
        return null;
    }

    private static List<DfaRelation> findDeductionChain(TrackingDfaMemoryState.MemoryStateChange change, Collection<DfaRelation> knownRelations, DfaVariableValue value2, TrackingDfaMemoryState.Relation relation) {
        for (DfaRelation rel : knownRelations) {
            if (TrackingRunner.isSameRelation(rel, value2, relation)) continue;
            for (Map.Entry<DfaVariableValue, TrackingDfaMemoryState.Change> entry : change.myChanges.entrySet()) {
                DfaVariableValue actualVar = entry.getKey();
                for (TrackingDfaMemoryState.Relation actualRelation : entry.getValue().myAddedRelations) {
                    DfaValue right;
                    DfaValue left;
                    RelationType type2;
                    if (!TrackingRunner.isSameRelation(rel, actualVar, actualRelation)) continue;
                    if (actualRelation.myRelationType == RelationType.EQ || relation.myRelationType != RelationType.NE && relation.myRelationType == actualRelation.myRelationType) {
                        type2 = relation.myRelationType;
                    } else {
                        if (relation.myRelationType != RelationType.EQ) continue;
                        type2 = actualRelation.myRelationType;
                    }
                    if (actualVar == value2) {
                        left = actualRelation.myCounterpart;
                        right = relation.myCounterpart;
                    } else if (actualVar == relation.myCounterpart) {
                        left = value2;
                        right = actualRelation.myCounterpart;
                    } else if (actualRelation.myCounterpart == relation.myCounterpart) {
                        left = value2;
                        right = actualVar;
                    } else {
                        if (actualRelation.myCounterpart != value2) continue;
                        left = actualVar;
                        right = relation.myCounterpart;
                    }
                    DfaRelation rel1 = DfaRelation.createRelation(left, type2, right);
                    DfaRelation rel2 = DfaRelation.createRelation(actualVar, actualRelation.myRelationType, actualRelation.myCounterpart);
                    return StreamEx.of((Object[])new DfaRelation[]{rel1, rel2}).nonNull().toImmutableList();
                }
            }
        }
        return Collections.emptyList();
    }

    private static boolean isSameRelation(DfaRelation dfaRel, DfaVariableValue var, TrackingDfaMemoryState.Relation relation) {
        DfaValue counterpart;
        RelationType type2;
        if (dfaRel.getLeftOperand() == var) {
            type2 = dfaRel.getRelation();
            counterpart = dfaRel.getRightOperand();
        } else if (dfaRel.getRightOperand() == var) {
            type2 = dfaRel.getRelation().getFlipped();
            counterpart = dfaRel.getLeftOperand();
        } else {
            return false;
        }
        return counterpart == relation.myCounterpart && type2 != null;
    }

    @Nullable
    private static DfaRelation getBinaryExpressionRelation(TrackingDfaMemoryState.MemoryStateChange change, PsiBinaryExpression binOp) {
        PsiExpression lOperand = binOp.getLOperand();
        PsiExpression rOperand = binOp.getROperand();
        TrackingDfaMemoryState.MemoryStateChange leftPos = change.findExpressionPush(lOperand);
        TrackingDfaMemoryState.MemoryStateChange rightPos = change.findExpressionPush(rOperand);
        if (leftPos != null && rightPos != null) {
            DfaValue leftValue = leftPos.myTopOfStack;
            DfaValue rightValue = rightPos.myTopOfStack;
            RelationType type2 = RelationType.fromElementType(binOp.getOperationTokenType());
            if (type2 != null) {
                return DfaRelation.createRelation(leftValue, type2, rightValue);
            }
        }
        return null;
    }

    private Collection<DfaRelation> getCallRelations(PsiCallExpression callExpression) {
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts(callExpression);
        LinkedHashSet<DfaRelation> results = new LinkedHashSet<DfaRelation>();
        for (MethodContract methodContract : contracts2) {
            for (ContractValue condition2 : methodContract.getConditions()) {
                DfaCondition rel = condition2.fromCall(this.getFactory(), callExpression);
                ContainerUtil.addIfNotNull(results, (Object)ObjectUtils.tryCast((Object)rel, DfaRelation.class));
            }
        }
        return results;
    }

    private CauseItem findNullabilityCause(TrackingDfaMemoryState.MemoryStateChange factUse, DfaNullability nullability) {
        TrackingDfaMemoryState.MemoryStateChange factDef;
        CauseItem causeItem;
        PsiVariable variable;
        TrackingDfaMemoryState.MemoryStateChange operandPush;
        PsiExpression expression2 = factUse.getExpression();
        if (expression2 instanceof PsiTypeCastExpression && (operandPush = factUse.findSubExpressionPush(((PsiTypeCastExpression)expression2).getOperand())) != null) {
            return this.findNullabilityCause(operandPush, nullability);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            PsiMethod method = call.resolveMethod();
            CauseItem causeItem2 = this.fromMemberNullability(nullability, (PsiModifierListOwner)method, JavaElementKind.METHOD, call.getMethodExpression().getReferenceNameElement());
            if (causeItem2 == null) {
                switch (nullability) {
                    case NULL: 
                    case NULLABLE: {
                        causeItem2 = this.fromCallContract(factUse, (PsiCallExpression)call, ContractReturnValue.returnNull());
                        break;
                    }
                    case NOT_NULL: {
                        causeItem2 = this.fromCallContract(factUse, (PsiCallExpression)call, ContractReturnValue.returnNotNull());
                        break;
                    }
                }
            }
            if (causeItem2 != null) {
                return causeItem2;
            }
        }
        if (expression2 instanceof PsiReferenceExpression && (variable = (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)expression2).resolve(), PsiVariable.class)) != null && (causeItem = this.fromMemberNullability(nullability, (PsiModifierListOwner)variable, JavaElementKind.fromElement((PsiElement)variable), (PsiElement)expression2)) != null) {
            return causeItem;
        }
        TrackingDfaMemoryState.FactDefinition<DfaNullability> info = factUse.findFact(factUse.myTopOfStack, TrackingDfaMemoryState.FactExtractor.nullability());
        TrackingDfaMemoryState.MemoryStateChange memoryStateChange = factDef = info.myFact == nullability ? info.myChange : null;
        if (nullability == DfaNullability.NOT_NULL) {
            String explanation = TrackingRunner.getObviouslyNonNullExplanation(expression2);
            if (explanation != null) {
                return new CauseItem("expression cannot be null as it's " + explanation, (PsiElement)expression2);
            }
            if (factDef != null) {
                if (factDef.myInstruction instanceof CheckNotNullInstruction) {
                    String text2;
                    NullabilityProblemKind.NullabilityProblem<?> problem = ((CheckNotNullInstruction)factDef.myInstruction).getProblem();
                    PsiExpression dereferenced = problem.getDereferencedExpression();
                    String string = text2 = dereferenced == null ? factUse.myTopOfStack.toString() : dereferenced.getText();
                    if (dereferenced != null && problem.getKind() == NullabilityProblemKind.passingToNotNullParameter) {
                        PsiExpression arg = dereferenced;
                        while (arg.getParent() instanceof PsiParenthesizedExpression) {
                            arg = (PsiExpression)arg.getParent();
                        }
                        PsiParameter parameter2 = MethodCallUtils.getParameterForArgument(dereferenced);
                        if (parameter2 != null) {
                            CauseItem item = new CauseItem("'" + text2 + "' was passed as an argument to a method accepting non-null parameter", (PsiElement)dereferenced);
                            item.addChildren(this.fromMemberNullability(DfaNullability.NOT_NULL, (PsiModifierListOwner)parameter2, JavaElementKind.PARAMETER, (PsiElement)dereferenced));
                            return item;
                        }
                    }
                    return new CauseItem("'" + text2 + "' was dereferenced", (PsiElement)dereferenced);
                }
                if (factDef.myInstruction instanceof InstanceofInstruction) {
                    Object operand2 = ((InstanceofInstruction)factDef.myInstruction).getExpression();
                    return new CauseItem("the 'instanceof' check implies non-nullity", (PsiElement)operand2);
                }
            }
        }
        if (factDef != null && expression2 != null) {
            TrackingDfaMemoryState.MemoryStateChange rValuePush;
            PsiExpression rExpression;
            DfaValue value2 = factUse.myTopOfStack;
            if (factDef.myInstruction instanceof AssignInstruction && factDef.myTopOfStack == value2 && (rExpression = ((AssignInstruction)factDef.myInstruction).getRExpression()) != null && (rValuePush = factDef.findSubExpressionPush(rExpression)) != null) {
                CauseItem assignmentItem = TrackingRunner.createAssignmentCause((AssignInstruction)factDef.myInstruction, value2);
                assignmentItem.addChildren(this.findNullabilityCause(rValuePush, nullability));
                return assignmentItem;
            }
            PsiExpression defExpression = factDef.getExpression();
            if (defExpression != null) {
                return new CauseItem("'" + expression2.getText() + "' is known to be '" + nullability.getPresentationName() + "' from #ref", (PsiElement)defExpression);
            }
        }
        return null;
    }

    private CauseItem fromMemberNullability(DfaNullability nullability, PsiModifierListOwner owner2, JavaElementKind memberKind, PsiElement anchor) {
        if (owner2 != null) {
            NullabilityAnnotationInfo info = NullableNotNullManager.getInstance((Project)owner2.getProject()).findEffectiveNullabilityInfo(owner2);
            String name2 = ((PsiNamedElement)owner2).getName();
            if (info != null && DfaNullability.fromNullability(info.getNullability()) == nullability) {
                String message2;
                if (info.isInferred()) {
                    if (owner2 instanceof PsiParameter && anchor instanceof PsiReferenceExpression && ((PsiReferenceExpression)anchor).isReferenceTo((PsiElement)owner2)) {
                        return null;
                    }
                    message2 = memberKind.subject() + " '" + name2 + "' was inferred to be '" + nullability.getPresentationName() + "'";
                } else if (info.isExternal()) {
                    message2 = memberKind.subject() + " '" + name2 + "' is externally annotated as '" + nullability.getPresentationName() + "'";
                } else if (info.isContainer()) {
                    PsiElement parent;
                    PsiAnnotationOwner annoOwner = info.getAnnotation().getOwner();
                    String details = "container annotation";
                    if (annoOwner instanceof PsiModifierList && (parent = ((PsiModifierList)annoOwner).getParent()) instanceof PsiClass) {
                        PsiFile file;
                        PsiClass aClass = (PsiClass)parent;
                        details = "annotation from class " + aClass.getName();
                        if ("package-info".equals(aClass.getName()) && (file = aClass.getContainingFile()) instanceof PsiJavaFile) {
                            details = "annotation from package " + ((PsiJavaFile)file).getPackageName();
                        }
                    }
                    if (annoOwner instanceof PsiNamedElement) {
                        details = " from " + ((PsiNamedElement)annoOwner).getName();
                    }
                    message2 = memberKind.subject() + " '" + name2 + "' inherits " + details + ", thus '" + nullability.getPresentationName() + "'";
                } else {
                    message2 = memberKind.subject() + " '" + name2 + "' is annotated as '" + nullability.getPresentationName() + "'";
                }
                if (info.getAnnotation().getContainingFile() == anchor.getContainingFile()) {
                    anchor = info.getAnnotation();
                } else if (owner2.getContainingFile() == anchor.getContainingFile() && (anchor = owner2.getNavigationElement()) instanceof PsiNameIdentifierOwner) {
                    anchor = ((PsiNameIdentifierOwner)anchor).getNameIdentifier();
                }
                return new CauseItem(message2, anchor);
            }
            if (owner2 instanceof PsiField && this.getFactory().canTrustFieldInitializer((PsiField)owner2)) {
                Pair<PsiExpression, Nullability> fieldNullability = NullabilityUtil.getNullabilityFromFieldInitializers((PsiField)owner2, Nullability.UNKNOWN);
                if (fieldNullability.second == DfaNullability.toNullability(nullability)) {
                    PsiExpression initializer = (PsiExpression)fieldNullability.first;
                    if (initializer != null) {
                        if (initializer.getContainingFile() == anchor.getContainingFile()) {
                            anchor = initializer;
                        }
                        return new CauseItem("field '" + name2 + "' is initialized to '" + DfaNullability.fromNullability((Nullability)fieldNullability.second).getPresentationName() + "' value", anchor);
                    }
                    if (owner2.getContainingFile() == anchor.getContainingFile()) {
                        anchor = owner2;
                    }
                    return new CauseItem("field '" + name2 + "' is known to be always initialized to '" + DfaNullability.fromNullability((Nullability)fieldNullability.second).getPresentationName() + "' value", anchor);
                }
            }
        }
        return null;
    }

    private CauseItem fromCallContract(TrackingDfaMemoryState.MemoryStateChange history, PsiCallExpression call, ContractReturnValue contractReturnValue) {
        String contractType;
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts(method, call);
        if (contracts2.isEmpty()) {
            return null;
        }
        MethodContract contract = contracts2.get(0);
        String string = JavaMethodContractUtil.hasExplicitContractAnnotation(method) ? "" : (contractType = contracts2.stream().allMatch(c -> c instanceof StandardMethodContract) ? "inferred " : "hard-coded ");
        if (call instanceof PsiMethodCallExpression) {
            MethodContract onlyContract;
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)call).getMethodExpression();
            String name2 = methodExpression.getReferenceName();
            String prefix = "according to " + contractType + "contract, method '" + name2 + "'";
            if (contracts2.size() == 1 && contract.isTrivial() && contractReturnValue.isSuperValueOf(contract.getReturnValue())) {
                return new CauseItem(prefix + " always returns '" + contract.getReturnValue() + "' value", methodExpression.getReferenceNameElement());
            }
            List<? extends MethodContract> nonIntersecting = MethodContract.toNonIntersectingContracts(contracts2);
            if (nonIntersecting != null && (onlyContract = (MethodContract)ContainerUtil.getOnlyItem((Collection)ContainerUtil.filter(nonIntersecting, mc -> contractReturnValue.isSuperValueOf(mc.getReturnValue())))) != null) {
                return this.fromSingleContract(history, (PsiMethodCallExpression)call, method, prefix, onlyContract);
            }
            for (MethodContract methodContract : contracts2) {
                ThreeState applies = this.contractApplies((PsiMethodCallExpression)call, methodContract);
                if (applies == ThreeState.NO) continue;
                if (applies == ThreeState.UNSURE) break;
                if (applies != ThreeState.YES || !contractReturnValue.isSuperValueOf(methodContract.getReturnValue())) continue;
                return this.fromSingleContract(history, (PsiMethodCallExpression)call, method, prefix, methodContract);
            }
        }
        return null;
    }

    @NotNull
    private ThreeState contractApplies(@NotNull PsiMethodCallExpression call, @NotNull MethodContract contract) {
        if (call == null) {
            TrackingRunner.$$$reportNull$$$0(14);
        }
        if (contract == null) {
            TrackingRunner.$$$reportNull$$$0(15);
        }
        List<ContractValue> conditions = contract.getConditions();
        for (ContractValue condition2 : conditions) {
            DfaCondition cond = condition2.fromCall(this.getFactory(), (PsiCallExpression)call);
            if (cond == DfaCondition.getTrue()) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    TrackingRunner.$$$reportNull$$$0(16);
                }
                return threeState;
            }
            if (cond != DfaCondition.getFalse()) continue;
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                TrackingRunner.$$$reportNull$$$0(17);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            TrackingRunner.$$$reportNull$$$0(18);
        }
        return threeState;
    }

    @NotNull
    private CauseItem fromSingleContract(@NotNull TrackingDfaMemoryState.MemoryStateChange history, @NotNull PsiMethodCallExpression call, @NotNull PsiMethod method, @NotNull String prefix, @NotNull MethodContract contract) {
        if (history == null) {
            TrackingRunner.$$$reportNull$$$0(19);
        }
        if (call == null) {
            TrackingRunner.$$$reportNull$$$0(20);
        }
        if (method == null) {
            TrackingRunner.$$$reportNull$$$0(21);
        }
        if (prefix == null) {
            TrackingRunner.$$$reportNull$$$0(22);
        }
        if (contract == null) {
            TrackingRunner.$$$reportNull$$$0(23);
        }
        List<ContractValue> conditions = contract.getConditions();
        String conditionsText = StringUtil.join(conditions, c -> c.getPresentationText(method), (String)" and ");
        String returnValueText = contract.getReturnValue().isFail() ? "throws exception" : "returns '" + contract.getReturnValue() + "' value";
        CauseItem causeItem = new CauseItem(prefix + " " + returnValueText + " when " + conditionsText, call.getMethodExpression().getReferenceNameElement());
        for (ContractValue condition2 : conditions) {
            DfaRelation relation = (DfaRelation)ObjectUtils.tryCast((Object)condition2.fromCall(this.getFactory(), (PsiCallExpression)call), DfaRelation.class);
            PsiExpression leftPlace = condition2.findLeftPlace((PsiCallExpression)call);
            TrackingDfaMemoryState.MemoryStateChange leftPush = history.findExpressionPush(leftPlace);
            PsiExpression rightPlace = condition2.findRightPlace((PsiCallExpression)call);
            TrackingDfaMemoryState.MemoryStateChange rightPush = history.findExpressionPush(rightPlace);
            if (relation == null) continue;
            DfaValue left = relation.getLeftOperand();
            DfaValue right = relation.getRightOperand();
            RelationType type2 = relation.getRelation();
            TrackingDfaMemoryState.MemoryStateChange leftChange = history;
            TrackingDfaMemoryState.MemoryStateChange rightChange = history;
            if (leftPush != null) {
                if (leftPush.myTopOfStack == left) {
                    leftChange = leftPush;
                } else if (leftPush.myTopOfStack == right) {
                    rightChange = leftPush;
                }
            }
            if (rightPush != null) {
                if (rightPush.myTopOfStack == right) {
                    rightChange = rightPush;
                } else if (rightPush.myTopOfStack == left) {
                    leftChange = rightPush;
                }
            }
            causeItem.addChildren(this.findRelationCause(type2, leftChange, left, rightChange, right));
        }
        CauseItem causeItem2 = causeItem;
        if (causeItem2 == null) {
            TrackingRunner.$$$reportNull$$$0(24);
        }
        return causeItem2;
    }

    private static CauseItem findRangeCause(TrackingDfaMemoryState.MemoryStateChange factUse, DfaValue value2, LongRangeSet range, String template) {
        TrackingDfaMemoryState.MemoryStateChange factDef;
        PsiType type2;
        PsiExpression expression2;
        VariableDescriptor descriptor;
        if (value2 instanceof DfaVariableValue && (descriptor = ((DfaVariableValue)value2).getDescriptor()) instanceof SpecialField && range.equals(LongRangeSet.indexRange())) {
            switch ((SpecialField)descriptor) {
                case ARRAY_LENGTH: {
                    return new CauseItem("array length is always non-negative", factUse);
                }
                case STRING_LENGTH: {
                    return new CauseItem("string length is always non-negative", factUse);
                }
                case COLLECTION_SIZE: {
                    return new CauseItem("collection size is always non-negative", factUse);
                }
            }
        }
        PsiExpression psiExpression = expression2 = factUse.myTopOfStack == value2 ? factUse.getExpression() : null;
        if (expression2 != null) {
            PsiExpression operand2;
            TrackingDfaMemoryState.MemoryStateChange operandPush;
            LongRangeSet fromAnnotation;
            PsiMethodCallExpression call;
            PsiMethod method;
            type2 = expression2.getType();
            if (expression2 instanceof PsiLiteralExpression) {
                return null;
            }
            if (expression2 instanceof PsiMethodCallExpression && (method = (call = (PsiMethodCallExpression)expression2).resolveMethod()) != null && (fromAnnotation = LongRangeSet.fromPsiElement((PsiModifierListOwner)method)).equals(range)) {
                return new CauseItem("the range of '" + method.getName() + "' is specified by annotation as " + range, call.getMethodExpression().getReferenceNameElement());
            }
            if (expression2 instanceof PsiTypeCastExpression && type2 instanceof PsiPrimitiveType && TypeConversionUtil.isNumericType((PsiType)type2) && (operandPush = factUse.findExpressionPush(operand2 = ((PsiTypeCastExpression)expression2).getOperand())) != null) {
                DfaValue castedValue = operandPush.myTopOfStack;
                TrackingDfaMemoryState.FactDefinition<LongRangeSet> operandInfo = operandPush.findFact(castedValue, TrackingDfaMemoryState.FactExtractor.range());
                LongRangeSet operandRange = (LongRangeSet)operandInfo.myFact;
                LongRangeSet result = operandRange.castTo((PsiPrimitiveType)type2);
                if (range.equals(result)) {
                    CauseItem cause = new CauseItem((DfaProblemType)new RangeDfaProblemType("result of '(" + type2.getCanonicalText() + ")' cast is %s", range, null), (PsiElement)expression2);
                    if (!operandRange.equals(LongRangeSet.fromType(operand2.getType()))) {
                        cause.addChildren(TrackingRunner.findRangeCause(operandPush, castedValue, operandRange, "cast operand is %s"));
                    }
                    return cause;
                }
            }
            if (range.equals(LongRangeSet.fromType(type2))) {
                return null;
            }
            if ((PsiType.LONG.equals((Object)type2) || PsiType.INT.equals((Object)type2)) && expression2 instanceof PsiBinaryExpression) {
                boolean isLong = PsiType.LONG.equals((Object)type2);
                PsiBinaryExpression binOp = (PsiBinaryExpression)expression2;
                PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
                PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
                TrackingDfaMemoryState.MemoryStateChange leftPush = factUse.findExpressionPush(left);
                TrackingDfaMemoryState.MemoryStateChange rightPush = factUse.findExpressionPush(right);
                if (leftPush != null && rightPush != null) {
                    DfaValue leftVal = leftPush.myTopOfStack;
                    TrackingDfaMemoryState.FactDefinition<LongRangeSet> leftSet = leftPush.findFact(leftVal, TrackingDfaMemoryState.FactExtractor.range());
                    DfaValue rightVal = rightPush.myTopOfStack;
                    TrackingDfaMemoryState.FactDefinition<LongRangeSet> rightSet = rightPush.findFact(rightVal, TrackingDfaMemoryState.FactExtractor.range());
                    LongRangeSet fromType = Objects.requireNonNull(LongRangeSet.fromType(type2));
                    LongRangeSet leftRange = ((LongRangeSet)leftSet.myFact).intersect(fromType);
                    LongRangeSet rightRange = ((LongRangeSet)rightSet.myFact).intersect(fromType);
                    LongRangeSet result = leftRange.binOpFromToken(binOp.getOperationTokenType(), rightRange, isLong);
                    if (range.equals(result)) {
                        String sign = binOp.getOperationSign().getText();
                        CauseItem cause = new CauseItem((DfaProblemType)new RangeDfaProblemType("result of '" + (sign.equals("%") ? "%%" : sign) + "' is %s", range, (PsiPrimitiveType)ObjectUtils.tryCast((Object)type2, PsiPrimitiveType.class)), factUse);
                        CauseItem leftCause = null;
                        CauseItem rightCause = null;
                        if (!leftRange.equals(fromType)) {
                            leftCause = TrackingRunner.findRangeCause(leftPush, leftVal, leftRange, "left operand is %s");
                        }
                        if (!rightRange.equals(fromType)) {
                            rightCause = TrackingRunner.findRangeCause(rightPush, rightVal, rightRange, "right operand is %s");
                        }
                        cause.addChildren(leftCause, rightCause);
                        return cause;
                    }
                }
            }
        }
        type2 = expression2 != null ? (PsiPrimitiveType)ObjectUtils.tryCast((Object)expression2.getType(), PsiPrimitiveType.class) : null;
        CauseItem item = new CauseItem((DfaProblemType)new RangeDfaProblemType(template, range, (PsiPrimitiveType)type2), factUse);
        TrackingDfaMemoryState.FactDefinition<LongRangeSet> info = factUse.findFact(value2, TrackingDfaMemoryState.FactExtractor.range());
        TrackingDfaMemoryState.MemoryStateChange memoryStateChange = factDef = range.equals(info.myFact) ? info.myChange : null;
        if (factDef != null) {
            TrackingDfaMemoryState.MemoryStateChange rValuePush;
            PsiExpression rExpression;
            if (factDef.myInstruction instanceof AssignInstruction && factDef.myTopOfStack == value2 && (rExpression = ((AssignInstruction)factDef.myInstruction).getRExpression()) != null && (rValuePush = factDef.findSubExpressionPush(rExpression)) != null) {
                CauseItem assignmentItem = TrackingRunner.createAssignmentCause((AssignInstruction)factDef.myInstruction, value2);
                assignmentItem.addChildren(TrackingRunner.findRangeCause(rValuePush, rValuePush.myTopOfStack, range, "Value is %s"));
                item.addChildren(assignmentItem);
                return item;
            }
            PsiExpression defExpression = factDef.getExpression();
            if (defExpression != null) {
                item.addChildren(new CauseItem("range is known from #ref", (PsiElement)defExpression));
            }
        }
        return item;
    }

    @Nullable
    public static String getObviouslyNonNullExplanation(PsiExpression arg) {
        if (arg == null || ExpressionUtils.isNullLiteral(arg)) {
            return null;
        }
        if (arg instanceof PsiNewExpression) {
            return "newly created object";
        }
        if (arg instanceof PsiLiteralExpression) {
            return "literal";
        }
        if (arg.getType() instanceof PsiPrimitiveType) {
            return "a value of primitive type '" + arg.getType().getCanonicalText() + "'";
        }
        if (arg instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)arg).getOperationTokenType() == JavaTokenType.PLUS) {
            return "concatenation";
        }
        if (arg instanceof PsiThisExpression) {
            return "'this' object";
        }
        return null;
    }

    private static TrackingDfaMemoryState.MemoryStateChange findRelationAddedChange(TrackingDfaMemoryState.MemoryStateChange history, DfaVariableValue var, TrackingDfaMemoryState.Relation relation) {
        List<RelationType> subRelations;
        switch (relation.myRelationType) {
            case NE: {
                if (relation.myCounterpart.getDfType() instanceof DfConstantType) {
                    return history.findRelation(var, rel -> rel.equals(relation) || rel.myRelationType == RelationType.EQ && rel.myCounterpart.getDfType() instanceof DfConstantType, true);
                }
                subRelations = Arrays.asList(RelationType.NE, RelationType.GT, RelationType.LT);
                break;
            }
            case LE: {
                subRelations = Arrays.asList(RelationType.EQ, RelationType.LT);
                break;
            }
            case GE: {
                subRelations = Arrays.asList(RelationType.EQ, RelationType.GT);
                break;
            }
            default: {
                subRelations = Collections.singletonList(relation.myRelationType);
            }
        }
        return history.findRelation(var, rel -> rel.myCounterpart == relation.myCounterpart && subRelations.contains((Object)rel.myRelationType), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionState";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/TrackingRunner";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contract";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "history";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/TrackingRunner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptInstruction";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findConstantValueCause";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelationCause";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "contractApplies";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "fromSingleContract";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptInstruction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 24: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "contractApplies";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fromSingleContract";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CustomDfaProblemType
    extends DfaProblemType {
        private final String myMessage;

        CustomDfaProblemType(String message2) {
            this.myMessage = message2;
        }

        @Override
        public String toString() {
            return this.myMessage;
        }
    }

    public static class ValueDfaProblemType
    extends DfaProblemType {
        final Object myValue;

        public ValueDfaProblemType(Object value2) {
            this.myValue = value2;
        }

        @Override
        public CauseItem[] findCauses(TrackingRunner runner, PsiExpression expression2, TrackingDfaMemoryState.MemoryStateChange history) {
            return runner.findConstantValueCause(expression2, history, this.myValue);
        }

        @Override
        public String toString() {
            return "value is always " + this.myValue;
        }
    }

    static class RangeDfaProblemType
    extends DfaProblemType {
        @NotNull
        final String myTemplate;
        @NotNull
        final LongRangeSet myRangeSet;
        @Nullable
        final PsiPrimitiveType myType;

        RangeDfaProblemType(@NotNull String template, @NotNull LongRangeSet set, @Nullable PsiPrimitiveType type2) {
            if (template == null) {
                RangeDfaProblemType.$$$reportNull$$$0(0);
            }
            if (set == null) {
                RangeDfaProblemType.$$$reportNull$$$0(1);
            }
            this.myTemplate = template;
            this.myRangeSet = set;
            this.myType = type2;
        }

        @Override
        @Nullable
        DfaProblemType tryMerge(DfaProblemType other) {
            if (other instanceof RangeDfaProblemType) {
                RangeDfaProblemType rangeProblem = (RangeDfaProblemType)other;
                if (this.myTemplate.equals(rangeProblem.myTemplate) && Objects.equals(this.myType, rangeProblem.myType)) {
                    return new RangeDfaProblemType(this.myTemplate, this.myRangeSet.unite(((RangeDfaProblemType)other).myRangeSet), this.myType);
                }
            }
            return super.tryMerge(other);
        }

        @Override
        public String toString() {
            return String.format(this.myTemplate, this.myRangeSet.getPresentationText((PsiType)this.myType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "template";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "set";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/TrackingRunner$RangeDfaProblemType";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class PossibleExecutionDfaProblemType
    extends DfaProblemType {
        boolean myComplete = true;

        PossibleExecutionDfaProblemType() {
        }

        @Override
        public String toString() {
            return this.myComplete ? "one of the following happens:" : "an execution might exist where:";
        }
    }

    public static class FailingCallDfaProblemType
    extends DfaProblemType {
        @Override
        CauseItem[] findCauses(TrackingRunner runner, PsiExpression expression2, TrackingDfaMemoryState.MemoryStateChange history) {
            if (expression2 instanceof PsiCallExpression) {
                return new CauseItem[]{runner.fromCallContract(history, (PsiCallExpression)expression2, ContractReturnValue.fail())};
            }
            return super.findCauses(runner, expression2, history);
        }

        @Override
        public String toString() {
            return "call always fails";
        }
    }

    public static class NullableDfaProblemType
    extends DfaProblemType {
        @Override
        public CauseItem[] findCauses(TrackingRunner runner, PsiExpression expression2, TrackingDfaMemoryState.MemoryStateChange history) {
            TrackingDfaMemoryState.FactDefinition<DfaNullability> nullability = history.findFact(history.myTopOfStack, TrackingDfaMemoryState.FactExtractor.nullability());
            if (nullability.myFact == DfaNullability.NULLABLE || nullability.myFact == DfaNullability.NULL) {
                return new CauseItem[]{runner.findNullabilityCause(history, (DfaNullability)((Object)nullability.myFact))};
            }
            return new CauseItem[0];
        }

        @Override
        public String toString() {
            return "may be null";
        }
    }

    public static class CastDfaProblemType
    extends DfaProblemType {
        @Override
        public CauseItem[] findCauses(TrackingRunner runner, PsiExpression expression2, TrackingDfaMemoryState.MemoryStateChange history) {
            if (expression2 instanceof PsiTypeCastExpression) {
                PsiType expressionType = expression2.getType();
                TrackingDfaMemoryState.MemoryStateChange operandPush = history.findExpressionPush(((PsiTypeCastExpression)expression2).getOperand());
                if (operandPush != null) {
                    return new CauseItem[]{TrackingRunner.findTypeCause(operandPush, expressionType, false)};
                }
            }
            return new CauseItem[0];
        }

        @Override
        public String toString() {
            return "cast may fail";
        }
    }

    public static class CauseItem {
        @NotNull
        final List<CauseItem> myChildren;
        @NotNull
        final DfaProblemType myProblem;
        @Nullable
        final SmartPsiFileRange myTarget;

        private CauseItem(@NotNull List<CauseItem> children, @NotNull DfaProblemType problem, @Nullable SmartPsiFileRange target) {
            if (children == null) {
                CauseItem.$$$reportNull$$$0(0);
            }
            if (problem == null) {
                CauseItem.$$$reportNull$$$0(1);
            }
            this.myChildren = children;
            this.myProblem = problem;
            this.myTarget = target;
        }

        CauseItem(@NotNull String problem, @Nullable PsiElement target) {
            if (problem == null) {
                CauseItem.$$$reportNull$$$0(2);
            }
            this((DfaProblemType)new CustomDfaProblemType(problem), target);
        }

        CauseItem(@NotNull DfaProblemType problem, @Nullable PsiElement target) {
            if (problem == null) {
                CauseItem.$$$reportNull$$$0(3);
            }
            this.myChildren = new ArrayList<CauseItem>();
            this.myProblem = problem;
            if (target != null) {
                PsiFile file = target.getContainingFile();
                this.myTarget = SmartPointerManager.getInstance((Project)file.getProject()).createSmartPsiFileRangePointer(file, target.getTextRange());
            } else {
                this.myTarget = null;
            }
        }

        CauseItem(@NotNull String problem, @NotNull TrackingDfaMemoryState.MemoryStateChange change) {
            if (problem == null) {
                CauseItem.$$$reportNull$$$0(4);
            }
            if (change == null) {
                CauseItem.$$$reportNull$$$0(5);
            }
            this((DfaProblemType)new CustomDfaProblemType(problem), change);
        }

        CauseItem(@NotNull DfaProblemType problem, @NotNull TrackingDfaMemoryState.MemoryStateChange change) {
            if (problem == null) {
                CauseItem.$$$reportNull$$$0(6);
            }
            if (change == null) {
                CauseItem.$$$reportNull$$$0(7);
            }
            this(problem, (PsiElement)change.getExpression());
        }

        void addChildren(CauseItem ... causes) {
            ContainerUtil.addAllNotNull(this.myChildren, (Object[])causes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CauseItem item = (CauseItem)o;
            return this.myChildren.equals(item.myChildren) && this.getProblemName().equals(item.getProblemName()) && Objects.equals(this.myTarget, item.myTarget);
        }

        private String getProblemName() {
            return this.myProblem.toString();
        }

        public int hashCode() {
            return Objects.hash(this.myChildren, this.getProblemName(), this.myTarget);
        }

        public String dump(Document doc) {
            return this.dump(doc, 0, null);
        }

        private String dump(Document doc, int indent, CauseItem parent) {
            Segment range;
            String text2 = null;
            if (this.myTarget != null && (range = this.myTarget.getRange()) != null) {
                text2 = doc.getText(TextRange.create((Segment)range));
                int lineNumber = doc.getLineNumber(range.getStartOffset());
                text2 = text2 + "; line#" + (lineNumber + 1);
            }
            return StringUtil.repeat((String)"  ", (int)indent) + this.render(doc, parent) + (text2 == null ? "" : " (" + text2 + ")") + "\n" + StreamEx.of(this.myChildren).map(child -> child.dump(doc, indent + 1, this)).joining();
        }

        public Stream<CauseItem> children() {
            return StreamEx.of(this.myChildren);
        }

        @Nullable
        public PsiFile getFile() {
            return this.myTarget != null ? this.myTarget.getContainingFile() : null;
        }

        public Segment getTargetSegment() {
            return this.myTarget == null ? null : this.myTarget.getRange();
        }

        public String render(Document doc, CauseItem parent) {
            int childIndex;
            String cause;
            String title = null;
            Segment range = this.getTargetSegment();
            if (range != null && (cause = this.getProblemName()).endsWith("#ref")) {
                int offset = range.getStartOffset();
                int number = doc.getLineNumber(offset);
                title = cause.replaceFirst("#ref$", "line #" + (number + 1));
            }
            if (title == null) {
                title = this.toString();
            }
            int n = childIndex = parent == null ? 0 : parent.myChildren.indexOf(this);
            title = childIndex > 0 ? (parent.myProblem instanceof PossibleExecutionDfaProblemType ? "or " : "and ") + title : StringUtil.capitalize((String)title);
            return title;
        }

        public String toString() {
            return this.getProblemName().replaceFirst("#ref$", "here");
        }

        public CauseItem merge(CauseItem other) {
            if (this.equals(other)) {
                return this;
            }
            if (Objects.equals(this.myTarget, other.myTarget)) {
                DfaProblemType mergedProblem;
                if (this.myChildren.equals(other.myChildren) && (mergedProblem = this.myProblem.tryMerge(other.myProblem)) != null) {
                    return new CauseItem(this.myChildren, mergedProblem, this.myTarget);
                }
                if (this.getProblemName().equals(other.getProblemName())) {
                    if (this.tryMergeChildren(other.myChildren)) {
                        return this;
                    }
                    if (other.tryMergeChildren(this.myChildren)) {
                        return other;
                    }
                }
            }
            return null;
        }

        private boolean tryMergeChildren(List<CauseItem> children) {
            if (this.myChildren.isEmpty()) {
                return false;
            }
            if (this.myChildren.size() != 1 || !(this.myChildren.get((int)0).myProblem instanceof PossibleExecutionDfaProblemType)) {
                List merged;
                if (children.size() == this.myChildren.size() && !(merged = StreamEx.zip(this.myChildren, children, CauseItem::merge).toList()).contains(null)) {
                    this.myChildren.clear();
                    this.myChildren.addAll(merged);
                    return true;
                }
                this.insertIntoHierarchy(new CauseItem((DfaProblemType)new PossibleExecutionDfaProblemType(), (PsiElement)null));
            }
            CauseItem mergePoint = this.myChildren.get(0);
            if (children.isEmpty()) {
                ((PossibleExecutionDfaProblemType)mergePoint.myProblem).myComplete = false;
            }
            List<CauseItem> mergeChildren = mergePoint.myChildren;
            for (CauseItem child : children) {
                if (mergeChildren.contains(child)) continue;
                boolean merged = false;
                for (int i = 0; i < mergeChildren.size(); ++i) {
                    CauseItem mergeChild = mergeChildren.get(i);
                    CauseItem result = mergeChild.merge(child);
                    if (result == null) continue;
                    mergeChildren.set(i, result);
                    merged = true;
                    break;
                }
                if (merged) continue;
                mergeChildren.add(child);
            }
            return true;
        }

        private void insertIntoHierarchy(CauseItem intermediate) {
            intermediate.myChildren.addAll(this.myChildren);
            this.myChildren.clear();
            this.myChildren.add(intermediate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "children";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "problem";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[0] = "change";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/TrackingRunner$CauseItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class DfaProblemType {
        public abstract String toString();

        CauseItem[] findCauses(TrackingRunner runner, PsiExpression expression2, TrackingDfaMemoryState.MemoryStateChange history) {
            return new CauseItem[0];
        }

        @Nullable
        DfaProblemType tryMerge(DfaProblemType other) {
            return this.toString().equals(other.toString()) ? this : null;
        }
    }
}

