/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.EntryStream;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeConstraint {
    @NotNull
    public TypeConstraint join(@NotNull TypeConstraint var1);

    @NotNull
    public TypeConstraint meet(@NotNull TypeConstraint var1);

    public boolean isSuperConstraintOf(@NotNull TypeConstraint var1);

    @Nullable
    default public TypeConstraint tryNegate() {
        return null;
    }

    @Nullable
    default public PsiType getPsiType(Project project) {
        return null;
    }

    @NotNull
    default public String getPresentationText(@Nullable PsiType type2) {
        String string = this.toShortString();
        if (string == null) {
            TypeConstraint.$$$reportNull$$$0(0);
        }
        return string;
    }

    default public boolean isExact() {
        return false;
    }

    default public boolean isComparedByEquals() {
        return false;
    }

    @Nullable
    default public String getAssignabilityExplanation(@NotNull TypeConstraint otherType, boolean expectedAssignable) {
        if (otherType == null) {
            TypeConstraint.$$$reportNull$$$0(1);
        }
        return null;
    }

    default public StreamEx<Exact> instanceOfTypes() {
        return StreamEx.empty();
    }

    default public StreamEx<Exact> notInstanceOfTypes() {
        return StreamEx.empty();
    }

    default public DfType asDfType() {
        return this == TypeConstraints.BOTTOM ? DfTypes.BOTTOM : DfTypes.customObject(this, DfaNullability.UNKNOWN, Mutability.UNKNOWN, null, DfTypes.BOTTOM);
    }

    default public String toShortString() {
        return this.toString();
    }

    @NotNull
    public static TypeConstraint fromDfType(DfType type2) {
        TypeConstraint typeConstraint = type2 instanceof DfReferenceType ? ((DfReferenceType)type2).getConstraint() : (type2 == DfTypes.BOTTOM ? TypeConstraints.BOTTOM : TypeConstraints.TOP);
        if (typeConstraint == null) {
            TypeConstraint.$$$reportNull$$$0(2);
        }
        return typeConstraint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDfType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAssignabilityExplanation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Constrained
    implements TypeConstraint {
        @NotNull
        private final Set<Exact> myInstanceOf;
        @NotNull
        private final Set<Exact> myNotInstanceOf;

        Constrained(@NotNull Set<Exact> instanceOf, @NotNull Set<Exact> notInstanceOf) {
            if (instanceOf == null) {
                Constrained.$$$reportNull$$$0(0);
            }
            if (notInstanceOf == null) {
                Constrained.$$$reportNull$$$0(1);
            }
            assert (!instanceOf.isEmpty() || !notInstanceOf.isEmpty());
            this.myInstanceOf = instanceOf;
            this.myNotInstanceOf = notInstanceOf;
        }

        @Override
        @Nullable
        public PsiType getPsiType(Project project) {
            PsiType[] conjuncts = (PsiType[])StreamEx.of(this.myInstanceOf).map(exact -> exact.getPsiType(project)).nonNull().toArray((Object[])PsiType.EMPTY_ARRAY);
            return conjuncts.length == 0 ? null : PsiIntersectionType.createIntersection((boolean)true, (PsiType[])conjuncts);
        }

        @Override
        @Nullable
        public TypeConstraint tryNegate() {
            if (this.myInstanceOf.size() == 1 && this.myNotInstanceOf.isEmpty()) {
                return this.myInstanceOf.iterator().next().notInstanceOf();
            }
            if (this.myNotInstanceOf.size() == 1 && this.myInstanceOf.isEmpty()) {
                return this.myNotInstanceOf.iterator().next().instanceOf();
            }
            return null;
        }

        @Override
        @NotNull
        public TypeConstraint join(@NotNull TypeConstraint other) {
            if (other == null) {
                Constrained.$$$reportNull$$$0(2);
            }
            if (this.isSuperConstraintOf(other)) {
                Constrained constrained = this;
                if (constrained == null) {
                    Constrained.$$$reportNull$$$0(3);
                }
                return constrained;
            }
            if (other.isSuperConstraintOf(this)) {
                TypeConstraint typeConstraint = other;
                if (typeConstraint == null) {
                    Constrained.$$$reportNull$$$0(4);
                }
                return typeConstraint;
            }
            if (other instanceof Constrained) {
                return this.joinWithConstrained((Constrained)other);
            }
            if (other instanceof Exact) {
                return this.joinWithConstrained(new Constrained(Collections.singleton((Exact)other), Collections.emptySet()));
            }
            TypeConstraint typeConstraint = TypeConstraints.TOP;
            if (typeConstraint == null) {
                Constrained.$$$reportNull$$$0(5);
            }
            return typeConstraint;
        }

        @NotNull
        private TypeConstraint joinWithConstrained(@NotNull Constrained other) {
            Set<Exact> instanceOfTypes;
            if (other == null) {
                Constrained.$$$reportNull$$$0(6);
            }
            THashSet notTypes = new THashSet(this.myNotInstanceOf);
            notTypes.retainAll(other.myNotInstanceOf);
            if (this.myInstanceOf.containsAll(other.myInstanceOf)) {
                instanceOfTypes = other.myInstanceOf;
            } else if (other.myInstanceOf.containsAll(this.myInstanceOf)) {
                instanceOfTypes = this.myInstanceOf;
            } else {
                instanceOfTypes = Constrained.withSuper(this.myInstanceOf);
                instanceOfTypes.retainAll(Constrained.withSuper(other.myInstanceOf));
            }
            TypeConstraint constraint = TypeConstraints.TOP;
            for (Exact type2 : instanceOfTypes) {
                constraint = constraint.meet(type2.instanceOf());
            }
            for (Exact type2 : notTypes) {
                constraint = constraint.meet(type2.notInstanceOf());
            }
            TypeConstraint typeConstraint = constraint;
            if (typeConstraint == null) {
                Constrained.$$$reportNull$$$0(7);
            }
            return typeConstraint;
        }

        @NotNull
        private static Set<Exact> withSuper(@NotNull Set<Exact> instanceofValues) {
            if (instanceofValues == null) {
                Constrained.$$$reportNull$$$0(8);
            }
            Set set = StreamEx.of(instanceofValues).flatMap(Exact::superTypes).append(instanceofValues).toSet();
            if (set == null) {
                Constrained.$$$reportNull$$$0(9);
            }
            return set;
        }

        @Nullable
        private Constrained withInstanceofValue(@NotNull Exact type2) {
            if (type2 == null) {
                Constrained.$$$reportNull$$$0(10);
            }
            if (this.myInstanceOf.contains(type2)) {
                return this;
            }
            for (Exact exact : this.myNotInstanceOf) {
                if (!exact.isAssignableFrom(type2)) continue;
                return null;
            }
            ArrayList<Exact> moreGeneric = new ArrayList<Exact>();
            for (Exact alreadyInstanceof : this.myInstanceOf) {
                if (type2.isAssignableFrom(alreadyInstanceof)) {
                    return this;
                }
                if (!type2.isConvertibleFrom(alreadyInstanceof)) {
                    return null;
                }
                if (!alreadyInstanceof.isAssignableFrom(type2)) continue;
                moreGeneric.add(alreadyInstanceof);
            }
            THashSet tHashSet = new THashSet(this.myInstanceOf);
            tHashSet.removeAll(moreGeneric);
            tHashSet.add(type2);
            return new Constrained((Set<Exact>)tHashSet, this.myNotInstanceOf);
        }

        @Nullable
        private Constrained withNotInstanceofValue(Exact type2) {
            if (this.myNotInstanceOf.contains(type2)) {
                return this;
            }
            for (Exact exact : this.myInstanceOf) {
                if (!type2.isAssignableFrom(exact)) continue;
                return null;
            }
            ArrayList<Exact> moreSpecific = new ArrayList<Exact>();
            for (Exact alreadyNotInstanceof : this.myNotInstanceOf) {
                if (alreadyNotInstanceof.isAssignableFrom(type2)) {
                    return this;
                }
                if (!type2.isAssignableFrom(alreadyNotInstanceof)) continue;
                moreSpecific.add(alreadyNotInstanceof);
            }
            THashSet tHashSet = new THashSet(this.myNotInstanceOf);
            tHashSet.removeAll(moreSpecific);
            tHashSet.add(type2);
            return new Constrained(this.myInstanceOf, (Set<Exact>)tHashSet);
        }

        @Override
        @NotNull
        public TypeConstraint meet(@NotNull TypeConstraint other) {
            if (other == null) {
                Constrained.$$$reportNull$$$0(11);
            }
            if (this.isSuperConstraintOf(other)) {
                TypeConstraint typeConstraint = other;
                if (typeConstraint == null) {
                    Constrained.$$$reportNull$$$0(12);
                }
                return typeConstraint;
            }
            if (other.isSuperConstraintOf(this)) {
                Constrained constrained = this;
                if (constrained == null) {
                    Constrained.$$$reportNull$$$0(13);
                }
                return constrained;
            }
            if (!(other instanceof Constrained)) {
                TypeConstraint typeConstraint = TypeConstraints.BOTTOM;
                if (typeConstraint == null) {
                    Constrained.$$$reportNull$$$0(14);
                }
                return typeConstraint;
            }
            Constrained right = (Constrained)other;
            Constrained result = this;
            for (Exact type2 : right.myInstanceOf) {
                if ((result = result.withInstanceofValue(type2)) != null) continue;
                TypeConstraint typeConstraint = TypeConstraints.BOTTOM;
                if (typeConstraint == null) {
                    Constrained.$$$reportNull$$$0(15);
                }
                return typeConstraint;
            }
            for (Exact type2 : right.myNotInstanceOf) {
                if ((result = result.withNotInstanceofValue(type2)) != null) continue;
                TypeConstraint typeConstraint = TypeConstraints.BOTTOM;
                if (typeConstraint == null) {
                    Constrained.$$$reportNull$$$0(16);
                }
                return typeConstraint;
            }
            Constrained constrained = result;
            if (constrained == null) {
                Constrained.$$$reportNull$$$0(17);
            }
            return constrained;
        }

        @Override
        public boolean isSuperConstraintOf(@NotNull TypeConstraint other) {
            if (other == null) {
                Constrained.$$$reportNull$$$0(18);
            }
            if (other == TypeConstraints.BOTTOM) {
                return true;
            }
            if (other instanceof Constrained) {
                Constrained that = (Constrained)other;
                if (!that.myNotInstanceOf.containsAll(this.myNotInstanceOf)) {
                    if (that.myInstanceOf.isEmpty()) {
                        return false;
                    }
                    for (Exact thisNotType : this.myNotInstanceOf) {
                        if (that.myNotInstanceOf.contains(thisNotType)) continue;
                        for (Exact thatType : that.myInstanceOf) {
                            if (!thisNotType.isConvertibleFrom(thatType)) continue;
                            return false;
                        }
                    }
                }
                if (that.myInstanceOf.containsAll(this.myInstanceOf)) {
                    return true;
                }
                if (that.myInstanceOf.isEmpty()) {
                    return this.myInstanceOf.isEmpty();
                }
                for (Exact thatType : that.myInstanceOf) {
                    for (Exact thisType : this.myInstanceOf) {
                        if (thisType.isAssignableFrom(thatType)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (other instanceof Exact) {
                Exact otherType = (Exact)other;
                for (Exact thisInstance : this.myInstanceOf) {
                    if (thisInstance.isAssignableFrom(otherType)) continue;
                    return false;
                }
                for (Exact thisNotInstance : this.myNotInstanceOf) {
                    if (!thisNotInstance.isAssignableFrom(otherType)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public String getAssignabilityExplanation(@NotNull TypeConstraint otherType, boolean expectedAssignable) {
            Exact exact;
            if (otherType == null) {
                Constrained.$$$reportNull$$$0(19);
            }
            if ((exact = (Exact)((Optional)otherType.instanceOfTypes().collect(MoreCollectors.onlyOne())).orElse(null)) == null) {
                return null;
            }
            if (expectedAssignable) {
                for (Exact inst : this.myInstanceOf) {
                    if (!exact.isAssignableFrom(inst)) continue;
                    return "is already known to be " + inst.toShortString() + (exact == inst ? "" : " which is a subtype of " + exact.toShortString());
                }
            } else {
                for (Exact notInst : this.myNotInstanceOf) {
                    if (!notInst.isAssignableFrom(exact)) continue;
                    return "is known to be not " + notInst.toShortString() + (exact == notInst ? "" : " which is a supertype of " + exact.toShortString());
                }
                for (Exact inst : this.myInstanceOf) {
                    if (exact.isConvertibleFrom(inst)) continue;
                    return "is known to be " + inst.toShortString() + " which is definitely incompatible with " + exact.toShortString();
                }
            }
            return null;
        }

        @Override
        public StreamEx<Exact> instanceOfTypes() {
            return StreamEx.of(this.myInstanceOf);
        }

        @Override
        public StreamEx<Exact> notInstanceOfTypes() {
            return StreamEx.of(this.myNotInstanceOf);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Constrained that = (Constrained)o;
            return Objects.equals(this.myInstanceOf, that.myInstanceOf) && Objects.equals(this.myNotInstanceOf, that.myNotInstanceOf);
        }

        public int hashCode() {
            return Objects.hash(this.myInstanceOf, this.myNotInstanceOf);
        }

        @NotNull
        public String toString() {
            String string = EntryStream.of((Object)"instanceof ", this.myInstanceOf, (Object)"not instanceof ", this.myNotInstanceOf).removeValues(Set::isEmpty).mapKeyValue((prefix, set) -> StreamEx.of((Collection)set).joining((CharSequence)", ", (CharSequence)prefix, (CharSequence)"")).joining((CharSequence)" ");
            if (string == null) {
                Constrained.$$$reportNull$$$0(20);
            }
            return string;
        }

        @Override
        @NotNull
        public String getPresentationText(@Nullable PsiType type2) {
            Exact exact;
            Set instanceOfTypes = this.myInstanceOf;
            Exact exact2 = exact = type2 == null ? null : (Exact)ObjectUtils.tryCast((Object)TypeConstraints.exact(type2), Exact.class);
            if (exact != null) {
                instanceOfTypes = StreamEx.of(instanceOfTypes).without((Object)exact).toSet();
            }
            String string = EntryStream.of((Object)"instanceof ", (Object)instanceOfTypes, (Object)"not instanceof ", this.myNotInstanceOf).removeValues(Set::isEmpty).mapKeyValue((prefix, set) -> ((StreamEx)StreamEx.of((Collection)set).map(Exact::toShortString).sorted()).joining((CharSequence)", ", (CharSequence)prefix, (CharSequence)"")).joining((CharSequence)"\n");
            if (string == null) {
                Constrained.$$$reportNull$$$0(21);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 21: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 21: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instanceOf";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notInstanceOf";
                    break;
                }
                case 2: 
                case 6: 
                case 11: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraint$Constrained";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instanceofValues";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraint$Constrained";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "join";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "joinWithConstrained";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withSuper";
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "meet";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 21: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "joinWithConstrained";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "withSuper";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "withInstanceofValue";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "meet";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuperConstraintOf";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getAssignabilityExplanation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 21: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Exact
    extends TypeConstraint {
        @Override
        @NotNull
        default public TypeConstraint join(@NotNull TypeConstraint other) {
            if (other == null) {
                Exact.$$$reportNull$$$0(0);
            }
            if (other == TypeConstraints.BOTTOM || this.equals(other)) {
                Exact exact = this;
                if (exact == null) {
                    Exact.$$$reportNull$$$0(1);
                }
                return exact;
            }
            if (other == TypeConstraints.TOP) {
                TypeConstraint typeConstraint = other;
                if (typeConstraint == null) {
                    Exact.$$$reportNull$$$0(2);
                }
                return typeConstraint;
            }
            TypeConstraint typeConstraint = new Constrained(Collections.singleton(this), Collections.emptySet()).join(other);
            if (typeConstraint == null) {
                Exact.$$$reportNull$$$0(3);
            }
            return typeConstraint;
        }

        @Override
        @NotNull
        default public TypeConstraint meet(@NotNull TypeConstraint other) {
            if (other == null) {
                Exact.$$$reportNull$$$0(4);
            }
            if (this.equals(other) || other.isSuperConstraintOf(this)) {
                Exact exact = this;
                if (exact == null) {
                    Exact.$$$reportNull$$$0(5);
                }
                return exact;
            }
            TypeConstraint typeConstraint = TypeConstraints.BOTTOM;
            if (typeConstraint == null) {
                Exact.$$$reportNull$$$0(6);
            }
            return typeConstraint;
        }

        public boolean isFinal();

        @Override
        default public boolean isExact() {
            return true;
        }

        default public boolean canBeInstantiated() {
            return true;
        }

        public StreamEx<Exact> superTypes();

        public boolean isAssignableFrom(@NotNull Exact var1);

        public boolean isConvertibleFrom(@NotNull Exact var1);

        @Override
        default public StreamEx<Exact> instanceOfTypes() {
            return StreamEx.of((Object)this);
        }

        @Override
        default public String getAssignabilityExplanation(@NotNull TypeConstraint otherType, boolean expectedAssignable) {
            Exact exact;
            if (otherType == null) {
                Exact.$$$reportNull$$$0(7);
            }
            if ((exact = (Exact)((Optional)otherType.instanceOfTypes().collect(MoreCollectors.onlyOne())).orElse(null)) == null) {
                return null;
            }
            boolean actual = exact.isAssignableFrom(this);
            if (actual != expectedAssignable) {
                return null;
            }
            if (expectedAssignable) {
                if (this.equals(exact)) {
                    return "is already known to be " + this.toShortString();
                }
                return "type is exactly " + this.toShortString() + " which is a subtype of " + exact.toShortString();
            }
            return "type is exactly " + this.toShortString() + " which is not a subtype of " + exact.toShortString();
        }

        @Override
        default public boolean isSuperConstraintOf(@NotNull TypeConstraint other) {
            if (other == null) {
                Exact.$$$reportNull$$$0(8);
            }
            return other == TypeConstraints.BOTTOM || this.equals(other);
        }

        @Override
        default public TypeConstraint tryNegate() {
            return this.isFinal() ? this.notInstanceOf() : null;
        }

        @NotNull
        default public TypeConstraint instanceOf() {
            if (this.isFinal()) {
                TypeConstraint typeConstraint = this.canBeInstantiated() ? this : TypeConstraints.BOTTOM;
                if (typeConstraint == null) {
                    Exact.$$$reportNull$$$0(9);
                }
                return typeConstraint;
            }
            return new Constrained(Collections.singleton(this), Collections.emptySet());
        }

        @NotNull
        default public TypeConstraint notInstanceOf() {
            return new Constrained(Collections.emptySet(), Collections.singleton(this));
        }

        @Override
        default public String toShortString() {
            return StringUtil.getShortName((String)this.toString());
        }

        @Override
        @NotNull
        default public String getPresentationText(@Nullable PsiType type2) {
            String string = type2 != null && TypeConstraints.exact(type2).equals(this) ? "" : "exactly " + this.toShortString();
            if (string == null) {
                Exact.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraint$Exact";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraint$Exact";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "join";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "meet";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "instanceOf";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentationText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "meet";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getAssignabilityExplanation";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuperConstraintOf";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

