/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nullable;

public class BinopInstruction
extends ExpressionPushingInstruction<PsiExpression>
implements BranchingInstruction {
    private static final TokenSet ourSignificantOperations = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.EQ, JavaTokenType.EQEQ, JavaTokenType.NE, JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE, JavaTokenType.INSTANCEOF_KEYWORD, JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.AND, JavaTokenType.OR, JavaTokenType.XOR, JavaTokenType.PERC, JavaTokenType.DIV, JavaTokenType.ASTERISK, JavaTokenType.GTGT, JavaTokenType.GTGTGT, JavaTokenType.LTLT});
    public static final IElementType STRING_EQUALITY_BY_CONTENT = JavaTokenType.EQ;
    private final IElementType myOperationSign;
    @Nullable
    private final PsiType myResultType;
    private final int myLastOperand;
    private final boolean myUnrolledLoop;
    private boolean myWidened;

    public BinopInstruction(IElementType opSign, @Nullable PsiExpression expression2, @Nullable PsiType resultType) {
        this(opSign, expression2, resultType, -1);
    }

    public BinopInstruction(IElementType opSign, @Nullable PsiExpression expression2, @Nullable PsiType resultType, int lastOperand) {
        this(opSign, expression2, resultType, lastOperand, false);
    }

    public BinopInstruction(IElementType opSign, @Nullable PsiExpression expression2, @Nullable PsiType resultType, int lastOperand, boolean unrolledLoop) {
        super(expression2);
        assert (lastOperand == -1 || expression2 instanceof PsiPolyadicExpression);
        this.myResultType = resultType;
        this.myOperationSign = opSign == JavaTokenType.XOR && PsiType.BOOLEAN.equals((Object)resultType) ? JavaTokenType.NE : (ourSignificantOperations.contains(opSign) ? opSign : null);
        this.myLastOperand = lastOperand;
        this.myUnrolledLoop = unrolledLoop;
    }

    public void widenOperationInLoop() {
        if (!(this.myUnrolledLoop || this.myWidened || this.myOperationSign != JavaTokenType.PLUS && this.myOperationSign != JavaTokenType.MINUS && this.myOperationSign != JavaTokenType.ASTERISK || !this.mayProduceDivergedState())) {
            this.myWidened = true;
        }
    }

    private boolean mayProduceDivergedState() {
        Object anchor = this.getExpression();
        if (anchor instanceof PsiUnaryExpression) {
            return PsiUtil.isIncrementDecrementOperation(anchor);
        }
        while (anchor != null && !(anchor instanceof PsiAssignmentExpression) && !(anchor instanceof PsiVariable)) {
            if (anchor instanceof PsiStatement || anchor instanceof PsiExpressionList && anchor.getParent() instanceof PsiCallExpression || anchor instanceof PsiArrayInitializerExpression || anchor instanceof PsiArrayAccessExpression || anchor instanceof PsiBinaryExpression && RelationType.fromElementType(((PsiBinaryExpression)anchor).getOperationTokenType()) != null) {
                return false;
            }
            anchor = anchor.getParent();
        }
        return true;
    }

    @Override
    @Nullable
    public TextRange getExpressionRange() {
        PsiPolyadicExpression anchor;
        PsiExpression[] operands2;
        if (this.myLastOperand != -1 && this.getExpression() instanceof PsiPolyadicExpression && (operands2 = (anchor = (PsiPolyadicExpression)this.getExpression()).getOperands()).length > this.myLastOperand + 1) {
            return new TextRange(0, operands2[this.myLastOperand].getStartOffsetInParent() + operands2[this.myLastOperand].getTextLength());
        }
        return null;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor2) {
        return visitor2.visitBinop(this, runner, stateBefore);
    }

    @Nullable
    public PsiType getResultType() {
        return this.myResultType;
    }

    public String toString() {
        return "BINOP " + this.myOperationSign;
    }

    public IElementType getOperationSign() {
        return this.myOperationSign;
    }

    public boolean isWidened() {
        return this.myWidened;
    }
}

