/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.psi.PsiType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class DfIntRangeType
implements DfIntType {
    @NotNull
    static final LongRangeSet FULL_RANGE = Objects.requireNonNull(LongRangeSet.fromType((PsiType)PsiType.INT));
    private final LongRangeSet myRange;

    DfIntRangeType(LongRangeSet range) {
        if (!FULL_RANGE.contains(range)) {
            throw new IllegalArgumentException("Illegal range supplied for int type: " + range);
        }
        this.myRange = FULL_RANGE.equals(range) ? FULL_RANGE : range;
    }

    @Override
    @NotNull
    public LongRangeSet getRange() {
        LongRangeSet longRangeSet = this.myRange;
        if (longRangeSet == null) {
            DfIntRangeType.$$$reportNull$$$0(0);
        }
        return longRangeSet;
    }

    @Override
    public boolean isSuperType(@NotNull DfType other) {
        if (other == null) {
            DfIntRangeType.$$$reportNull$$$0(1);
        }
        if (other == DfTypes.BOTTOM) {
            return true;
        }
        if (!(other instanceof DfIntType)) {
            return false;
        }
        return this.myRange.contains(((DfIntType)other).getRange());
    }

    public int hashCode() {
        return this.myRange.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DfIntRangeType && ((DfIntRangeType)obj).myRange.equals(this.myRange);
    }

    public String toString() {
        if (this.myRange == FULL_RANGE) {
            return "int";
        }
        return "int " + this.myRange.getPresentationText((PsiType)PsiType.INT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/types/DfIntRangeType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/types/DfIntRangeType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuperType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

