/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfaVariableValue
extends DfaValue {
    @NotNull
    private final VariableDescriptor myDescriptor;
    private final PsiType myVarType;
    @Nullable
    private final DfaVariableValue myQualifier;
    private DfType myInherentType;
    private final List<DfaVariableValue> myDependents;

    private DfaVariableValue(@NotNull VariableDescriptor descriptor, @NotNull DfaValueFactory factory, @Nullable DfaVariableValue qualifier) {
        if (descriptor == null) {
            DfaVariableValue.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            DfaVariableValue.$$$reportNull$$$0(1);
        }
        super(factory);
        this.myDependents = new SmartList();
        this.myDescriptor = descriptor;
        this.myQualifier = qualifier;
        this.myVarType = descriptor.getType(qualifier);
    }

    @Nullable
    public PsiModifierListOwner getPsiVariable() {
        return this.myDescriptor.getPsiElement();
    }

    @NotNull
    public VariableDescriptor getDescriptor() {
        VariableDescriptor variableDescriptor = this.myDescriptor;
        if (variableDescriptor == null) {
            DfaVariableValue.$$$reportNull$$$0(2);
        }
        return variableDescriptor;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return this.myVarType;
    }

    @Override
    public boolean dependsOn(DfaVariableValue other) {
        return other == this || this.myQualifier != null && this.myQualifier.dependsOn(other);
    }

    @NotNull
    public List<DfaVariableValue> getDependentVariables() {
        List<DfaVariableValue> list = this.myDependents;
        if (list == null) {
            DfaVariableValue.$$$reportNull$$$0(3);
        }
        return list;
    }

    public int getDepth() {
        int depth = 0;
        for (DfaVariableValue qualifier = this.getQualifier(); qualifier != null; qualifier = qualifier.getQualifier()) {
            ++depth;
        }
        return depth;
    }

    @NotNull
    @Contract(pure=true)
    public DfaVariableValue withQualifier(DfaVariableValue newQualifier) {
        DfaVariableValue dfaVariableValue = newQualifier == this.myQualifier ? this : this.myFactory.getVarFactory().createVariableValue(this.myDescriptor, newQualifier);
        if (dfaVariableValue == null) {
            DfaVariableValue.$$$reportNull$$$0(4);
        }
        return dfaVariableValue;
    }

    public String toString() {
        return (this.myQualifier == null ? "" : this.myQualifier + ".") + this.myDescriptor;
    }

    @Nullable
    public DfaVariableValue getQualifier() {
        return this.myQualifier;
    }

    public DfType getInherentType() {
        if (this.myInherentType == null) {
            this.myInherentType = this.calcInherentType();
        }
        return this.myInherentType;
    }

    private DfType calcInherentType() {
        LongRangeSet fromType;
        PsiType type2 = this.getType();
        DfType dfType = DfTypes.typedObject(type2, Nullability.UNKNOWN);
        if (this.myDescriptor instanceof SpecialField) {
            return dfType.meet(((SpecialField)this.myDescriptor).getDefaultValue(false));
        }
        PsiModifierListOwner psi = this.getPsiVariable();
        if (type2 instanceof PsiPrimitiveType && TypeConversionUtil.isIntegralNumberType((PsiType)type2) && (fromType = LongRangeSet.fromType(type2)) != null) {
            LongRangeSet range = LongRangeSet.fromPsiElement(psi).intersect(fromType);
            return type2.equals(PsiType.LONG) ? DfTypes.longRange(range) : DfTypes.intRange(range);
        }
        if (dfType instanceof DfReferenceType) {
            if (psi != null) {
                dfType = dfType.meet(Mutability.getMutability(psi).asDfType());
            }
            dfType = dfType.meet(NullabilityUtil.calcCanBeNull(this).asDfType());
        }
        return dfType;
    }

    @NotNull
    public Nullability getInherentNullability() {
        Nullability nullability = DfaNullability.toNullability(DfaNullability.fromDfType(this.getInherentType()));
        if (nullability == null) {
            DfaVariableValue.$$$reportNull$$$0(5);
        }
        return nullability;
    }

    public boolean isFlushableByCalls() {
        return !this.myDescriptor.isStable() || this.myQualifier != null && this.myQualifier.isFlushableByCalls();
    }

    public boolean containsCalls() {
        return this.myDescriptor.isCall() || this.myQualifier != null && this.myQualifier.containsCalls();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaVariableValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaVariableValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentVariables";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withQualifier";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInherentNullability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory {
        private final Map<Pair<VariableDescriptor, DfaVariableValue>, DfaVariableValue> myExistingVars = new HashMap<Pair<VariableDescriptor, DfaVariableValue>, DfaVariableValue>();
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        @NotNull
        public DfaVariableValue createVariableValue(PsiVariable variable) {
            DfaVariableValue qualifier = null;
            if (variable instanceof PsiField && !variable.hasModifierProperty("static")) {
                qualifier = this.createThisValue(((PsiField)variable).getContainingClass());
            }
            DfaVariableValue dfaVariableValue = this.createVariableValue(new DfaExpressionFactory.PlainDescriptor(variable), qualifier);
            if (dfaVariableValue == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return dfaVariableValue;
        }

        @Contract(value="null -> null; !null -> !null")
        public DfaVariableValue createThisValue(@Nullable PsiClass aClass) {
            if (aClass == null) {
                return null;
            }
            return this.createVariableValue(new DfaExpressionFactory.ThisDescriptor(aClass));
        }

        @NotNull
        public DfaVariableValue createVariableValue(@NotNull VariableDescriptor descriptor) {
            if (descriptor == null) {
                Factory.$$$reportNull$$$0(1);
            }
            DfaVariableValue dfaVariableValue = this.createVariableValue(descriptor, null);
            if (dfaVariableValue == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return dfaVariableValue;
        }

        @NotNull
        DfaVariableValue createVariableValue(@NotNull VariableDescriptor descriptor, @Nullable DfaVariableValue qualifier) {
            Pair key2;
            DfaVariableValue var;
            if (descriptor == null) {
                Factory.$$$reportNull$$$0(3);
            }
            if ((var = this.myExistingVars.get(key2 = Pair.create((Object)descriptor, (Object)qualifier))) == null) {
                var = new DfaVariableValue(descriptor, this.myFactory, qualifier);
                this.myExistingVars.put((Pair<VariableDescriptor, DfaVariableValue>)key2, var);
                while (qualifier != null) {
                    qualifier.myDependents.add(var);
                    qualifier = qualifier.getQualifier();
                }
            }
            DfaVariableValue dfaVariableValue = var;
            if (dfaVariableValue == null) {
                Factory.$$$reportNull$$$0(4);
            }
            return dfaVariableValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createVariableValue";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createVariableValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

