/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum RelationType {
    LE("<="),
    LT("<"),
    GE(">="),
    GT(">"),
    EQ("=="),
    NE("!="),
    IS("is"),
    IS_NOT("isn't");

    private final String myName;

    private RelationType(String name2) {
        this.myName = name2;
    }

    public boolean isSubRelation(RelationType other) {
        if (other == this) {
            return true;
        }
        switch (this) {
            case LE: {
                return other == LT || other == EQ;
            }
            case GE: {
                return other == GT || other == EQ;
            }
            case NE: {
                return other == LT || other == GT;
            }
        }
        return false;
    }

    @NotNull
    public RelationType getNegated() {
        switch (this) {
            case LE: {
                RelationType relationType = GT;
                if (relationType == null) {
                    RelationType.$$$reportNull$$$0(0);
                }
                return relationType;
            }
            case LT: {
                RelationType relationType = GE;
                if (relationType == null) {
                    RelationType.$$$reportNull$$$0(1);
                }
                return relationType;
            }
            case GE: {
                RelationType relationType = LT;
                if (relationType == null) {
                    RelationType.$$$reportNull$$$0(2);
                }
                return relationType;
            }
            case GT: {
                RelationType relationType = LE;
                if (relationType == null) {
                    RelationType.$$$reportNull$$$0(3);
                }
                return relationType;
            }
            case EQ: {
                RelationType relationType = NE;
                if (relationType == null) {
                    RelationType.$$$reportNull$$$0(4);
                }
                return relationType;
            }
            case NE: {
                RelationType relationType = EQ;
                if (relationType == null) {
                    RelationType.$$$reportNull$$$0(5);
                }
                return relationType;
            }
            case IS: {
                RelationType relationType = IS_NOT;
                if (relationType == null) {
                    RelationType.$$$reportNull$$$0(6);
                }
                return relationType;
            }
            case IS_NOT: {
                RelationType relationType = IS;
                if (relationType == null) {
                    RelationType.$$$reportNull$$$0(7);
                }
                return relationType;
            }
        }
        throw new InternalError("Unexpected enum value: " + (Object)((Object)this));
    }

    @Nullable
    public RelationType getFlipped() {
        switch (this) {
            case LE: {
                return GE;
            }
            case LT: {
                return GT;
            }
            case GE: {
                return LE;
            }
            case GT: {
                return LT;
            }
            case NE: 
            case EQ: {
                return this;
            }
        }
        return null;
    }

    public boolean isInequality() {
        return this == LE || this == GE || this == LT || this == GT || this == NE;
    }

    public String toString() {
        return this.myName;
    }

    @Nullable
    public static RelationType fromElementType(IElementType type2) {
        if (JavaTokenType.EQEQ.equals(type2)) {
            return EQ;
        }
        if (JavaTokenType.NE.equals(type2)) {
            return NE;
        }
        if (JavaTokenType.LT.equals(type2)) {
            return LT;
        }
        if (JavaTokenType.GT.equals(type2)) {
            return GT;
        }
        if (JavaTokenType.LE.equals(type2)) {
            return LE;
        }
        if (JavaTokenType.GE.equals(type2)) {
            return GE;
        }
        if (JavaTokenType.INSTANCEOF_KEYWORD.equals(type2)) {
            return IS;
        }
        return null;
    }

    public static RelationType equivalence(boolean equal) {
        return equal ? EQ : NE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/RelationType", "getNegated"));
    }
}

