/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.codeInspection.deprecation.DeprecatedApiUsageProcessor;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElementVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DeprecationInspection
extends DeprecationInspectionBase {
    public static final String SHORT_NAME = "Deprecation";
    public static final String ID = "deprecation";
    public static final String IGNORE_METHODS_OF_DEPRECATED_NAME = "IGNORE_METHODS_OF_DEPRECATED";
    public boolean IGNORE_INSIDE_DEPRECATED = true;
    public boolean IGNORE_ABSTRACT_DEPRECATED_OVERRIDES = true;
    public boolean IGNORE_IMPORT_STATEMENTS = true;
    public boolean IGNORE_METHODS_OF_DEPRECATED = true;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DeprecationInspection.$$$reportNull$$$0(0);
        }
        if (!Registry.is((String)"kotlin.deprecation.inspection.enabled", (boolean)false) && holder.getFile().getLanguage().getID().equals("kotlin")) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                DeprecationInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = ApiUsageUastVisitor.createPsiElementVisitor(new DeprecatedApiUsageProcessor(holder, this.IGNORE_INSIDE_DEPRECATED, this.IGNORE_ABSTRACT_DEPRECATED_OVERRIDES, this.IGNORE_IMPORT_STATEMENTS, this.IGNORE_METHODS_OF_DEPRECATED, this.IGNORE_IN_SAME_OUTERMOST_CLASS, false, null));
        if (psiElementVisitor == null) {
            DeprecationInspection.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public String getID() {
        return ID;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(JavaAnalysisBundle.message((String)"ignore.inside.deprecated.members", (Object[])new Object[0]), "IGNORE_INSIDE_DEPRECATED");
        panel2.addCheckbox(JavaAnalysisBundle.message((String)"ignore.inside.non.static.imports", (Object[])new Object[0]), "IGNORE_IMPORT_STATEMENTS");
        panel2.addCheckbox(JavaAnalysisBundle.message((String)"html.ignore.overrides.of.deprecated.abstract.methods", (Object[])new Object[0]), "IGNORE_ABSTRACT_DEPRECATED_OVERRIDES");
        panel2.addCheckbox(JavaAnalysisBundle.message((String)"ignore.members.of.deprecated.classes", (Object[])new Object[0]), IGNORE_METHODS_OF_DEPRECATED_NAME);
        DeprecationInspection.addSameOutermostClassCheckBox(panel2);
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/deprecation/DeprecationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/deprecation/DeprecationInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

