/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateThrows;

import com.intellij.codeInsight.daemon.impl.quickfix.MethodThrowsFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateThrowsInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    public boolean ignoreSubclassing;

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.declaration.redundancy", (Object[])new Object[0]);
        if (string == null) {
            DuplicateThrowsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "DuplicateThrows";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaAnalysisBundle.message((String)"inspection.duplicate.throws.ignore.subclassing.option", (Object[])new Object[0]), (InspectionProfileEntry)this, "ignoreSubclassing");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DuplicateThrowsInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                PsiReferenceList throwsList = method.getThrowsList();
                PsiJavaCodeReferenceElement[] refs = throwsList.getReferenceElements();
                PsiClassType[] types = throwsList.getReferencedTypes();
                for (int i = 0; i < types.length; ++i) {
                    for (int j = i + 1; j < types.length; ++j) {
                        PsiClassType type2 = types[i];
                        PsiClassType otherType = types[j];
                        String problem = null;
                        PsiJavaCodeReferenceElement ref = refs[i];
                        if (type2.equals((Object)otherType)) {
                            problem = JavaAnalysisBundle.message((String)"inspection.duplicate.throws.problem", (Object[])new Object[0]);
                        } else if (!DuplicateThrowsInspection.this.ignoreSubclassing) {
                            PsiDocTag[] docTags;
                            PsiDocComment comment;
                            if (otherType.isAssignableFrom((PsiType)type2)) {
                                problem = JavaAnalysisBundle.message((String)"inspection.duplicate.throws.more.general.problem", (Object[])new Object[]{otherType.getCanonicalText()});
                            } else if (type2.isAssignableFrom((PsiType)otherType)) {
                                problem = JavaAnalysisBundle.message((String)"inspection.duplicate.throws.more.general.problem", (Object[])new Object[]{type2.getCanonicalText()});
                                ref = refs[j];
                                type2 = otherType;
                            }
                            if (problem != null && (comment = method.getDocComment()) != null && (docTags = comment.findTagsByName("throws")).length >= 2 && DuplicateThrowsInspection.refersTo(docTags, type2) && DuplicateThrowsInspection.refersTo(docTags, otherType)) {
                                return;
                            }
                        }
                        if (problem == null) continue;
                        holder.registerProblem((PsiElement)ref, problem, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new MethodThrowsFix.RemoveFirst(method, type2, false)});
                    }
                }
            }
        };
    }

    private static boolean refersTo(PsiDocTag[] tags, PsiClassType exceptionType) {
        for (PsiDocTag tag : tags) {
            PsiJavaCodeReferenceElement ref;
            PsiDocTagValue element = tag.getValueElement();
            if (element == null || (ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findChildOfType((PsiElement)element, PsiJavaCodeReferenceElement.class)) == null || ref.resolve() != exceptionType.resolve()) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

