/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inferNullity;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullityInferrer {
    private static final int MAX_PASSES = 10;
    public static final String NOTHING_FOUND_TO_INFER = "Nothing found to infer";
    private int numAnnotationsAdded;
    private final List<SmartPsiElementPointer<? extends PsiModifierListOwner>> myNotNullSet = new ArrayList<SmartPsiElementPointer<? extends PsiModifierListOwner>>();
    private final List<SmartPsiElementPointer<? extends PsiModifierListOwner>> myNullableSet = new ArrayList<SmartPsiElementPointer<? extends PsiModifierListOwner>>();
    private final boolean myAnnotateLocalVariables;
    private final SmartPointerManager myPointerManager;

    public NullityInferrer(boolean annotateLocalVariables, Project project) {
        this.myAnnotateLocalVariables = annotateLocalVariables;
        this.myPointerManager = SmartPointerManager.getInstance((Project)project);
    }

    private boolean expressionIsNeverNull(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        ExpressionIsNeverNullVisitor visitor2 = new ExpressionIsNeverNullVisitor();
        expression2.accept((PsiElementVisitor)visitor2);
        return visitor2.isNeverNull();
    }

    private boolean expressionIsSometimesNull(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        ExpressionIsSometimesNullVisitor visitor2 = new ExpressionIsSometimesNullVisitor();
        expression2.accept((PsiElementVisitor)visitor2);
        return visitor2.isSometimesNull();
    }

    private boolean methodNeverReturnsNull(@NotNull PsiMethod method) {
        if (method == null) {
            NullityInferrer.$$$reportNull$$$0(0);
        }
        MethodNeverReturnsNullVisitor visitor2 = new MethodNeverReturnsNullVisitor();
        method.accept((PsiElementVisitor)visitor2);
        return visitor2.getNeverReturnsNull();
    }

    private boolean variableNeverAssignedNull(@NotNull PsiVariable variable) {
        PsiExpression initializer;
        if (variable == null) {
            NullityInferrer.$$$reportNull$$$0(1);
        }
        if ((initializer = variable.getInitializer()) != null ? !this.expressionIsNeverNull(initializer) : !variable.hasModifierProperty("final")) {
            return false;
        }
        Query references = ReferencesSearch.search((PsiElement)variable);
        for (PsiReference reference : references) {
            PsiAssignmentExpression assignment;
            PsiElement parent;
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiReferenceExpression) || !((parent = element.getParent()) instanceof PsiAssignmentExpression) || !(assignment = (PsiAssignmentExpression)parent).getLExpression().equals(element) || this.expressionIsNeverNull(assignment.getRExpression())) continue;
            return false;
        }
        return true;
    }

    private boolean variableSometimesAssignedNull(@NotNull PsiVariable variable) {
        PsiExpression initializer;
        if (variable == null) {
            NullityInferrer.$$$reportNull$$$0(2);
        }
        if ((initializer = variable.getInitializer()) != null && this.expressionIsSometimesNull(initializer)) {
            return true;
        }
        Query references = ReferencesSearch.search((PsiElement)variable);
        for (PsiReference reference : references) {
            PsiAssignmentExpression assignment;
            PsiElement parent;
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiReferenceExpression) || !((parent = element.getParent()) instanceof PsiAssignmentExpression) || !(assignment = (PsiAssignmentExpression)parent).getLExpression().equals(element) || !this.expressionIsSometimesNull(assignment.getRExpression())) continue;
            return true;
        }
        return false;
    }

    public void collect(@NotNull PsiFile file) {
        int prevNumAnnotationsAdded;
        if (file == null) {
            NullityInferrer.$$$reportNull$$$0(3);
        }
        int pass = 0;
        do {
            NullityInferrerVisitor visitor2 = new NullityInferrerVisitor();
            prevNumAnnotationsAdded = this.numAnnotationsAdded;
            file.accept((PsiElementVisitor)visitor2);
        } while (prevNumAnnotationsAdded < this.numAnnotationsAdded && ++pass < 10);
    }

    public void apply(Project project) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project);
        for (SmartPsiElementPointer<? extends PsiModifierListOwner> pointer : this.myNullableSet) {
            NullityInferrer.annotateNullable(project, manager, (PsiModifierListOwner)pointer.getElement());
        }
        for (SmartPsiElementPointer<? extends PsiModifierListOwner> pointer : this.myNotNullSet) {
            NullityInferrer.annotateNotNull(project, manager, (PsiModifierListOwner)pointer.getElement());
        }
        if (this.myNullableSet.isEmpty() && this.myNotNullSet.isEmpty()) {
            throw new RuntimeException(NOTHING_FOUND_TO_INFER);
        }
    }

    public static void nothingFoundMessage(Project project) {
        SwingUtilities.invokeLater(() -> Messages.showInfoMessage((Project)project, (String)JavaBundle.message((String)"dialog.message.no.places.found.to.infer.nullable.notnull", (Object[])new Object[0]), (String)JavaBundle.message((String)"dialog.title.infer.nullity.results", (Object[])new Object[0])));
    }

    private static void annotateNotNull(Project project, NullableNotNullManager manager, PsiModifierListOwner element) {
        if (element != null) {
            if (element instanceof PsiField && ((PsiField)element).hasInitializer() && element.hasModifierProperty("final")) {
                return;
            }
            NullityInferrer.invoke(project, element, manager.getDefaultNotNull(), manager.getDefaultNullable());
        }
    }

    private static void annotateNullable(Project project, NullableNotNullManager manager, PsiModifierListOwner element) {
        if (element != null) {
            NullityInferrer.invoke(project, element, manager.getDefaultNullable(), manager.getDefaultNotNull());
        }
    }

    private static void invoke(Project project, PsiModifierListOwner element, String fqn, String toRemove2) {
        new AddAnnotationFix(fqn, element, toRemove2).invoke(project, null, element.getContainingFile());
    }

    public int getCount() {
        return this.myNotNullSet.size() + this.myNullableSet.size();
    }

    public static void apply(Project project, NullableNotNullManager manager, UsageInfo info) {
        if (info instanceof NullableUsageInfo) {
            NullityInferrer.annotateNullable(project, manager, (PsiModifierListOwner)info.getElement());
        } else if (info instanceof NotNullUsageInfo) {
            NullityInferrer.annotateNotNull(project, manager, (PsiModifierListOwner)info.getElement());
        }
    }

    private boolean shouldIgnore(PsiModifierListOwner element) {
        if (!this.myAnnotateLocalVariables) {
            if (element instanceof PsiLocalVariable) {
                return true;
            }
            if (element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiForeachStatement) {
                return true;
            }
        }
        return false;
    }

    private void registerNullableAnnotation(@NotNull PsiModifierListOwner method) {
        if (method == null) {
            NullityInferrer.$$$reportNull$$$0(4);
        }
        this.registerAnnotation(method, true);
    }

    private void registerNotNullAnnotation(@NotNull PsiModifierListOwner method) {
        if (method == null) {
            NullityInferrer.$$$reportNull$$$0(5);
        }
        this.registerAnnotation(method, false);
    }

    private void registerAnnotation(@NotNull PsiModifierListOwner method, boolean isNullable) {
        if (method == null) {
            NullityInferrer.$$$reportNull$$$0(6);
        }
        SmartPsiElementPointer methodPointer = this.myPointerManager.createSmartPsiElementPointer((PsiElement)method);
        if (isNullable) {
            this.myNullableSet.add((SmartPsiElementPointer<? extends PsiModifierListOwner>)methodPointer);
        } else {
            this.myNotNullSet.add((SmartPsiElementPointer<? extends PsiModifierListOwner>)methodPointer);
        }
        ++this.numAnnotationsAdded;
    }

    void collect(List<? super UsageInfo> usages) {
        this.collect(usages, true);
        this.collect(usages, false);
    }

    private void collect(List<? super UsageInfo> usages, boolean nullable) {
        List<SmartPsiElementPointer<? extends PsiModifierListOwner>> set = nullable ? this.myNullableSet : this.myNotNullSet;
        for (SmartPsiElementPointer<? extends PsiModifierListOwner> elementPointer : set) {
            ReadAction.run(() -> {
                PsiModifierListOwner element = (PsiModifierListOwner)elementPointer.getElement();
                if (element != null && !this.shouldIgnore(element)) {
                    usages.add(nullable ? new NullableUsageInfo((PsiElement)element) : new NotNullUsageInfo((PsiElement)element));
                }
            });
        }
    }

    private static boolean trunkImpossibleBrunch(PsiExpression condition2, PsiExpression elseExpression2, PsiExpression rOperand, PsiExpression lOperand) {
        PsiElement resolve2;
        return rOperand instanceof PsiLiteralExpression && "null".equals(rOperand.getText()) && lOperand instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)lOperand).resolve()) instanceof PsiVariable && ((PsiBinaryExpression)condition2).getOperationTokenType() == JavaTokenType.EQEQ && elseExpression2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)elseExpression2).resolve() == resolve2;
    }

    private static boolean canTrunkImpossibleBrunch(PsiExpression condition2, PsiExpression elseExpression2) {
        PsiExpression lOperand;
        PsiExpression rOperand;
        return condition2 instanceof PsiBinaryExpression && (NullityInferrer.trunkImpossibleBrunch(condition2, elseExpression2, rOperand = ((PsiBinaryExpression)condition2).getROperand(), lOperand = ((PsiBinaryExpression)condition2).getLOperand()) || NullityInferrer.trunkImpossibleBrunch(condition2, elseExpression2, lOperand, rOperand));
    }

    private boolean isNotNull(PsiModifierListOwner owner2) {
        if (NullableNotNullManager.isNotNull((PsiModifierListOwner)owner2)) {
            return true;
        }
        SmartPsiElementPointer pointer = this.myPointerManager.createSmartPsiElementPointer((PsiElement)owner2);
        return this.myNotNullSet.contains(pointer);
    }

    private boolean isNullable(PsiModifierListOwner owner2) {
        if (NullableNotNullManager.isNullable((PsiModifierListOwner)owner2)) {
            return true;
        }
        SmartPsiElementPointer pointer = this.myPointerManager.createSmartPsiElementPointer((PsiElement)owner2);
        return this.myNullableSet.contains(pointer);
    }

    private boolean hasNullability(@NotNull PsiModifierListOwner owner2) {
        NullableNotNullManager manager;
        NullabilityAnnotationInfo info;
        if (owner2 == null) {
            NullityInferrer.$$$reportNull$$$0(7);
        }
        if ((info = (manager = NullableNotNullManager.getInstance((Project)owner2.getProject())).findEffectiveNullabilityInfo(owner2)) != null && !info.isInferred() && info.getNullability() != Nullability.UNKNOWN) {
            return true;
        }
        SmartPsiElementPointer pointer = this.myPointerManager.createSmartPsiElementPointer((PsiElement)owner2);
        return this.myNotNullSet.contains(pointer) || this.myNullableSet.contains(pointer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/inferNullity/NullityInferrer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "methodNeverReturnsNull";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "variableNeverAssignedNull";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "variableSometimesAssignedNull";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerNullableAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "registerNotNullAnnotation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "registerAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNullability";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class NullityInferrerVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private NullityInferrerVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (method.isConstructor() || method.getReturnType() instanceof PsiPrimitiveType) {
                return;
            }
            Collection overridingMethods = OverridingMethodsSearch.search((PsiMethod)method).findAll();
            for (PsiMethod overridingMethod : overridingMethods) {
                if (!NullityInferrer.this.isNullable((PsiModifierListOwner)overridingMethod)) continue;
                NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)method);
                return;
            }
            NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)method.getProject());
            if (!manager.isNotNull((PsiModifierListOwner)method, false) && manager.isNotNull((PsiModifierListOwner)method, true)) {
                NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)method);
                return;
            }
            if (NullityInferrer.this.hasNullability((PsiModifierListOwner)method)) {
                return;
            }
            PsiCodeBlock body2 = method.getBody();
            if (body2 != null) {
                final boolean[] sometimesReturnsNull = new boolean[1];
                body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitClass(PsiClass aClass) {
                    }

                    public void visitLambdaExpression(PsiLambdaExpression expression2) {
                    }

                    public void visitElement(@NotNull PsiElement element) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (sometimesReturnsNull[0]) {
                            return;
                        }
                        super.visitElement(element);
                    }

                    public void visitReturnStatement(PsiReturnStatement statement) {
                        super.visitReturnStatement(statement);
                        PsiExpression value2 = statement.getReturnValue();
                        if (NullityInferrer.this.expressionIsSometimesNull(value2)) {
                            sometimesReturnsNull[0] = true;
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/inferNullity/NullityInferrer$NullityInferrerVisitor$1", "visitElement"));
                    }
                });
                if (sometimesReturnsNull[0]) {
                    NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)method);
                    return;
                }
            }
            if (NullityInferrer.this.methodNeverReturnsNull(method)) {
                for (PsiMethod overridingMethod : overridingMethods) {
                    if (NullityInferrer.this.isNotNull((PsiModifierListOwner)overridingMethod)) continue;
                    return;
                }
                NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)method);
            }
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(1);
            }
            super.visitLocalVariable(variable);
            if (variable.getType() instanceof PsiPrimitiveType || NullityInferrer.this.isNotNull((PsiModifierListOwner)variable) || NullityInferrer.this.isNullable((PsiModifierListOwner)variable)) {
                return;
            }
            if (NullityInferrer.this.variableNeverAssignedNull((PsiVariable)variable)) {
                NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable);
            }
            if (NullityInferrer.this.variableSometimesAssignedNull((PsiVariable)variable)) {
                NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)variable);
            }
        }

        public void visitParameter(@NotNull PsiParameter parameter2) {
            if (parameter2 == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(2);
            }
            super.visitParameter(parameter2);
            if (parameter2.getType() instanceof PsiPrimitiveType || NullityInferrer.this.hasNullability((PsiModifierListOwner)parameter2)) {
                return;
            }
            PsiElement grandParent = parameter2.getDeclarationScope();
            if (grandParent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)grandParent;
                if (method.getBody() != null) {
                    for (PsiReferenceExpression expr2 : VariableAccessUtils.getVariableReferences((PsiVariable)parameter2, (PsiElement)method)) {
                        PsiElement parent;
                        if (this.processParameter(parameter2, expr2, parent = PsiTreeUtil.skipParentsOfType((PsiElement)expr2, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class}))) {
                            return;
                        }
                        if (!NullityInferrer.this.isNotNull((PsiModifierListOwner)method)) continue;
                        PsiElement toReturn = parent;
                        if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != expr2) {
                            toReturn = parent.getParent();
                        }
                        if (!(toReturn instanceof PsiReturnStatement)) continue;
                        NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter2);
                        return;
                    }
                }
            } else if (grandParent instanceof PsiForeachStatement) {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter2, (SearchScope)new LocalSearchScope(grandParent))) {
                    PsiElement parent;
                    PsiReferenceExpression expr3;
                    PsiElement place = reference.getElement();
                    if (!(place instanceof PsiReferenceExpression) || !this.processParameter(parameter2, expr3 = (PsiReferenceExpression)place, parent = PsiTreeUtil.skipParentsOfType((PsiElement)expr3, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class}))) continue;
                    return;
                }
            } else {
                if (NullityInferrer.this.variableNeverAssignedNull((PsiVariable)parameter2)) {
                    NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter2);
                }
                if (NullityInferrer.this.variableSometimesAssignedNull((PsiVariable)parameter2)) {
                    NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)parameter2);
                }
            }
        }

        private boolean processParameter(PsiParameter parameter2, PsiReferenceExpression expr2, PsiElement parent) {
            PsiParameter resolvedToParam;
            PsiParameter[] parameters2;
            PsiMethod resolvedMethod;
            Object[] args;
            int idx;
            PsiExpressionList argumentList;
            PsiCall call;
            if (PsiUtil.isAccessedForWriting((PsiExpression)expr2)) {
                return true;
            }
            if (parent instanceof PsiBinaryExpression) {
                PsiExpression opposite = null;
                PsiExpression lOperand = ((PsiBinaryExpression)parent).getLOperand();
                PsiExpression rOperand = ((PsiBinaryExpression)parent).getROperand();
                if (lOperand == expr2) {
                    opposite = rOperand;
                } else if (rOperand == expr2) {
                    opposite = lOperand;
                }
                if (opposite != null && opposite.getType() == PsiType.NULL) {
                    if (parent.getParent() instanceof PsiAssertStatement && ((PsiBinaryExpression)parent).getOperationTokenType() == JavaTokenType.NE) {
                        NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter2);
                        return true;
                    }
                    NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)parameter2);
                    return true;
                }
            } else {
                if (parent instanceof PsiInstanceOfExpression) {
                    return true;
                }
                if (parent instanceof PsiReferenceExpression) {
                    PsiExpression qualifierExpression2 = ((PsiReferenceExpression)parent).getQualifierExpression();
                    if (qualifierExpression2 == expr2) {
                        NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter2);
                        return true;
                    }
                    PsiElement exprParent = expr2.getParent();
                    while (exprParent instanceof PsiTypeCastExpression || exprParent instanceof PsiParenthesizedExpression) {
                        if (qualifierExpression2 == exprParent) {
                            NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter2);
                            return true;
                        }
                        exprParent = exprParent.getParent();
                    }
                } else if (parent instanceof PsiAssignmentExpression) {
                    PsiVariable localVar;
                    PsiElement resolve2;
                    PsiExpression expression2;
                    if (((PsiAssignmentExpression)parent).getRExpression() == expr2 && (expression2 = ((PsiAssignmentExpression)parent).getLExpression()) instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)expression2).resolve()) instanceof PsiVariable && NullityInferrer.this.isNotNull((PsiModifierListOwner)(localVar = (PsiVariable)resolve2))) {
                        NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter2);
                        return true;
                    }
                } else if (parent instanceof PsiForeachStatement) {
                    if (((PsiForeachStatement)parent).getIteratedValue() == expr2) {
                        NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter2);
                        return true;
                    }
                } else if (parent instanceof PsiSwitchStatement && ((PsiSwitchStatement)parent).getExpression() == expr2) {
                    NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter2);
                    return true;
                }
            }
            if ((call = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)expr2, PsiCall.class)) != null && (argumentList = call.getArgumentList()) != null && (idx = ArrayUtil.find((Object[])(args = argumentList.getExpressions()), (Object)expr2)) >= 0 && (resolvedMethod = call.resolveMethod()) != null && idx < (parameters2 = resolvedMethod.getParameterList().getParameters()).length && NullityInferrer.this.isNotNull((PsiModifierListOwner)(resolvedToParam = parameters2[idx])) && !resolvedToParam.isVarArgs()) {
                NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter2);
                return true;
            }
            return false;
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(3);
            }
            super.visitField(field);
            if (field instanceof PsiEnumConstant) {
                return;
            }
            if (field.getType() instanceof PsiPrimitiveType || NullityInferrer.this.isNotNull((PsiModifierListOwner)field) || NullityInferrer.this.isNullable((PsiModifierListOwner)field)) {
                return;
            }
            if (NullityInferrer.this.variableNeverAssignedNull((PsiVariable)field)) {
                NullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)field);
            }
            if (NullityInferrer.this.variableSometimesAssignedNull((PsiVariable)field)) {
                NullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)field);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/inferNullity/NullityInferrer$NullityInferrerVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MethodNeverReturnsNullVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean neverReturnsNull = true;

        private MethodNeverReturnsNullVisitor() {
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                MethodNeverReturnsNullVisitor.$$$reportNull$$$0(0);
            }
            super.visitReturnStatement(statement);
            PsiExpression value2 = statement.getReturnValue();
            if (NullityInferrer.this.expressionIsNeverNull(value2)) {
                return;
            }
            if (value2 instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)value2;
                PsiMethod method = methodCallExpression.resolveMethod();
                PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)value2, PsiMethod.class);
                if (method != null && method.equals(containingMethod)) {
                    return;
                }
            }
            this.neverReturnsNull = false;
        }

        private boolean getNeverReturnsNull() {
            return this.neverReturnsNull;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/inferNullity/NullityInferrer$MethodNeverReturnsNullVisitor", "visitReturnStatement"));
        }
    }

    private class ExpressionIsSometimesNullVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean sometimesNull;

        private ExpressionIsSometimesNullVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                ExpressionIsSometimesNullVisitor.$$$reportNull$$$0(0);
            }
            if (this.sometimesNull) {
                return;
            }
            super.visitElement(element);
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression2) {
            if (expression2 == null) {
                ExpressionIsSometimesNullVisitor.$$$reportNull$$$0(1);
            }
            this.sometimesNull = "null".equals(expression2.getText());
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            if (expression2 == null) {
                ExpressionIsSometimesNullVisitor.$$$reportNull$$$0(2);
            }
            this.sometimesNull = NullityInferrer.this.expressionIsSometimesNull(expression2.getRExpression());
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression2) {
            if (expression2 == null) {
                ExpressionIsSometimesNullVisitor.$$$reportNull$$$0(3);
            }
            PsiExpression condition2 = expression2.getCondition();
            PsiExpression thenExpression2 = expression2.getThenExpression();
            PsiExpression elseExpression2 = expression2.getElseExpression();
            if (NullityInferrer.canTrunkImpossibleBrunch(condition2, elseExpression2)) {
                this.sometimesNull = NullityInferrer.this.expressionIsSometimesNull(thenExpression2);
                return;
            }
            this.sometimesNull = NullityInferrer.this.expressionIsSometimesNull(thenExpression2) || NullityInferrer.this.expressionIsSometimesNull(elseExpression2);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            PsiVariable var;
            PsiElement referent;
            if (expression2 == null) {
                ExpressionIsSometimesNullVisitor.$$$reportNull$$$0(4);
            }
            if ((referent = expression2.resolve()) instanceof PsiVariable && NullityInferrer.this.isNullable((PsiModifierListOwner)(var = (PsiVariable)referent))) {
                this.sometimesNull = true;
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiMethod method;
            if (expression2 == null) {
                ExpressionIsSometimesNullVisitor.$$$reportNull$$$0(5);
            }
            if ((method = expression2.resolveMethod()) != null) {
                this.sometimesNull = NullityInferrer.this.isNullable((PsiModifierListOwner)method);
            }
        }

        private boolean isSometimesNull() {
            return this.sometimesNull;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/inferNullity/NullityInferrer$ExpressionIsSometimesNullVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLiteralExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitConditionalExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ExpressionIsNeverNullVisitor
    extends JavaElementVisitor {
        private boolean neverNull = true;

        private ExpressionIsNeverNullVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression2) {
            if (expression2 == null) {
                ExpressionIsNeverNullVisitor.$$$reportNull$$$0(0);
            }
            this.neverNull = !"null".equals(expression2.getText());
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            if (expression2 == null) {
                ExpressionIsNeverNullVisitor.$$$reportNull$$$0(1);
            }
            this.neverNull = NullityInferrer.this.expressionIsNeverNull(expression2.getRExpression());
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression2) {
            if (expression2 == null) {
                ExpressionIsNeverNullVisitor.$$$reportNull$$$0(2);
            }
            PsiExpression condition2 = expression2.getCondition();
            PsiExpression thenExpression2 = expression2.getThenExpression();
            PsiExpression elseExpression2 = expression2.getElseExpression();
            if (NullityInferrer.canTrunkImpossibleBrunch(condition2, elseExpression2)) {
                this.neverNull = NullityInferrer.this.expressionIsNeverNull(thenExpression2);
                return;
            }
            this.neverNull = NullityInferrer.this.expressionIsNeverNull(thenExpression2) || NullityInferrer.this.expressionIsNeverNull(elseExpression2);
        }

        public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression2) {
            if (expression2 == null) {
                ExpressionIsNeverNullVisitor.$$$reportNull$$$0(3);
            }
            this.neverNull = NullityInferrer.this.expressionIsNeverNull(expression2.getExpression());
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
            this.neverNull = false;
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            PsiVariable var;
            PsiElement referent;
            if (expression2 == null) {
                ExpressionIsNeverNullVisitor.$$$reportNull$$$0(4);
            }
            if ((referent = expression2.resolve()) instanceof PsiVariable && ((var = (PsiVariable)referent) instanceof PsiEnumConstant || NullityInferrer.this.isNotNull((PsiModifierListOwner)var))) {
                this.neverNull = true;
                return;
            }
            this.neverNull = false;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiMethod method;
            if (expression2 == null) {
                ExpressionIsNeverNullVisitor.$$$reportNull$$$0(5);
            }
            this.neverNull = (method = expression2.resolveMethod()) != null && NullityInferrer.this.isNotNull((PsiModifierListOwner)method);
        }

        private boolean isNeverNull() {
            return this.neverNull;
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/intellij/codeInspection/inferNullity/NullityInferrer$ExpressionIsNeverNullVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLiteralExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitConditionalExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParenthesizedExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NotNullUsageInfo
    extends UsageInfo {
        private NotNullUsageInfo(@NotNull PsiElement element) {
            if (element == null) {
                NotNullUsageInfo.$$$reportNull$$$0(0);
            }
            super(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/inferNullity/NullityInferrer$NotNullUsageInfo", "<init>"));
        }
    }

    private static class NullableUsageInfo
    extends UsageInfo {
        private NullableUsageInfo(@NotNull PsiElement element) {
            if (element == null) {
                NullableUsageInfo.$$$reportNull$$$0(0);
            }
            super(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/inferNullity/NullityInferrer$NullableUsageInfo", "<init>"));
        }
    }
}

