/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.magicConstant;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.intellij.lang.annotations.MagicConstant;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MagicConstantUtils {
    private static AllowedValues getAllowedValuesFromMagic(@NotNull PsiType type2, @NotNull PsiAnnotation magic, @NotNull PsiManager manager) {
        Object[] flagsFromClass;
        PsiAnnotationMemberValue[] initializers;
        if (type2 == null) {
            MagicConstantUtils.$$$reportNull$$$0(0);
        }
        if (magic == null) {
            MagicConstantUtils.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            MagicConstantUtils.$$$reportNull$$$0(2);
        }
        Object[] allowedValues = PsiAnnotationMemberValue.EMPTY_ARRAY;
        boolean values = false;
        boolean flags = false;
        if (TypeConversionUtil.getTypeRank((PsiType)type2) <= 5) {
            PsiAnnotationMemberValue[] initializers2;
            PsiAnnotationMemberValue orValue;
            PsiAnnotationMemberValue intValues = magic.findAttributeValue("intValues");
            if (intValues instanceof PsiArrayInitializerMemberValue && (initializers = ((PsiArrayInitializerMemberValue)intValues).getInitializers()).length != 0) {
                allowedValues = initializers;
                values = true;
            }
            if (!values && (orValue = magic.findAttributeValue("flags")) instanceof PsiArrayInitializerMemberValue && (initializers2 = ((PsiArrayInitializerMemberValue)orValue).getInitializers()).length != 0) {
                allowedValues = initializers2;
                flags = true;
            }
        } else if (type2.equals(PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)manager.getProject())))) {
            PsiAnnotationMemberValue strValuesAttr = magic.findAttributeValue("stringValues");
            if (strValuesAttr instanceof PsiArrayInitializerMemberValue && (initializers = ((PsiArrayInitializerMemberValue)strValuesAttr).getInitializers()).length != 0) {
                allowedValues = initializers;
                values = true;
            }
        } else {
            return null;
        }
        Object[] valuesFromClass = MagicConstantUtils.readFromClass("valuesFromClass", magic, type2, manager);
        if (valuesFromClass != null) {
            allowedValues = (PsiAnnotationMemberValue[])ArrayUtil.mergeArrays((Object[])allowedValues, (Object[])valuesFromClass, (ArrayFactory)PsiAnnotationMemberValue.ARRAY_FACTORY);
            values = true;
        }
        if ((flagsFromClass = MagicConstantUtils.readFromClass("flagsFromClass", magic, type2, manager)) != null) {
            allowedValues = (PsiAnnotationMemberValue[])ArrayUtil.mergeArrays((Object[])allowedValues, (Object[])flagsFromClass, (ArrayFactory)PsiAnnotationMemberValue.ARRAY_FACTORY);
            flags = true;
        }
        if (allowedValues.length == 0) {
            return null;
        }
        if (values && flags) {
            throw new IncorrectOperationException("Misconfiguration of @MagicConstant annotation: 'flags' and 'values' shouldn't be used at the same time");
        }
        return new AllowedValues((PsiAnnotationMemberValue[])allowedValues, flags);
    }

    private static PsiAnnotationMemberValue[] readFromClass(@NonNls @NotNull String attributeName, @NotNull PsiAnnotation magic, @NotNull PsiType type2, @NotNull PsiManager manager) {
        PsiClass fromClass;
        PsiAnnotationMemberValue fromClassAttr;
        if (attributeName == null) {
            MagicConstantUtils.$$$reportNull$$$0(3);
        }
        if (magic == null) {
            MagicConstantUtils.$$$reportNull$$$0(4);
        }
        if (type2 == null) {
            MagicConstantUtils.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            MagicConstantUtils.$$$reportNull$$$0(6);
        }
        PsiType fromClassType = (fromClassAttr = magic.findAttributeValue(attributeName)) instanceof PsiClassObjectAccessExpression ? ((PsiClassObjectAccessExpression)fromClassAttr).getOperand().getType() : null;
        PsiClass psiClass = fromClass = fromClassType instanceof PsiClassType ? ((PsiClassType)fromClassType).resolve() : null;
        if (fromClass == null) {
            return null;
        }
        String fqn = fromClass.getQualifiedName();
        if (fqn == null) {
            return null;
        }
        ArrayList<PsiReferenceExpression> constants = new ArrayList<PsiReferenceExpression>();
        for (PsiField field : fromClass.getFields()) {
            PsiType fieldType;
            if (!field.hasModifierProperty("public") || !field.hasModifierProperty("static") || !field.hasModifierProperty("final") || !Comparing.equal((Object)(fieldType = field.getType()), (Object)type2)) continue;
            PsiAssignmentExpression e = (PsiAssignmentExpression)JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText("x=" + fqn + "." + field.getName(), (PsiElement)field);
            PsiReferenceExpression refToField = (PsiReferenceExpression)e.getRExpression();
            constants.add(refToField);
        }
        if (constants.isEmpty()) {
            return null;
        }
        return constants.toArray(PsiAnnotationMemberValue.EMPTY_ARRAY);
    }

    @Nullable
    public static AllowedValues getAllowedValues(@NotNull PsiModifierListOwner element, @Nullable PsiType type2) {
        if (element == null) {
            MagicConstantUtils.$$$reportNull$$$0(7);
        }
        return MagicConstantUtils.getAllowedValues(element, type2, null);
    }

    @Nullable
    static AllowedValues getAllowedValues(@NotNull PsiModifierListOwner element, @Nullable PsiType type2, @Nullable Set<? super PsiClass> visited) {
        if (element == null) {
            MagicConstantUtils.$$$reportNull$$$0(8);
        }
        PsiManager manager = element.getManager();
        for (PsiAnnotation annotation : MagicConstantUtils.getAllAnnotations(element)) {
            AllowedValues values;
            PsiElement resolved;
            AllowedValues values2;
            if (type2 != null && MagicConstant.class.getName().equals(annotation.getQualifiedName()) && (values2 = MagicConstantUtils.getAllowedValuesFromMagic(type2, annotation, manager)) != null) {
                return values2;
            }
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            PsiElement psiElement = resolved = ref == null ? null : ref.resolve();
            if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
            PsiClass aClass = (PsiClass)resolved;
            if (visited == null) {
                visited = new THashSet();
            }
            if (!visited.add((PsiClass)aClass) || (values = MagicConstantUtils.getAllowedValues((PsiModifierListOwner)aClass, type2, (Set<? super PsiClass>)visited)) == null) continue;
            return values;
        }
        return MagicConstantUtils.parseBeanInfo(element, manager);
    }

    private static PsiAnnotation @NotNull [] getAllAnnotations(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            MagicConstantUtils.$$$reportNull$$$0(9);
        }
        PsiModifierListOwner realElement = MagicConstantUtils.getSourceElement(element);
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)realElement, () -> CachedValueProvider.Result.create((Object)AnnotationUtil.getAllAnnotations((PsiModifierListOwner)realElement, (boolean)true, null, (boolean)false), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (psiAnnotationArray == null) {
            MagicConstantUtils.$$$reportNull$$$0(10);
        }
        return psiAnnotationArray;
    }

    private static PsiModifierListOwner getSourceElement(@NotNull PsiModifierListOwner element) {
        PsiElement navigationElement;
        if (element == null) {
            MagicConstantUtils.$$$reportNull$$$0(11);
        }
        if (element instanceof PsiCompiledElement && (navigationElement = element.getNavigationElement()) instanceof PsiModifierListOwner) {
            return (PsiModifierListOwner)navigationElement;
        }
        return element;
    }

    private static AllowedValues parseBeanInfo(@NotNull PsiModifierListOwner owner2, @NotNull PsiManager manager) {
        if (owner2 == null) {
            MagicConstantUtils.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            MagicConstantUtils.$$$reportNull$$$0(13);
        }
        PsiUtilCore.ensureValid((PsiElement)owner2);
        PsiFile containingFile = owner2.getContainingFile();
        if (containingFile != null) {
            PsiUtilCore.ensureValid((PsiElement)containingFile);
            if (!MagicConstantUtils.containsBeanInfoText((PsiFile)containingFile.getNavigationElement())) {
                return null;
            }
        }
        PsiMethod method = null;
        if (owner2 instanceof PsiParameter) {
            PsiParameter parameter2 = (PsiParameter)owner2;
            PsiElement scope = parameter2.getDeclarationScope();
            if (!(scope instanceof PsiMethod)) {
                return null;
            }
            PsiElement nav = scope.getNavigationElement();
            if (!(nav instanceof PsiMethod)) {
                return null;
            }
            method = (PsiMethod)nav;
            if (method.isConstructor()) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"java.beans.ConstructorProperties"});
                if (annotation == null) {
                    return null;
                }
                PsiAnnotationMemberValue value2 = annotation.findAttributeValue("value");
                if (!(value2 instanceof PsiArrayInitializerMemberValue)) {
                    return null;
                }
                PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)value2).getInitializers();
                PsiElement parent = parameter2.getParent();
                if (!(parent instanceof PsiParameterList)) {
                    return null;
                }
                int index = ((PsiParameterList)parent).getParameterIndex(parameter2);
                if (index >= initializers.length) {
                    return null;
                }
                String[] initializer = initializers[index];
                if (!(initializer instanceof PsiLiteralExpression)) {
                    return null;
                }
                Object val = ((PsiLiteralExpression)initializer).getValue();
                if (!(val instanceof String)) {
                    return null;
                }
                PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)method.getContainingClass(), (String)((String)val), (boolean)false, (boolean)false);
                if (setter == null) {
                    return null;
                }
                PsiElement navigationElement = setter.getNavigationElement();
                if (!(navigationElement instanceof PsiMethod)) {
                    return null;
                }
                method = (PsiMethod)navigationElement;
            }
        } else if (owner2 instanceof PsiMethod) {
            PsiElement nav = owner2.getNavigationElement();
            if (!(nav instanceof PsiMethod)) {
                return null;
            }
            method = (PsiMethod)nav;
        }
        if (method == null) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method)) {
            List setters = PropertyUtilBase.getSetters((PsiClass)aClass, (String)PropertyUtilBase.getPropertyNameByGetter((PsiMethod)method));
            if (setters.size() != 1) {
                return null;
            }
            method = (PsiMethod)setters.get(0);
        }
        if (!PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) {
            return null;
        }
        PsiDocComment doc = method.getDocComment();
        if (doc == null) {
            return null;
        }
        PsiDocTag beaninfo = doc.findTagByName("beaninfo");
        if (beaninfo == null) {
            return null;
        }
        String data = StringUtil.join((Object[])beaninfo.getDataElements(), PsiElement::getText, (String)"\n");
        int enumIndex = StringUtil.indexOfSubstringEnd((String)data, (String)"enum:");
        if (enumIndex == -1) {
            return null;
        }
        int colon = (data = data.substring(enumIndex)).indexOf(58);
        int last = colon == -1 ? data.length() : data.substring(0, colon).lastIndexOf(10);
        data = data.substring(0, last);
        ArrayList<PsiReferenceExpression> values = new ArrayList<PsiReferenceExpression>();
        for (String line : StringUtil.splitByLines((String)data)) {
            List words = StringUtil.split((String)line, (String)" ", (boolean)true, (boolean)true);
            if (words.size() != 2) continue;
            String ref = (String)words.get(1);
            PsiExpression constRef = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText(ref, (PsiElement)aClass);
            if (!(constRef instanceof PsiReferenceExpression)) continue;
            PsiReferenceExpression expr2 = (PsiReferenceExpression)constRef;
            values.add(expr2);
        }
        if (values.isEmpty()) {
            return null;
        }
        PsiAnnotationMemberValue[] array = values.toArray(PsiAnnotationMemberValue.EMPTY_ARRAY);
        return new AllowedValues(array, false);
    }

    private static boolean containsBeanInfoText(@NotNull PsiFile file) {
        if (file == null) {
            MagicConstantUtils.$$$reportNull$$$0(14);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)IdIndex.hasIdentifierInFile((PsiFile)file, (String)"beaninfo"), (Object[])new Object[]{file}));
    }

    static boolean same(@NotNull PsiElement e1, @NotNull PsiElement e2, @NotNull PsiManager manager) {
        if (e1 == null) {
            MagicConstantUtils.$$$reportNull$$$0(15);
        }
        if (e2 == null) {
            MagicConstantUtils.$$$reportNull$$$0(16);
        }
        if (manager == null) {
            MagicConstantUtils.$$$reportNull$$$0(17);
        }
        if (e1 instanceof PsiLiteralExpression && e2 instanceof PsiLiteralExpression) {
            return Comparing.equal((Object)((PsiLiteralExpression)e1).getValue(), (Object)((PsiLiteralExpression)e2).getValue());
        }
        if (e1 instanceof PsiPrefixExpression && e2 instanceof PsiPrefixExpression && ((PsiPrefixExpression)e1).getOperationTokenType() == ((PsiPrefixExpression)e2).getOperationTokenType()) {
            PsiExpression lOperand = ((PsiPrefixExpression)e1).getOperand();
            PsiExpression rOperand = ((PsiPrefixExpression)e2).getOperand();
            return lOperand != null && rOperand != null && MagicConstantUtils.same((PsiElement)lOperand, (PsiElement)rOperand, manager);
        }
        if (e1 instanceof PsiReference && e2 instanceof PsiReference) {
            e1 = ((PsiReference)e1).resolve();
            e2 = ((PsiReference)e2).resolve();
        }
        return manager.areElementsEquivalent(e2, e1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "magic";
                break;
            }
            case 2: 
            case 6: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/magicConstant/MagicConstantUtils";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/magicConstant/MagicConstantUtils";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllowedValuesFromMagic";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readFromClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllowedValues";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnnotations";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSourceElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseBeanInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "containsBeanInfoText";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "same";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AllowedValues {
        private final PsiAnnotationMemberValue @NotNull [] values;
        private final boolean canBeOred;
        private final boolean resolvesToZero;

        AllowedValues(PsiAnnotationMemberValue @NotNull [] values, boolean canBeOred) {
            if (values == null) {
                AllowedValues.$$$reportNull$$$0(0);
            }
            this.values = values;
            this.canBeOred = canBeOred;
            this.resolvesToZero = this.resolvesToZero();
        }

        private boolean resolvesToZero() {
            for (PsiAnnotationMemberValue value2 : this.values) {
                Object evaluated;
                if (!(value2 instanceof PsiExpression) || !((evaluated = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)value2, null, false)) instanceof Integer) || (Integer)evaluated != 0) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllowedValues a2 = (AllowedValues)o;
            if (this.canBeOred != a2.canBeOred) {
                return false;
            }
            Set v1 = ContainerUtil.set((Object[])this.values);
            Set v2 = ContainerUtil.set((Object[])a2.values);
            if (v1.size() != v2.size()) {
                return false;
            }
            block0: for (PsiAnnotationMemberValue value2 : v1) {
                for (PsiAnnotationMemberValue value22 : v2) {
                    if (!MagicConstantUtils.same((PsiElement)value2, (PsiElement)value22, value2.getManager())) continue;
                    v2.remove(value22);
                    continue block0;
                }
            }
            return v2.isEmpty();
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.values);
            result = 31 * result + (this.canBeOred ? 1 : 0);
            return result;
        }

        boolean isSubsetOf(@NotNull AllowedValues other, @NotNull PsiManager manager) {
            if (other == null) {
                AllowedValues.$$$reportNull$$$0(1);
            }
            if (manager == null) {
                AllowedValues.$$$reportNull$$$0(2);
            }
            return Arrays.stream(this.values).allMatch(value2 -> Arrays.stream(other.values).anyMatch(otherValue -> MagicConstantUtils.same((PsiElement)value2, (PsiElement)otherValue, manager)));
        }

        public PsiAnnotationMemberValue @NotNull [] getValues() {
            if (this.values == null) {
                AllowedValues.$$$reportNull$$$0(3);
            }
            return this.values;
        }

        public boolean isFlagSet() {
            return this.canBeOred;
        }

        public boolean hasZeroValue() {
            return this.resolvesToZero;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/magicConstant/MagicConstantUtils$AllowedValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/magicConstant/MagicConstantUtils$AllowedValues";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSubsetOf";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

