/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IterableUsedAsVarargInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            IterableUsedAsVarargInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                IterableUsedAsVarargInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiMethod newMethod;
                PsiType substitutionWithArray;
                PsiExpressionList argList = call.getArgumentList();
                int argCount = argList.getExpressionCount();
                if (argCount < 2) {
                    return;
                }
                JavaResolveResult result = call.getMethodExpression().advancedResolve(false);
                PsiMethod method = (PsiMethod)result.getElement();
                if (method == null || !method.isVarArgs()) {
                    return;
                }
                PsiParameterList paramList = method.getParameterList();
                if (paramList.getParametersCount() != argCount) {
                    return;
                }
                PsiParameter varArgParam = paramList.getParameters()[argCount - 1];
                PsiEllipsisType type2 = (PsiEllipsisType)ObjectUtils.tryCast((Object)varArgParam.getType(), PsiEllipsisType.class);
                if (type2 == null) {
                    return;
                }
                PsiTypeParameter componentType = (PsiTypeParameter)ObjectUtils.tryCast((Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)type2.getComponentType()), PsiTypeParameter.class);
                if (componentType == null || componentType.getOwner() != method) {
                    return;
                }
                PsiSubstitutor substitutor = result.getSubstitutor();
                if (!TypeUtils.isJavaLangObject(substitutor.substitute(componentType))) {
                    return;
                }
                PsiExpression[] args = argList.getExpressions();
                PsiExpression varArgExpression = args[argCount - 1];
                PsiType elementType = PsiUtil.substituteTypeParameter((PsiType)varArgExpression.getType(), (String)"java.lang.Iterable", (int)0, (boolean)false);
                if (elementType == null || TypeUtils.isJavaLangObject(elementType)) {
                    return;
                }
                PsiClass elementClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)GenericsUtil.getVariableTypeByExpressionType((PsiType)elementType));
                if (elementClass == null) {
                    return;
                }
                PsiMethodCallExpression callCopy = (PsiMethodCallExpression)call.copy();
                if (callCopy == null) {
                    return;
                }
                PsiExpression argCopy = (PsiExpression)ArrayUtil.getLastElement((Object[])callCopy.getArgumentList().getExpressions());
                if (argCopy == null) {
                    return;
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)holder.getProject());
                String className2 = elementClass.getQualifiedName();
                String replacement = "new " + className2 + "[0]";
                argCopy.replace((PsiElement)factory.createExpressionFromText(replacement, (PsiElement)argCopy));
                JavaResolveResult copyResult = callCopy.getMethodExpression().advancedResolve(false);
                if (copyResult.getElement() == method ? (substitutionWithArray = copyResult.getSubstitutor().substitute(componentType)) == null || TypeUtils.isJavaLangObject(substitutionWithArray) : (newMethod = (PsiMethod)copyResult.getElement()) == null || !newMethod.isVarArgs() || newMethod.getParameterList().getParametersCount() != argCount) {
                    return;
                }
                AddToArrayFix fix2 = null;
                if (InheritanceUtil.isInheritor((PsiType)varArgExpression.getType(), (String)"java.util.Collection")) {
                    fix2 = new AddToArrayFix(className2);
                }
                holder.registerProblem((PsiElement)varArgExpression, JavaBundle.message((String)"inspection.collection.used.as.vararg.message", (Object[])new Object[0]), new LocalQuickFix[]{fix2});
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/miscGenerics/IterableUsedAsVarargInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/miscGenerics/IterableUsedAsVarargInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddToArrayFix
    implements LocalQuickFix {
        private final String myClassName;

        AddToArrayFix(String className2) {
            this.myClassName = className2;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.call", (Object[])new Object[]{"toArray(new " + StringUtil.getShortName((String)this.myClassName) + "[0])"});
            if (string == null) {
                AddToArrayFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression expression2;
            if (project == null) {
                AddToArrayFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AddToArrayFix.$$$reportNull$$$0(2);
            }
            if ((expression2 = (PsiExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiExpression.class)) == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiType)expression2.getType(), (String)"java.util.Collection")) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            String fullReplacementText = ParenthesesUtils.getText(expression2, 2) + ".toArray(new " + this.myClassName + "[0])";
            expression2.replace((PsiElement)factory.createExpressionFromText(fullReplacementText, (PsiElement)expression2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/miscGenerics/IterableUsedAsVarargInspection$AddToArrayFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/miscGenerics/IterableUsedAsVarargInspection$AddToArrayFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

