/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChangeNullableDefaultsFix
implements LocalQuickFix {
    private final NullableNotNullManager myManager;
    private final String myNotNullName;
    private final String myNullableName;

    ChangeNullableDefaultsFix(@Nullable PsiAnnotation notNull, @Nullable PsiAnnotation nullable, @NotNull NullableNotNullManager manager) {
        if (manager == null) {
            ChangeNullableDefaultsFix.$$$reportNull$$$0(0);
        }
        this.myNotNullName = notNull != null ? notNull.getQualifiedName() : null;
        this.myNullableName = nullable != null ? nullable.getQualifiedName() : null;
        this.myManager = manager;
    }

    ChangeNullableDefaultsFix(String notNull, String nullable, NullableNotNullManager manager) {
        this.myManager = manager;
        this.myNotNullName = notNull;
        this.myNullableName = nullable;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"make.0.default.annotation", (Object[])new Object[]{this.myNotNullName != null ? this.myNotNullName : this.myNullableName});
        if (string == null) {
            ChangeNullableDefaultsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            ChangeNullableDefaultsFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            ChangeNullableDefaultsFix.$$$reportNull$$$0(3);
        }
        if (this.myNotNullName != null) {
            this.myManager.setDefaultNotNull(this.myNotNullName);
        } else {
            this.myManager.setDefaultNullable(this.myNullableName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/nullable/ChangeNullableDefaultsFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/nullable/ChangeNullableDefaultsFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

