/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.redundantCast;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class CastCanBeRemovedNarrowingVariableTypeInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            CastCanBeRemovedNarrowingVariableTypeInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitTypeCastExpression(PsiTypeCastExpression cast) {
                PsiType initializerType;
                PsiTypeElement castTypeElement = cast.getCastType();
                if (castTypeElement == null || castTypeElement.getAnnotations().length > 0) {
                    return;
                }
                PsiType castType = cast.getType();
                if (!(castType instanceof PsiClassType) || ((PsiClassType)castType).isRaw()) {
                    return;
                }
                PsiLocalVariable variable = ExpressionUtils.resolveLocalVariable(cast.getOperand());
                if (variable == null) {
                    return;
                }
                PsiTypeElement variableTypeElement = variable.getTypeElement();
                if (variableTypeElement.isInferredType() || variableTypeElement.getAnnotations().length > 0) {
                    return;
                }
                PsiType variableType = variable.getType();
                if (!(variableType instanceof PsiClassType) || ((PsiClassType)variableType).isRaw()) {
                    return;
                }
                if (variableType.equals(castType) || !variableType.isAssignableFrom(castType)) {
                    return;
                }
                PsiExpression variableInitializer = variable.getInitializer();
                if (!(variableInitializer == null || (initializerType = variableInitializer.getType()) != null && castType.isAssignableFrom(initializerType))) {
                    return;
                }
                PsiElement block = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
                if (block == null) {
                    return;
                }
                for (PsiReferenceExpression reference : VariableAccessUtils.getVariableReferences((PsiVariable)variable, block)) {
                    if (CastCanBeRemovedNarrowingVariableTypeInspection.isVariableTypeChangeSafeForReference(cast, castType, reference)) continue;
                    return;
                }
                String message2 = JavaBundle.message((String)"inspection.cast.can.be.removed.narrowing.variable.type.message", (Object[])new Object[]{variable.getName(), castType.getPresentableText()});
                holder.registerProblem((PsiElement)castTypeElement, message2, new LocalQuickFix[]{new CastCanBeRemovedNarrowingVariableTypeFix(variable, castType, isOnTheFly)});
            }
        };
    }

    private static boolean isVariableTypeChangeSafeForReference(@NotNull PsiTypeCastExpression cast, @NotNull PsiType targetType, @NotNull PsiReferenceExpression reference) {
        if (cast == null) {
            CastCanBeRemovedNarrowingVariableTypeInspection.$$$reportNull$$$0(1);
        }
        if (targetType == null) {
            CastCanBeRemovedNarrowingVariableTypeInspection.$$$reportNull$$$0(2);
        }
        if (reference == null) {
            CastCanBeRemovedNarrowingVariableTypeInspection.$$$reportNull$$$0(3);
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)reference.getParent());
        if (PsiUtil.isAccessedForWriting((PsiExpression)reference)) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)parent, PsiAssignmentExpression.class);
            if (assignmentExpression == null) {
                return false;
            }
            PsiExpression rValue = assignmentExpression.getRExpression();
            if (rValue == null) {
                return false;
            }
            PsiType rValueType = rValue.getType();
            return rValueType != null && targetType.isAssignableFrom(rValueType);
        }
        while (parent instanceof PsiConditionalExpression) {
            parent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
        }
        if (parent instanceof PsiInstanceOfExpression) {
            PsiTypeElement checkTypeElement = ((PsiInstanceOfExpression)parent).getCheckType();
            if (checkTypeElement == null) {
                return false;
            }
            PsiType checkType = checkTypeElement.getType();
            return TypeConversionUtil.areTypesConvertible((PsiType)targetType, (PsiType)checkType);
        }
        if (parent instanceof PsiTypeCastExpression && parent != cast) {
            PsiTypeElement castTypeElement = ((PsiTypeCastExpression)parent).getCastType();
            if (castTypeElement == null) {
                return false;
            }
            PsiType castType = castTypeElement.getType();
            return TypeConversionUtil.areTypesConvertible((PsiType)targetType, (PsiType)castType);
        }
        if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiCallExpression) {
            PsiCallExpression call = (PsiCallExpression)parent.getParent();
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            Object mark = new Object();
            PsiTreeUtil.mark((PsiElement)reference, (Object)mark);
            PsiCallExpression callCopy = (PsiCallExpression)call.copy();
            PsiTreeUtil.releaseMark((PsiElement)reference, (Object)mark);
            PsiElement refCopy = PsiTreeUtil.releaseMark((PsiElement)callCopy, (Object)mark);
            if (refCopy == null) {
                return false;
            }
            refCopy.replace((PsiElement)cast);
            return callCopy.resolveMethod() == method;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cast";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/redundantCast/CastCanBeRemovedNarrowingVariableTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isVariableTypeChangeSafeForReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CastCanBeRemovedNarrowingVariableTypeFix
    implements LocalQuickFix {
        private final String myVariableName;
        private final String myType;
        private final boolean myOnTheFly;

        CastCanBeRemovedNarrowingVariableTypeFix(PsiLocalVariable variable, PsiType type2, boolean onTheFly) {
            this.myVariableName = variable.getName();
            this.myType = type2.getPresentableText();
            this.myOnTheFly = onTheFly;
        }

        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.cast.can.be.removed.narrowing.variable.type.fix.name", (Object[])new Object[]{this.myVariableName, this.myType});
            if (string == null) {
                CastCanBeRemovedNarrowingVariableTypeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.cast.can.be.removed.narrowing.variable.type.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                CastCanBeRemovedNarrowingVariableTypeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiTypeCastExpression cast;
            if (project == null) {
                CastCanBeRemovedNarrowingVariableTypeFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CastCanBeRemovedNarrowingVariableTypeFix.$$$reportNull$$$0(3);
            }
            if ((cast = (PsiTypeCastExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiTypeCastExpression.class)) == null) {
                return;
            }
            PsiLocalVariable var = ExpressionUtils.resolveLocalVariable(cast.getOperand());
            if (var == null) {
                return;
            }
            PsiTypeElement castType = cast.getCastType();
            if (castType == null) {
                return;
            }
            PsiElement newTypeElement = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(var.getTypeElement().replace((PsiElement)castType));
            if (this.myOnTheFly) {
                HighlightUtils.highlightElement(newTypeElement);
            }
            for (PsiReference reference : ReferencesSearch.search((PsiElement)var).findAll()) {
                PsiTypeCastExpression castOccurrence;
                if (!(reference instanceof PsiReferenceExpression) || (castOccurrence = (PsiTypeCastExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)((PsiReferenceExpression)reference).getParent()), PsiTypeCastExpression.class)) == null || !RedundantCastUtil.isCastRedundant(castOccurrence)) continue;
                RemoveRedundantCastUtil.removeCast(castOccurrence);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/redundantCast/CastCanBeRemovedNarrowingVariableTypeInspection$CastCanBeRemovedNarrowingVariableTypeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/redundantCast/CastCanBeRemovedNarrowingVariableTypeInspection$CastCanBeRemovedNarrowingVariableTypeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

