/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseConvertToLocalQuickFix<V extends PsiVariable>
implements LocalQuickFix {
    protected static final Logger LOG = Logger.getInstance(BaseConvertToLocalQuickFix.class);

    @NotNull
    public final String getFamilyName() {
        String string = JavaBundle.message((String)"inspection.convert.to.local.quickfix", (Object[])new Object[0]);
        if (string == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        V variable;
        if (project == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(2);
        }
        if ((variable = this.getVariable(descriptor)) == null || !variable.isValid()) {
            return;
        }
        PsiFile myFile = variable.getContainingFile();
        try {
            List<PsiElement> newDeclarations = this.moveDeclaration(project, variable);
            if (newDeclarations.isEmpty()) {
                return;
            }
            BaseConvertToLocalQuickFix.positionCaretToDeclaration(project, myFile, newDeclarations.get(newDeclarations.size() - 1));
            newDeclarations.forEach(declaration2 -> BaseConvertToLocalQuickFix.inlineRedundant(declaration2));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void inlineRedundant(@Nullable PsiElement declaration2) {
        if (declaration2 == null) {
            return;
        }
        PsiLocalVariable newVariable = BaseConvertToLocalQuickFix.extractDeclared(declaration2);
        if (newVariable != null) {
            PsiExpression initializer = ParenthesesUtils.stripParentheses(newVariable.getInitializer());
            WriteAction.run(() -> {
                if (VariableAccessUtils.isLocalVariableCopy(newVariable, initializer)) {
                    for (PsiReference reference : ReferencesSearch.search((PsiElement)newVariable).findAll()) {
                        InlineUtil.inlineVariable((PsiVariable)newVariable, initializer, (PsiJavaCodeReferenceElement)reference);
                    }
                    declaration2.delete();
                }
            });
        }
    }

    @Nullable
    private static PsiLocalVariable extractDeclared(@NotNull PsiElement declaration2) {
        if (declaration2 == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(3);
        }
        if (!(declaration2 instanceof PsiDeclarationStatement)) {
            return null;
        }
        PsiElement[] declaredElements = ((PsiDeclarationStatement)declaration2).getDeclaredElements();
        if (declaredElements.length != 1) {
            return null;
        }
        return (PsiLocalVariable)ObjectUtils.tryCast((Object)declaredElements[0], PsiLocalVariable.class);
    }

    @Nullable
    protected abstract V getVariable(@NotNull ProblemDescriptor var1);

    protected static void positionCaretToDeclaration(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement declaration2) {
        PsiFile openedFile;
        Editor editor;
        if (project == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(4);
        }
        if (psiFile == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(5);
        }
        if (declaration2 == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(6);
        }
        if ((editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) != null && (IJSwingUtilities.hasFocus((Component)editor.getComponent()) || ApplicationManager.getApplication().isUnitTestMode()) && (openedFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) == psiFile) {
            editor.getCaretModel().moveToOffset(declaration2.getTextOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    protected void beforeDelete(@NotNull Project project, @NotNull V variable, @NotNull PsiElement newDeclaration) {
        if (project == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(7);
        }
        if (variable == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(8);
        }
        if (newDeclaration == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(9);
        }
    }

    @NotNull
    protected List<PsiElement> moveDeclaration(@NotNull Project project, @NotNull V variable) {
        Collection references;
        if (project == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(10);
        }
        if (variable == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(11);
        }
        if ((references = ReferencesSearch.search(variable).findAll()).isEmpty()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                BaseConvertToLocalQuickFix.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<PsiElement> list = Collections.singletonList(Objects.requireNonNull(this.moveDeclaration(project, variable, references, true)));
        if (list == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(13);
        }
        return list;
    }

    protected PsiElement moveDeclaration(Project project, V variable, Collection<? extends PsiReference> references, boolean delete) {
        PsiCodeBlock anchorBlock = BaseConvertToLocalQuickFix.findAnchorBlock(references);
        if (anchorBlock == null) {
            return null;
        }
        PsiElement firstElement = BaseConvertToLocalQuickFix.getLowestOffsetElement(references);
        String localName = this.suggestLocalName(project, variable, anchorBlock);
        PsiElement anchor = BaseConvertToLocalQuickFix.getAnchorElement(anchorBlock, firstElement);
        PsiAssignmentExpression anchorAssignmentExpression = BaseConvertToLocalQuickFix.searchAssignmentExpression(anchor);
        if (anchorAssignmentExpression != null && BaseConvertToLocalQuickFix.isVariableAssignment(anchorAssignmentExpression, variable)) {
            HashSet<? extends PsiReference> refsSet = new HashSet<PsiReference>(references);
            refsSet.remove(anchorAssignmentExpression.getLExpression());
            return this.applyChanges(project, localName, anchorAssignmentExpression.getRExpression(), variable, refsSet, delete, (NotNullFunction<PsiDeclarationStatement, PsiElement>)((NotNullFunction)declaration2 -> new CommentTracker().replaceAndRestoreComments(anchor, (PsiElement)declaration2)));
        }
        return this.applyChanges(project, localName, variable.getInitializer(), variable, references, delete, (NotNullFunction<PsiDeclarationStatement, PsiElement>)((NotNullFunction)declaration2 -> {
            PsiElement parent = anchorBlock.getParent();
            if (parent instanceof PsiSwitchStatement) {
                PsiElement switchContainer = parent.getParent();
                return switchContainer.addBefore((PsiElement)declaration2, parent);
            }
            return anchorBlock.addBefore((PsiElement)declaration2, anchor);
        }));
    }

    protected PsiElement applyChanges(@NotNull Project project, @NotNull String localName, @Nullable PsiExpression initializer, @NotNull V variable, @NotNull Collection<? extends PsiReference> references, boolean delete, @NotNull NotNullFunction<? super PsiDeclarationStatement, ? extends PsiElement> action) {
        if (project == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(14);
        }
        if (localName == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(15);
        }
        if (variable == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(16);
        }
        if (references == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(17);
        }
        if (action == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(18);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        return (PsiElement)WriteAction.compute(() -> {
            PsiElement newDeclaration = this.moveDeclaration(elementFactory, localName, variable, initializer, (NotNullFunction<PsiDeclarationStatement, PsiElement>)action, references);
            if (delete) {
                this.deleteSourceVariable(project, variable, newDeclaration);
            }
            return newDeclaration;
        });
    }

    protected void deleteSourceVariable(@NotNull Project project, @NotNull V variable, PsiElement newDeclaration) {
        if (project == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(19);
        }
        if (variable == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(20);
        }
        CommentTracker tracker = new CommentTracker();
        this.beforeDelete(project, variable, newDeclaration);
        variable.normalizeDeclaration();
        tracker.delete((PsiElement)variable);
        tracker.insertCommentsBefore(newDeclaration);
    }

    protected PsiElement moveDeclaration(PsiElementFactory elementFactory, String localName, V variable, PsiExpression initializer, NotNullFunction<? super PsiDeclarationStatement, ? extends PsiElement> action, Collection<? extends PsiReference> references) {
        PsiDeclarationStatement declaration2 = elementFactory.createVariableDeclarationStatement(localName, variable.getType(), initializer);
        if (references.stream().map(PsiReference::getElement).anyMatch(element -> element instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element)))) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiLocalVariable)declaration2.getDeclaredElements()[0]), (String)"final", (boolean)false);
        }
        PsiElement newDeclaration = (PsiElement)action.fun((Object)declaration2);
        BaseConvertToLocalQuickFix.retargetReferences(elementFactory, localName, references);
        return newDeclaration;
    }

    @Nullable
    private static PsiAssignmentExpression searchAssignmentExpression(@Nullable PsiElement anchor) {
        if (!(anchor instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpression anchorExpression = ((PsiExpressionStatement)anchor).getExpression();
        if (!(anchorExpression instanceof PsiAssignmentExpression)) {
            return null;
        }
        return (PsiAssignmentExpression)anchorExpression;
    }

    private static boolean isVariableAssignment(@NotNull PsiAssignmentExpression expression2, @NotNull PsiVariable variable) {
        if (expression2 == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(21);
        }
        if (variable == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(22);
        }
        if (expression2.getOperationTokenType() != JavaTokenType.EQ) {
            return false;
        }
        if (!(expression2.getLExpression() instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression leftExpression = (PsiReferenceExpression)expression2.getLExpression();
        return leftExpression.isReferenceTo((PsiElement)variable);
    }

    @NotNull
    protected abstract String suggestLocalName(@NotNull Project var1, @NotNull V var2, @NotNull PsiCodeBlock var3);

    private static void retargetReferences(PsiElementFactory elementFactory, String localName, Collection<? extends PsiReference> refs) throws IncorrectOperationException {
        PsiReferenceExpression refExpr = (PsiReferenceExpression)elementFactory.createExpressionFromText(localName, null);
        for (PsiReference psiReference : refs) {
            if (!(psiReference instanceof PsiReferenceExpression)) continue;
            ((PsiReferenceExpression)psiReference).replace((PsiElement)refExpr);
        }
    }

    @Nullable
    private static PsiElement getAnchorElement(PsiCodeBlock anchorBlock, @NotNull PsiElement firstElement) {
        PsiElement element;
        if (firstElement == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(23);
        }
        for (element = firstElement; element != null && element.getParent() != anchorBlock; element = element.getParent()) {
        }
        return element;
    }

    @Nullable
    private static PsiElement getLowestOffsetElement(@NotNull Collection<? extends PsiReference> refs) {
        if (refs == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(24);
        }
        PsiElement firstElement = null;
        for (PsiReference psiReference : refs) {
            PsiElement element = psiReference.getElement();
            if (!(element instanceof PsiReferenceExpression) || firstElement != null && firstElement.getTextRange().getStartOffset() <= element.getTextRange().getStartOffset()) continue;
            firstElement = element;
        }
        return firstElement;
    }

    private static PsiCodeBlock findAnchorBlock(Collection<? extends PsiReference> refs) {
        PsiCodeBlock result = null;
        for (PsiReference psiReference : refs) {
            PsiElement element = psiReference.getElement();
            if (PsiUtil.isInsideJavadocComment((PsiElement)element)) continue;
            PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class);
            if (result == null || block == null) {
                result = block;
                continue;
            }
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)result, (PsiElement)block);
            if ((result = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)commonParent, PsiCodeBlock.class, (boolean)false)) != null) continue;
            return null;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDeclaration";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstElement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "moveDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractDeclared";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "positionCaretToDeclaration";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "beforeDelete";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "moveDeclaration";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "applyChanges";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "deleteSourceVariable";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isVariableAssignment";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorElement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLowestOffsetElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

