/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.LanguageCompilerRefAdapter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

class CompilerHierarchyInfoImpl
implements CompilerDirectHierarchyInfo {
    private static final Logger LOG = Logger.getInstance(CompilerHierarchyInfoImpl.class);
    private final PsiNamedElement myBaseClass;
    private final GlobalSearchScope myDirtyScope;
    private final GlobalSearchScope mySearchScope;
    private final Project myProject;
    private final FileType mySearchFileType;
    private final CompilerHierarchySearchType mySearchType;
    private final Map<VirtualFile, SearchId[]> myCandidatePerFile;

    CompilerHierarchyInfoImpl(Map<VirtualFile, SearchId[]> candidatesPerFile, PsiNamedElement baseClass, GlobalSearchScope dirtyScope, GlobalSearchScope searchScope, Project project, FileType searchFileType, CompilerHierarchySearchType searchType) {
        this.myCandidatePerFile = candidatesPerFile;
        this.myBaseClass = baseClass;
        this.myDirtyScope = dirtyScope;
        this.mySearchScope = searchScope;
        this.myProject = project;
        this.mySearchFileType = searchFileType;
        this.mySearchType = searchType;
    }

    @Override
    @NotNull
    public Stream<PsiElement> getHierarchyChildren() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        LanguageCompilerRefAdapter adapter = Objects.requireNonNull(LanguageCompilerRefAdapter.findAdapter(this.mySearchFileType));
        Stream<PsiElement> stream = this.myCandidatePerFile.entrySet().stream().filter(e -> this.mySearchScope.contains((VirtualFile)e.getKey())).flatMap(e -> {
            SearchId[] definitions;
            VirtualFile file = (VirtualFile)e.getKey();
            PsiElement[] hierarchyChildren = (PsiElement[])ReadAction.compute(() -> this.lambda$null$1(psiManager, file, definitions = (SearchId[])e.getValue(), adapter));
            if (hierarchyChildren.length == definitions.length) {
                return Stream.of(hierarchyChildren);
            }
            LOG.assertTrue(this.mySearchType == CompilerHierarchySearchType.DIRECT_INHERITOR, (Object)"Should not happens for functional expression search");
            return Stream.of(hierarchyChildren).filter(c -> (Boolean)ReadAction.compute(() -> adapter.isDirectInheritor((PsiElement)c, this.myBaseClass)));
        });
        if (stream == null) {
            CompilerHierarchyInfoImpl.$$$reportNull$$$0(0);
        }
        return stream;
    }

    @Override
    @NotNull
    public GlobalSearchScope getDirtyScope() {
        GlobalSearchScope globalSearchScope = this.myDirtyScope;
        if (globalSearchScope == null) {
            CompilerHierarchyInfoImpl.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    private /* synthetic */ PsiElement[] lambda$null$1(PsiManager psiManager, VirtualFile file, SearchId[] definitions, LanguageCompilerRefAdapter adapter) throws RuntimeException {
        PsiFileWithStubSupport psiFile = (PsiFileWithStubSupport)psiManager.findFile(file);
        return this.mySearchType.performSearchInFile(definitions, this.myBaseClass, psiFile, adapter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/compiler/backwardRefs/CompilerHierarchyInfoImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchyChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyScope";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

