/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs.view;

import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import gnu.trove.TIntHashSet;
import java.util.stream.IntStream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerReferenceFindUsagesTestInfo {
    @Nullable
    private final TIntHashSet myFileIds;
    @NotNull
    private final DirtyScopeTestInfo myDirtyScopeInfo;
    @NotNull
    private final Project myProject;

    public CompilerReferenceFindUsagesTestInfo(@Nullable TIntHashSet occurrencesIds, @NotNull DirtyScopeTestInfo dirtyScopeTestInfo, @NotNull Project project) {
        if (dirtyScopeTestInfo == null) {
            CompilerReferenceFindUsagesTestInfo.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CompilerReferenceFindUsagesTestInfo.$$$reportNull$$$0(1);
        }
        this.myFileIds = occurrencesIds;
        this.myDirtyScopeInfo = dirtyScopeTestInfo;
        this.myProject = project;
    }

    VirtualFile @NotNull [] getFilesWithKnownOccurrences() {
        if (this.myFileIds == null) {
            throw new IllegalStateException();
        }
        ManagingFS managingFS = ManagingFS.getInstance();
        VirtualFile[] virtualFileArray = (VirtualFile[])IntStream.of(this.myFileIds.toArray()).mapToObj(arg_0 -> ((ManagingFS)managingFS).findFileById(arg_0)).filter(f -> !this.myDirtyScopeInfo.getDirtyScope().contains(f)).toArray(VirtualFile[]::new);
        if (virtualFileArray == null) {
            CompilerReferenceFindUsagesTestInfo.$$$reportNull$$$0(2);
        }
        return virtualFileArray;
    }

    Module @NotNull [] getDirtyModules() {
        Module[] moduleArray = this.myDirtyScopeInfo.getDirtyModules();
        if (moduleArray == null) {
            CompilerReferenceFindUsagesTestInfo.$$$reportNull$$$0(3);
        }
        return moduleArray;
    }

    Module @NotNull [] getDirtyUnsavedModules() {
        Module[] moduleArray = this.myDirtyScopeInfo.getDirtyUnsavedModules();
        if (moduleArray == null) {
            CompilerReferenceFindUsagesTestInfo.$$$reportNull$$$0(4);
        }
        return moduleArray;
    }

    VirtualFile @NotNull [] getExcludedFiles() {
        VirtualFile[] virtualFileArray = this.myDirtyScopeInfo.getExcludedFiles();
        if (virtualFileArray == null) {
            CompilerReferenceFindUsagesTestInfo.$$$reportNull$$$0(5);
        }
        return virtualFileArray;
    }

    boolean isEnabled() {
        return this.myFileIds != null;
    }

    DefaultMutableTreeNode asTree() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        if (this.isEnabled()) {
            DefaultMutableTreeNode knownOccurrences = new DefaultMutableTreeNode("Known occurrence files");
            node.add(knownOccurrences);
            for (VirtualFile file : this.getFilesWithKnownOccurrences()) {
                knownOccurrences.add(new DefaultMutableTreeNode(file));
            }
            DefaultMutableTreeNode dirtyModules = new DefaultMutableTreeNode("Dirty modules");
            node.add(dirtyModules);
            for (Module module : this.getDirtyModules()) {
                dirtyModules.add(new DefaultMutableTreeNode(module));
            }
            DefaultMutableTreeNode unsavedDirtyModules = new DefaultMutableTreeNode("Unsaved dirty modules");
            node.add(unsavedDirtyModules);
            for (Module module : this.getDirtyUnsavedModules()) {
                unsavedDirtyModules.add(new DefaultMutableTreeNode(module));
            }
            DefaultMutableTreeNode excludedFiles = new DefaultMutableTreeNode("Current excluded files");
            node.add(excludedFiles);
            for (VirtualFile excludedFile : this.getExcludedFiles()) {
                excludedFiles.add(new DefaultMutableTreeNode(excludedFile));
            }
        } else {
            node.add(new DefaultMutableTreeNode("Service is not available"));
        }
        return node;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScopeTestInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/view/CompilerReferenceFindUsagesTestInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/view/CompilerReferenceFindUsagesTestInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithKnownOccurrences";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyModules";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyUnsavedModules";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

