/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.ExportableUserDataHolderBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSetCompileScope
extends ExportableUserDataHolderBase
implements CompileScope {
    private final Set<VirtualFile> myRootFiles;
    private final Set<String> myDirectoryUrls;
    private Set<String> myUrls;
    private final Module[] myAffectedModules;

    public FileSetCompileScope(@NotNull Collection<VirtualFile> files, Module @NotNull [] modules) {
        if (files == null) {
            FileSetCompileScope.$$$reportNull$$$0(0);
        }
        if (modules == null) {
            FileSetCompileScope.$$$reportNull$$$0(1);
        }
        this.myRootFiles = new HashSet<VirtualFile>();
        this.myDirectoryUrls = new HashSet<String>();
        this.myAffectedModules = modules;
        ApplicationManager.getApplication().runReadAction(() -> {
            for (VirtualFile file : files) {
                assert (file != null);
                this.addFile(file);
            }
        });
    }

    public Module @NotNull [] getAffectedModules() {
        if (this.myAffectedModules == null) {
            FileSetCompileScope.$$$reportNull$$$0(2);
        }
        return this.myAffectedModules;
    }

    @NotNull
    public Collection<VirtualFile> getRootFiles() {
        Collection<VirtualFile> collection = Collections.unmodifiableCollection(this.myRootFiles);
        if (collection == null) {
            FileSetCompileScope.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public VirtualFile @NotNull [] getFiles(FileType fileType, boolean inSourceOnly) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        Iterator<VirtualFile> it = this.myRootFiles.iterator();
        while (it.hasNext()) {
            VirtualFile file = it.next();
            if (!file.isValid()) {
                it.remove();
                continue;
            }
            if (file.isDirectory()) {
                FileSetCompileScope.addRecursively(files, file, fileType);
                continue;
            }
            if (fileType != null && !FileTypeRegistry.getInstance().isFileOfType(file, fileType)) continue;
            files.add(file);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(files);
        if (virtualFileArray == null) {
            FileSetCompileScope.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    public boolean belongs(@NotNull String url) {
        if (url == null) {
            FileSetCompileScope.$$$reportNull$$$0(5);
        }
        if (this.getUrls().contains(url)) {
            return true;
        }
        for (String directoryUrl : this.myDirectoryUrls) {
            if (!FileUtil.startsWith((String)url, (String)directoryUrl)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Set<String> getUrls() {
        if (this.myUrls == null) {
            this.myUrls = new HashSet<String>();
            for (VirtualFile file : this.myRootFiles) {
                String url = file.getUrl();
                this.myUrls.add(url);
            }
        }
        Set<String> set = this.myUrls;
        if (set == null) {
            FileSetCompileScope.$$$reportNull$$$0(6);
        }
        return set;
    }

    private void addFile(@NotNull VirtualFile file) {
        if (file == null) {
            FileSetCompileScope.$$$reportNull$$$0(7);
        }
        if (file.isDirectory()) {
            this.myDirectoryUrls.add(file.getUrl() + "/");
        }
        this.myRootFiles.add(file);
        this.myUrls = null;
    }

    private static void addRecursively(final @NotNull Collection<? super VirtualFile> container, @NotNull VirtualFile fromDirectory, final @Nullable FileType fileType) {
        if (container == null) {
            FileSetCompileScope.$$$reportNull$$$0(8);
        }
        if (fromDirectory == null) {
            FileSetCompileScope.$$$reportNull$$$0(9);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)fromDirectory, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT}){

            public boolean visitFile(@NotNull VirtualFile child) {
                if (child == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!child.isDirectory() && (fileType == null || FileTypeRegistry.getInstance().isFileOfType(child, fileType))) {
                    container.add(child);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/compiler/impl/FileSetCompileScope$1", "visitFile"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/FileSetCompileScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/FileSetCompileScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedModules";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "belongs";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addRecursively";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

