/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="BuildProcessPlugins", storages={@Storage(value="compiler.xml")})
public class BuildProcessCustomPluginsConfiguration
implements PersistentStateComponent<BuildProcessPluginsState> {
    private static final Logger LOG = Logger.getInstance(BuildProcessCustomPluginsConfiguration.class);
    private final BuildProcessPluginsState myState = new BuildProcessPluginsState();
    private final Project myProject;

    public BuildProcessCustomPluginsConfiguration(Project project) {
        this.myProject = project;
    }

    public static BuildProcessCustomPluginsConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            BuildProcessCustomPluginsConfiguration.$$$reportNull$$$0(0);
        }
        return (BuildProcessCustomPluginsConfiguration)ServiceManager.getService((Project)project, BuildProcessCustomPluginsConfiguration.class);
    }

    public List<String> getProjectLibraries() {
        return this.myState.myProjectLibraries;
    }

    @NotNull
    public List<String> getCustomPluginsClasspath() {
        List list = (List)ReadAction.compute(() -> {
            ArrayList<String> result = new ArrayList<String>();
            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject);
            for (String libraryName : this.myState.myProjectLibraries) {
                Library library = libraryTable.getLibraryByName(libraryName);
                if (library == null) {
                    LOG.warn("Unknown project library in BuildProcessCustomPluginsConfiguration: " + libraryName);
                    continue;
                }
                for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                    result.add(VfsUtilCore.virtualToIoFile((VirtualFile)file).getAbsolutePath());
                }
            }
            return result;
        });
        if (list == null) {
            BuildProcessCustomPluginsConfiguration.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public BuildProcessPluginsState getState() {
        return this.myState;
    }

    public void loadState(@NotNull BuildProcessPluginsState state) {
        if (state == null) {
            BuildProcessCustomPluginsConfiguration.$$$reportNull$$$0(2);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/server/impl/BuildProcessCustomPluginsConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/server/impl/BuildProcessCustomPluginsConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomPluginsClasspath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BuildProcessPluginsState {
        @Property(surroundWithTag=false)
        @XCollection(elementName="project-library", valueAttributeName="name", style=XCollection.Style.v2)
        public List<String> myProjectLibraries = new ArrayList<String>();
    }
}

