/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.dfaassist;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.debugger.engine.dfaassist.DfaHint;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.BoolUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DebuggerInstructionVisitor
extends StandardInstructionVisitor {
    private final Map<PsiExpression, DfaHint> myHints = new HashMap<PsiExpression, DfaHint>();

    DebuggerInstructionVisitor() {
        super(true);
    }

    private void addHint(@NotNull PsiExpression expression2, @Nullable DfaHint hint) {
        if (expression2 == null) {
            DebuggerInstructionVisitor.$$$reportNull$$$0(0);
        }
        if (hint != null) {
            this.myHints.merge(expression2, hint, DfaHint::merge);
        }
    }

    @Override
    protected void beforeExpressionPush(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @Nullable TextRange range, @NotNull DfaMemoryState state) {
        if (value2 == null) {
            DebuggerInstructionVisitor.$$$reportNull$$$0(1);
        }
        if (expression2 == null) {
            DebuggerInstructionVisitor.$$$reportNull$$$0(2);
        }
        if (state == null) {
            DebuggerInstructionVisitor.$$$reportNull$$$0(3);
        }
        if (range != null || !DebuggerInstructionVisitor.shouldTrackExpressionValue(expression2)) {
            return;
        }
        DfaHint hint = DfaHint.ANY_VALUE;
        DfType dfType = state.getDfType(value2);
        if (dfType == DfTypes.TRUE) {
            hint = DfaHint.TRUE;
        } else if (dfType == DfTypes.FALSE) {
            hint = DfaHint.FALSE;
        } else if (dfType == DfTypes.FAIL) {
            hint = DfaHint.FAIL;
        }
        this.addHint(expression2, hint);
    }

    @Override
    protected void onTypeCast(PsiTypeCastExpression castExpression, DfaMemoryState state, boolean castPossible) {
        if (!castPossible) {
            this.addHint((PsiExpression)castExpression, DfaHint.CCE);
        }
        super.onTypeCast(castExpression, state, castPossible);
    }

    @Override
    protected void processArrayAccess(PsiArrayAccessExpression expression2, boolean alwaysOutOfBounds) {
        if (alwaysOutOfBounds) {
            this.addHint((PsiExpression)expression2, DfaHint.AIOOBE);
        }
        super.processArrayAccess(expression2, alwaysOutOfBounds);
    }

    @Override
    protected void processArrayStoreTypeMismatch(PsiAssignmentExpression assignmentExpression, PsiType fromType, PsiType toType) {
        this.addHint(assignmentExpression.getLExpression(), DfaHint.ASE);
        super.processArrayStoreTypeMismatch(assignmentExpression, fromType, toType);
    }

    @Override
    protected boolean checkNotNullable(DfaMemoryState state, @NotNull DfaValue value2, @Nullable NullabilityProblemKind.NullabilityProblem<?> problem) {
        PsiExpression expression2;
        if (value2 == null) {
            DebuggerInstructionVisitor.$$$reportNull$$$0(4);
        }
        if (problem != null && (expression2 = problem.getDereferencedExpression()) != null && problem.thrownException() != null && state.isNull(value2)) {
            DfaHint hint = problem.thrownException().equals("java.lang.NullPointerException") ? DfaHint.NPE : DfaHint.NULL_AS_NOT_NULL;
            this.addHint(expression2, hint);
        }
        return super.checkNotNullable(state, value2, problem);
    }

    private static boolean shouldTrackExpressionValue(@NotNull PsiExpression expr2) {
        IElementType tokenType;
        if (expr2 == null) {
            DebuggerInstructionVisitor.$$$reportNull$$$0(5);
        }
        if (BoolUtils.isNegated(expr2)) {
            return false;
        }
        if (expr2 instanceof PsiAssignmentExpression) {
            return false;
        }
        return !(expr2 instanceof PsiPolyadicExpression) || !(tokenType = ((PsiPolyadicExpression)expr2).getOperationTokenType()).equals(JavaTokenType.ANDAND) && !tokenType.equals(JavaTokenType.OROR);
    }

    void cleanup() {
        this.myHints.entrySet().removeIf(e -> {
            PsiExpression expr2 = (PsiExpression)e.getKey();
            DfaHint hint = (DfaHint)((Object)((Object)e.getValue()));
            if (hint.getTitle() == null) {
                return true;
            }
            CommonDataflow.DataflowResult result = CommonDataflow.getDataflowResult(expr2);
            return result != null && result.getExpressionValues(expr2).size() == 1;
        });
    }

    @NotNull
    Map<PsiExpression, DfaHint> getHints() {
        Map<PsiExpression, DfaHint> map2 = this.myHints;
        if (map2 == null) {
            DebuggerInstructionVisitor.$$$reportNull$$$0(6);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/dfaassist/DebuggerInstructionVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/dfaassist/DebuggerInstructionVisitor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addHint";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "beforeExpressionPush";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkNotNullable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldTrackExpressionValue";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

