/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.dfaassist;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.MenuOnClickPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.dfaassist.DebuggerDfaRunner;
import com.intellij.debugger.engine.dfaassist.DebuggerInstructionVisitor;
import com.intellij.debugger.engine.dfaassist.DfaHint;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VMOutOfMemoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public class DfaAssist
implements DebuggerContextListener,
Disposable {
    @NotNull
    private final Project myProject;
    private InlaySet myInlays;
    private volatile CancellablePromise<?> myPromise;
    private final DebuggerStateManager myManager;
    private volatile boolean myActive;

    private DfaAssist(@NotNull Project project, @NotNull DebuggerStateManager manager) {
        if (project == null) {
            DfaAssist.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DfaAssist.$$$reportNull$$$0(1);
        }
        this.myInlays = new InlaySet(null, Collections.emptyList());
        this.myProject = project;
        this.myManager = manager;
        this.setActive(ViewsGeneralSettings.getInstance().USE_DFA_ASSIST);
    }

    @Override
    public void changeEvent(@NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
        if (newContext == null) {
            DfaAssist.$$$reportNull$$$0(2);
        }
        if (event == DebuggerSession.Event.DISPOSE) {
            Disposer.dispose((Disposable)this);
            return;
        }
        if (!this.myActive) {
            return;
        }
        if (event == DebuggerSession.Event.DETACHED) {
            this.cleanUp();
            return;
        }
        if (event != DebuggerSession.Event.PAUSE && event != DebuggerSession.Event.REFRESH) {
            this.cancelComputation();
            return;
        }
        SourcePosition sourcePosition = newContext.getSourcePosition();
        if (sourcePosition == null) {
            this.cleanUp();
            return;
        }
        PsiJavaFile file = (PsiJavaFile)ObjectUtils.tryCast((Object)sourcePosition.getFile(), PsiJavaFile.class);
        DebugProcessImpl debugProcess = newContext.getDebugProcess();
        PsiElement element = sourcePosition.getElementAt();
        if (debugProcess == null || file == null || element == null) {
            this.cleanUp();
            return;
        }
        final SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)element);
        debugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(newContext.getSuspendContext()){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                StackFrameProxyImpl proxy;
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((proxy = suspendContext.getFrameProxy()) == null) {
                    DfaAssist.this.cleanUp();
                    return;
                }
                DebuggerDfaRunner runner = this.createRunner(proxy);
                if (runner == null) {
                    DfaAssist.this.cleanUp();
                    return;
                }
                DfaAssist.this.myPromise = ReadAction.nonBlocking(() -> DfaAssist.computeHints(runner)).withDocumentsCommitted(DfaAssist.this.myProject).coalesceBy(new Object[]{DfaAssist.this}).finishOnUiThread(ModalityState.NON_MODAL, hints -> DfaAssist.this.displayInlays(hints)).submit((Executor)AppExecutorUtil.getAppExecutorService());
            }

            @Nullable
            private DebuggerDfaRunner createRunner(StackFrameProxyImpl proxy) {
                Callable<DebuggerDfaRunner> action = () -> {
                    try {
                        StackFrame frame = proxy.getStackFrame();
                        return DfaAssist.createDfaRunner(frame, pointer.getElement());
                    }
                    catch (EvaluateException | InconsistentDebugInfoException | InternalException | InvalidStackFrameException | VMDisconnectedException | VMOutOfMemoryException ignore) {
                        return null;
                    }
                };
                return (DebuggerDfaRunner)ReadAction.nonBlocking(action).withDocumentsCommitted(DfaAssist.this.myProject).executeSynchronously();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/dfaassist/DfaAssist$1", "contextAction"));
            }
        });
    }

    private void setActive(boolean active) {
        if (this.myActive != active) {
            this.myActive = active;
            if (!this.myActive) {
                this.cleanUp();
            } else {
                DebuggerSession session = this.myManager.getContext().getDebuggerSession();
                if (session != null) {
                    session.refresh(false);
                }
            }
        }
    }

    public void dispose() {
        this.myManager.removeListener(this);
        this.cleanUp();
    }

    private void cancelComputation() {
        CancellablePromise<?> promise = this.myPromise;
        if (promise != null) {
            promise.cancel();
        }
    }

    private void cleanUp() {
        this.cancelComputation();
        ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose((Disposable)this.myInlays));
    }

    private void displayInlays(Map<PsiExpression, DfaHint> hints) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposer.dispose((Disposable)this.myInlays);
        if (hints.isEmpty()) {
            return;
        }
        EditorImpl editor = (EditorImpl)ObjectUtils.tryCast((Object)FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor(), EditorImpl.class);
        if (editor == null) {
            return;
        }
        PsiFile psiFile = hints.keySet().iterator().next().getContainingFile();
        if (psiFile == null) {
            return;
        }
        VirtualFile expectedFile = psiFile.getVirtualFile();
        if (expectedFile == null || !expectedFile.equals(editor.getVirtualFile())) {
            return;
        }
        InlayModelImpl model = editor.getInlayModel();
        ArrayList newInlays = new ArrayList();
        TurnOffDfaProcessorAction turnOffDfaProcessor = new TurnOffDfaProcessorAction();
        hints.forEach((arg_0, arg_1) -> this.lambda$displayInlays$2(editor, turnOffDfaProcessor, newInlays, (InlayModel)model, arg_0, arg_1));
        if (!newInlays.isEmpty()) {
            this.myInlays = new InlaySet((Editor)editor, newInlays);
        }
    }

    @NotNull
    private static Map<PsiExpression, DfaHint> computeHints(@NotNull DebuggerDfaRunner runner) {
        DebuggerInstructionVisitor visitor2;
        RunnerResult result;
        if (runner == null) {
            DfaAssist.$$$reportNull$$$0(3);
        }
        if ((result = runner.interpret(visitor2 = new DebuggerInstructionVisitor())) != RunnerResult.OK) {
            Map<PsiExpression, DfaHint> map2 = Collections.emptyMap();
            if (map2 == null) {
                DfaAssist.$$$reportNull$$$0(4);
            }
            return map2;
        }
        visitor2.cleanup();
        Map<PsiExpression, DfaHint> map3 = visitor2.getHints();
        if (map3 == null) {
            DfaAssist.$$$reportNull$$$0(5);
        }
        return map3;
    }

    @Nullable
    static DebuggerDfaRunner createDfaRunner(@NotNull StackFrame frame, @Nullable PsiElement element) {
        if (frame == null) {
            DfaAssist.$$$reportNull$$$0(6);
        }
        if (element == null || !element.isValid() || DumbService.isDumb((Project)element.getProject())) {
            return null;
        }
        if (!DfaAssist.locationMatches(element, frame.location())) {
            return null;
        }
        PsiElement anchor = DfaAssist.getAnchor(element);
        if (anchor == null) {
            return null;
        }
        PsiElement body2 = DfaAssist.getCodeBlock(anchor);
        if (body2 == null) {
            return null;
        }
        DebuggerDfaRunner runner = new DebuggerDfaRunner(body2, anchor, frame);
        return runner.isValid() ? runner : null;
    }

    private static boolean locationMatches(@NotNull PsiElement element, Location location) {
        if (element == null) {
            DfaAssist.$$$reportNull$$$0(7);
        }
        Method method = location.method();
        PsiElement context = DebuggerUtilsEx.getContainingMethod(element);
        if (context instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)context;
            String name2 = psiMethod.isConstructor() ? "<init>" : psiMethod.getName();
            return name2.equals(method.name()) && psiMethod.getParameterList().getParametersCount() == method.argumentTypeNames().size();
        }
        if (context instanceof PsiLambdaExpression) {
            return DebuggerUtilsEx.isLambda(method) && method.argumentTypeNames().size() >= ((PsiLambdaExpression)context).getParameterList().getParametersCount();
        }
        if (context instanceof PsiClassInitializer) {
            String expectedMethod = ((PsiClassInitializer)context).hasModifierProperty("static") ? "<clinit>" : "<init>";
            return method.name().equals(expectedMethod);
        }
        return false;
    }

    private static PsiElement getAnchor(@NotNull PsiElement element) {
        if (element == null) {
            DfaAssist.$$$reportNull$$$0(8);
        }
        while (element instanceof PsiWhiteSpace || element instanceof PsiComment) {
            element = element.getNextSibling();
        }
        while (!(element instanceof PsiStatement)) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiStatement || parent != null && element.getTextRangeInParent().getStartOffset() <= 0)) {
                PsiElement grandParent;
                IElementType tokenType;
                PsiElement grandParent2;
                if (parent instanceof PsiCodeBlock && ((PsiCodeBlock)parent).getRBrace() == element && (grandParent2 = parent.getParent()) instanceof PsiBlockStatement) {
                    return PsiTreeUtil.getNextSiblingOfType((PsiElement)grandParent2, PsiStatement.class);
                }
                if (parent instanceof PsiPolyadicExpression && ((tokenType = ((PsiPolyadicExpression)parent).getOperationTokenType()).equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR)) && ((grandParent = parent.getParent()) instanceof PsiIfStatement || grandParent instanceof PsiYieldStatement || grandParent instanceof PsiReturnStatement)) {
                    if (element instanceof PsiExpression) {
                        return element;
                    }
                    return PsiTreeUtil.getNextSiblingOfType((PsiElement)element, PsiExpression.class);
                }
                return null;
            }
            element = parent;
        }
        return element;
    }

    @Nullable
    private static PsiElement getCodeBlock(@NotNull PsiElement anchor) {
        if (anchor == null) {
            DfaAssist.$$$reportNull$$$0(9);
        }
        if (anchor instanceof PsiWhileStatement || anchor instanceof PsiDoWhileStatement) {
            return anchor;
        }
        PsiElement e = anchor;
        while (e != null && !(e instanceof PsiClass) && !(e instanceof PsiFileSystemItem)) {
            PsiElement parent;
            if ((e = e.getParent()) instanceof PsiCodeBlock && ((parent = e.getParent()) instanceof PsiMethod || parent instanceof PsiLambdaExpression || parent instanceof PsiClassInitializer || parent instanceof PsiTryStatement && ((PsiTryStatement)parent).getFinallyBlock() == e || parent instanceof PsiBlockStatement && (parent.getParent() instanceof PsiLoopStatement || parent.getParent() instanceof PsiSwitchLabeledRuleStatement && ((PsiSwitchLabeledRuleStatement)parent.getParent()).getEnclosingSwitchBlock() instanceof PsiSwitchExpression))) {
                if (parent.getParent() instanceof PsiDoWhileStatement) {
                    return parent.getParent();
                }
                return e;
            }
            if (!(e instanceof PsiDoWhileStatement)) continue;
            return e;
        }
        return null;
    }

    public static void installDfaAssist(@NotNull DebuggerSession javaSession, @NotNull XDebugSession session) {
        DebuggerStateManager manager;
        DebuggerContextImpl context;
        Project project;
        if (javaSession == null) {
            DfaAssist.$$$reportNull$$$0(10);
        }
        if (session == null) {
            DfaAssist.$$$reportNull$$$0(11);
        }
        if ((project = (context = (manager = javaSession.getContextManager()).getContext()).getProject()) != null) {
            final DfaAssist assist = new DfaAssist(project, manager);
            manager.addListener(assist);
            session.addSessionListener(new XDebugSessionListener(){

                public void settingsChanged() {
                    assist.setActive(ViewsGeneralSettings.getInstance().USE_DFA_ASSIST);
                }
            }, (Disposable)assist);
        }
    }

    private /* synthetic */ void lambda$displayInlays$2(EditorImpl editor, AnAction turnOffDfaProcessor, List newInlays, InlayModel model, PsiExpression expr2, DfaHint hint) {
        TextRange range = expr2.getTextRange();
        if (range == null) {
            return;
        }
        PresentationFactory factory = new PresentationFactory(editor);
        MenuOnClickPresentation presentation = new MenuOnClickPresentation(factory.roundWithBackground(factory.smallText(hint.getTitle())), this.myProject, () -> Collections.singletonList(turnOffDfaProcessor));
        newInlays.add(model.addInlineElement(range.getEndOffset(), (EditorCustomElementRenderer)new PresentationRenderer((InlayPresentation)presentation)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/dfaassist/DfaAssist";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSession";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/dfaassist/DfaAssist";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "changeEvent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeHints";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDfaRunner";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "locationMatches";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAnchor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCodeBlock";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "installDfaAssist";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TurnOffDfaProcessorAction
    extends AnAction {
        private TurnOffDfaProcessorAction() {
            super(JavaDebuggerBundle.message((String)"action.TurnOffDfaAssist.text", (Object[])new Object[0]), JavaDebuggerBundle.message((String)"action.TurnOffDfaAssist.description", (Object[])new Object[0]), AllIcons.Actions.Cancel);
        }

        public void actionPerformed(@NotNull AnActionEvent evt) {
            if (evt == null) {
                TurnOffDfaProcessorAction.$$$reportNull$$$0(0);
            }
            Disposer.dispose((Disposable)DfaAssist.this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/debugger/engine/dfaassist/DfaAssist$TurnOffDfaProcessorAction", "actionPerformed"));
        }
    }

    private static class InlaySet
    implements Disposable {
        @NotNull
        private final List<Inlay<?>> myInlays;

        private InlaySet(@Nullable Editor editor, @NotNull List<Inlay<?>> inlays) {
            if (inlays == null) {
                InlaySet.$$$reportNull$$$0(0);
            }
            this.myInlays = inlays;
            if (editor != null) {
                editor.getDocument().addDocumentListener(new DocumentListener(){

                    public void beforeDocumentChange(@NotNull DocumentEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose((Disposable)this));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/engine/dfaassist/DfaAssist$InlaySet$1", "beforeDocumentChange"));
                    }
                }, (Disposable)this);
            }
        }

        public void dispose() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myInlays.forEach(Disposer::dispose);
            this.myInlays.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlays", "com/intellij/debugger/engine/dfaassist/DfaAssist$InlaySet", "<init>"));
        }
    }
}

