/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.dfaassist;

import org.jetbrains.annotations.NotNull;

enum DfaHint {
    NONE(null),
    ANY_VALUE(null, true),
    TRUE("= true", true),
    FALSE("= false", true),
    NPE("[NullPointerException]"),
    NULL_AS_NOT_NULL("[Null passed where not-null expected]"),
    CCE("[ClassCastException]"),
    ASE("[ArrayStoreException]"),
    AIOOBE("[ArrayIndexOutOfBoundsException]"),
    FAIL("[Method will fail]", true);

    private final String myTitle;
    private final boolean myValue;

    private DfaHint(String title) {
        this(title, false);
    }

    private DfaHint(String title, boolean value2) {
        this.myTitle = title;
        this.myValue = value2;
    }

    String getTitle() {
        return this.myTitle;
    }

    @NotNull
    DfaHint merge(@NotNull DfaHint other) {
        if (other == null) {
            DfaHint.$$$reportNull$$$0(0);
        }
        if (other == this) {
            DfaHint dfaHint = this;
            if (dfaHint == null) {
                DfaHint.$$$reportNull$$$0(1);
            }
            return dfaHint;
        }
        if (this.myValue && other.myValue) {
            DfaHint dfaHint = ANY_VALUE;
            if (dfaHint == null) {
                DfaHint.$$$reportNull$$$0(2);
            }
            return dfaHint;
        }
        if (this.myValue) {
            DfaHint dfaHint = other;
            if (dfaHint == null) {
                DfaHint.$$$reportNull$$$0(3);
            }
            return dfaHint;
        }
        if (other.myValue) {
            DfaHint dfaHint = this;
            if (dfaHint == null) {
                DfaHint.$$$reportNull$$$0(4);
            }
            return dfaHint;
        }
        DfaHint dfaHint = NONE;
        if (dfaHint == null) {
            DfaHint.$$$reportNull$$$0(5);
        }
        return dfaHint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/dfaassist/DfaHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/dfaassist/DfaHint";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

