/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ArrayAccessEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ArrayInitializerEvaluator;
import com.intellij.debugger.engine.evaluation.expression.AssertStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.AssignmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BinaryExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BlockStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BreakContinueStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.CaptureTraverser;
import com.intellij.debugger.engine.evaluation.expression.CatchEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ClassObjectEvaluator;
import com.intellij.debugger.engine.evaluation.expression.CodeFragmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ConditionalExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.DoWhileStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionListEvaluator;
import com.intellij.debugger.engine.evaluation.expression.FieldEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ForStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ForeachStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IdentityEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IfStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.InstanceofEvaluator;
import com.intellij.debugger.engine.evaluation.expression.LiteralEvaluator;
import com.intellij.debugger.engine.evaluation.expression.LocalVariableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.MethodEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.NewArrayInstanceEvaluator;
import com.intellij.debugger.engine.evaluation.expression.NewClassInstanceEvaluator;
import com.intellij.debugger.engine.evaluation.expression.PostfixOperationEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ReturnEvaluator;
import com.intellij.debugger.engine.evaluation.expression.SuperEvaluator;
import com.intellij.debugger.engine.evaluation.expression.SwitchStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.SyntheticVariableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ThisEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ThrowEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TryEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeCastEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnaryExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.engine.evaluation.expression.WhileStatementEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethodObject.ExtractLightMethodObjectHandler;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluatorBuilderImpl
implements EvaluatorBuilder {
    private static final EvaluatorBuilderImpl ourInstance = new EvaluatorBuilderImpl();

    private EvaluatorBuilderImpl() {
    }

    public static EvaluatorBuilder getInstance() {
        return ourInstance;
    }

    public static ExpressionEvaluator build(TextWithImports text2, @Nullable PsiElement contextElement, @Nullable SourcePosition position, @NotNull Project project) throws EvaluateException {
        CodeFragmentFactory factory;
        JavaCodeFragment codeFragment;
        if (project == null) {
            EvaluatorBuilderImpl.$$$reportNull$$$0(0);
        }
        if ((codeFragment = (factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text2, contextElement)).createCodeFragment(text2, contextElement, project)) == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{text2.getText()}));
        }
        DebuggerUtils.checkSyntax((PsiCodeFragment)codeFragment);
        return factory.getEvaluatorBuilder().build((PsiElement)codeFragment, position);
    }

    public ExpressionEvaluator build(PsiElement codeFragment, SourcePosition position) throws EvaluateException {
        return new Builder(position).buildElement(codeFragment);
    }

    private static void processBoxingConversions(PsiParameter[] declaredParams, PsiExpression[] actualArgumentExpressions, PsiSubstitutor methodResolveSubstitutor, Evaluator[] argumentEvaluators) {
        if (declaredParams.length > 0) {
            int paramCount = Math.max(declaredParams.length, actualArgumentExpressions.length);
            PsiType varargType = null;
            for (int idx = 0; idx < paramCount && idx < actualArgumentExpressions.length; ++idx) {
                PsiType actualArgType;
                PsiType declaredParamType;
                if (idx < declaredParams.length) {
                    declaredParamType = methodResolveSubstitutor.substitute(declaredParams[idx].getType());
                    if (declaredParamType instanceof PsiEllipsisType) {
                        declaredParamType = varargType = ((PsiEllipsisType)declaredParamType).getComponentType();
                    }
                } else {
                    if (varargType == null) break;
                    declaredParamType = varargType;
                }
                if (!TypeConversionUtil.boxingConversionApplicable((PsiType)declaredParamType, (PsiType)(actualArgType = actualArgumentExpressions[idx].getType())) && (declaredParamType == null || actualArgType != null)) continue;
                Evaluator argEval = argumentEvaluators[idx];
                argumentEvaluators[idx] = declaredParamType instanceof PsiPrimitiveType ? new UnBoxingEvaluator(argEval) : new BoxingEvaluator(argEval);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl", "build"));
    }

    private static class CompilingEvaluatorTypesUtil {
        private CompilingEvaluatorTypesUtil() {
        }

        @NotNull
        private static PsiType getVariableType(@NotNull PsiVariable variable) {
            PsiType typeToUse;
            PsiType type2;
            PsiClass psiClass;
            if (variable == null) {
                CompilingEvaluatorTypesUtil.$$$reportNull$$$0(0);
            }
            if ((psiClass = PsiTypesUtil.getPsiClass((PsiType)(type2 = variable.getType()))) != null && (typeToUse = (PsiType)psiClass.getUserData(ExtractLightMethodObjectHandler.REFERENCED_TYPE)) != null) {
                type2 = typeToUse;
            }
            PsiType psiType = type2;
            if (psiType == null) {
                CompilingEvaluatorTypesUtil.$$$reportNull$$$0(1);
            }
            return psiType;
        }

        @Nullable
        private static PsiMethod getReferencedMethod(@NotNull JavaResolveResult resolveResult) {
            PsiMethod psiMethod;
            PsiMethod methodToUseInstead;
            if (resolveResult == null) {
                CompilingEvaluatorTypesUtil.$$$reportNull$$$0(2);
            }
            PsiMethod psiMethod2 = methodToUseInstead = (psiMethod = (PsiMethod)resolveResult.getElement()) == null ? null : (PsiMethod)psiMethod.getUserData(ExtractLightMethodObjectHandler.REFERENCE_METHOD);
            if (methodToUseInstead != null) {
                psiMethod = methodToUseInstead;
            }
            return psiMethod;
        }

        @Nullable
        private static PsiClass getClass(@NotNull PsiClassType classType) {
            PsiClass aClass;
            PsiType type2;
            if (classType == null) {
                CompilingEvaluatorTypesUtil.$$$reportNull$$$0(3);
            }
            PsiType psiType = type2 = (aClass = classType.resolve()) == null ? null : (PsiType)aClass.getUserData(ExtractLightMethodObjectHandler.REFERENCED_TYPE);
            if (type2 != null) {
                return PsiTypesUtil.getPsiClass((PsiType)type2);
            }
            return aClass;
        }

        @Nullable
        @Contract(value="null -> null")
        private static PsiMethod getReferencedConstructor(@Nullable PsiMethod originalConstructor) {
            if (originalConstructor == null) {
                return null;
            }
            PsiMethod methodToUseInstead = (PsiMethod)originalConstructor.getUserData(ExtractLightMethodObjectHandler.REFERENCE_METHOD);
            return methodToUseInstead == null ? originalConstructor : methodToUseInstead;
        }

        @NotNull
        private static PsiType getClassType(@NotNull PsiClassType expressionPsiType) {
            PsiClass aClass;
            if (expressionPsiType == null) {
                CompilingEvaluatorTypesUtil.$$$reportNull$$$0(4);
            }
            PsiType type2 = (aClass = expressionPsiType.resolve()) == null ? null : (PsiType)aClass.getUserData(ExtractLightMethodObjectHandler.REFERENCED_TYPE);
            Object object = type2 != null ? type2 : expressionPsiType;
            if (object == null) {
                CompilingEvaluatorTypesUtil.$$$reportNull$$$0(5);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl$CompilingEvaluatorTypesUtil";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolveResult";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionPsiType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl$CompilingEvaluatorTypesUtil";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariableType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariableType";
                    break;
                }
                case 1: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencedMethod";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getClass";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getClassType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Builder
    extends JavaElementVisitor {
        private static final Logger LOG = Logger.getInstance(EvaluatorBuilderImpl.class);
        private Evaluator myResult = null;
        private PsiClass myContextPsiClass;
        private CodeFragmentEvaluator myCurrentFragmentEvaluator;
        private final Set<JavaCodeFragment> myVisitedFragments = new HashSet<JavaCodeFragment>();
        @Nullable
        private final SourcePosition myPosition;
        @Nullable
        private final PsiClass myPositionPsiClass;

        private Builder(@Nullable SourcePosition position) {
            this.myPosition = position;
            this.myPositionPsiClass = JVMNameUtil.getClassAt(this.myPosition);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitCodeFragment(JavaCodeFragment codeFragment) {
            this.myVisitedFragments.add(codeFragment);
            ArrayList<Evaluator> evaluators = new ArrayList<Evaluator>();
            CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
            try {
                for (PsiElement child = codeFragment.getFirstChild(); child != null; child = child.getNextSibling()) {
                    child.accept((PsiElementVisitor)this);
                    if (this.myResult != null) {
                        evaluators.add(this.myResult);
                    }
                    this.myResult = null;
                }
                this.myCurrentFragmentEvaluator.setStatements(evaluators.toArray(new Evaluator[0]));
                this.myResult = this.myCurrentFragmentEvaluator;
            }
            finally {
                this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
            }
        }

        public void visitErrorElement(@NotNull PsiErrorElement element) {
            if (element == null) {
                Builder.$$$reportNull$$$0(0);
            }
            Builder.throwExpressionInvalid((PsiElement)element);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            PsiExpression rExpression = expression2.getRExpression();
            if (rExpression == null) {
                Builder.throwExpressionInvalid((PsiElement)expression2);
            }
            rExpression.accept((PsiElementVisitor)this);
            Evaluator rEvaluator = this.myResult;
            PsiExpression lExpression = expression2.getLExpression();
            PsiType lType = lExpression.getType();
            if (lType == null) {
                Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{lExpression.getText()}));
            }
            IElementType assignmentType = expression2.getOperationTokenType();
            PsiType rType = rExpression.getType();
            if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)lType, (PsiExpression)rExpression) && rType != null) {
                Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{expression2.getOperationSign().getText()}));
            }
            lExpression.accept((PsiElementVisitor)this);
            Evaluator lEvaluator = this.myResult;
            rEvaluator = Builder.handleAssignmentBoxingAndPrimitiveTypeConversions(lType, rType, rEvaluator, expression2.getProject());
            if (assignmentType != JavaTokenType.EQ) {
                IElementType opType = TypeConversionUtil.convertEQtoOperation((IElementType)assignmentType);
                PsiType typeForBinOp = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)opType, (boolean)true);
                if (typeForBinOp == null || rType == null) {
                    Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression2.getText()}));
                }
                rEvaluator = Builder.createBinaryEvaluator(lEvaluator, lType, rEvaluator, rType, opType, typeForBinOp);
            }
            this.myResult = new AssignmentEvaluator(lEvaluator, rEvaluator);
        }

        private static Evaluator handleAssignmentBoxingAndPrimitiveTypeConversions(PsiType lType, PsiType rType, Evaluator rEvaluator, Project project) {
            PsiClassType rightBoxed;
            PsiPrimitiveType unboxedLType = PsiPrimitiveType.getUnboxedType((PsiType)lType);
            if (unboxedLType != null) {
                if (rType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)rType)) {
                    if (!rType.equals(unboxedLType)) {
                        rEvaluator = Builder.createTypeCastEvaluator(rEvaluator, (PsiType)unboxedLType);
                    }
                    rEvaluator = new BoxingEvaluator(rEvaluator);
                }
            } else if (lType instanceof PsiPrimitiveType) {
                PsiPrimitiveType unboxedRType;
                PsiPrimitiveType _rType;
                if (rType instanceof PsiClassType) {
                    rEvaluator = new UnBoxingEvaluator(rEvaluator);
                }
                Object object = _rType = (unboxedRType = PsiPrimitiveType.getUnboxedType((PsiType)rType)) != null ? unboxedRType : rType;
                if (_rType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)_rType) && !lType.equals(_rType)) {
                    rEvaluator = Builder.createTypeCastEvaluator(rEvaluator, lType);
                }
            } else if (lType instanceof PsiClassType && rType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)rType) && (rightBoxed = ((PsiPrimitiveType)rType).getBoxedType(PsiManager.getInstance((Project)project), ((PsiClassType)lType).getResolveScope())) != null && TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rightBoxed)) {
                rEvaluator = new BoxingEvaluator(rEvaluator);
            }
            return rEvaluator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitTryStatement(PsiTryStatement statement) {
            if (statement.getResourceList() != null) {
                throw new EvaluateRuntimeException(new UnsupportedExpressionException("Try with resources is not yet supported"));
            }
            Evaluator bodyEvaluator = this.accept((PsiElement)statement.getTryBlock());
            if (bodyEvaluator != null) {
                PsiCatchSection[] catchSections = statement.getCatchSections();
                ArrayList<CatchEvaluator> evaluators = new ArrayList<CatchEvaluator>();
                for (PsiCatchSection catchSection : catchSections) {
                    PsiParameter parameter2 = catchSection.getParameter();
                    PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                    if (parameter2 == null || catchBlock == null) continue;
                    CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
                    try {
                        this.myCurrentFragmentEvaluator.setInitialValue(parameter2.getName(), null);
                        this.myCurrentFragmentEvaluator.setStatements(this.visitStatements(catchBlock.getStatements()));
                        PsiType type2 = parameter2.getType();
                        List types = type2 instanceof PsiDisjunctionType ? ((PsiDisjunctionType)type2).getDisjunctions() : Collections.singletonList(type2);
                        for (PsiType psiType : types) {
                            evaluators.add(new CatchEvaluator(psiType.getCanonicalText(), parameter2.getName(), this.myCurrentFragmentEvaluator));
                        }
                    }
                    finally {
                        this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
                    }
                }
                this.myResult = new TryEvaluator(bodyEvaluator, evaluators, this.accept((PsiElement)statement.getFinallyBlock()));
            }
        }

        public void visitThrowStatement(PsiThrowStatement statement) {
            Evaluator accept = this.accept((PsiElement)statement.getException());
            if (accept != null) {
                this.myResult = new ThrowEvaluator(accept);
            }
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            this.myResult = new ReturnEvaluator(this.accept((PsiElement)statement.getReturnValue()));
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
            throw new EvaluateRuntimeException(new UnsupportedExpressionException("Synchronized is not yet supported"));
        }

        public void visitStatement(PsiStatement statement) {
            LOG.error(JavaDebuggerBundle.message((String)"evaluation.error.statement.not.supported", (Object[])new Object[]{statement.getText()}));
            Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.statement.not.supported", (Object[])new Object[]{statement.getText()}));
        }

        private CodeFragmentEvaluator setNewCodeFragmentEvaluator() {
            CodeFragmentEvaluator old = this.myCurrentFragmentEvaluator;
            this.myCurrentFragmentEvaluator = new CodeFragmentEvaluator(this.myCurrentFragmentEvaluator);
            return old;
        }

        private Evaluator[] visitStatements(PsiStatement[] statements) {
            ArrayList<Evaluator> evaluators = new ArrayList<Evaluator>();
            for (PsiStatement psiStatement : statements) {
                psiStatement.accept((PsiElementVisitor)this);
                if (this.myResult != null) {
                    evaluators.add(DisableGC.create(this.myResult));
                }
                this.myResult = null;
            }
            return evaluators.toArray(new Evaluator[0]);
        }

        public void visitCodeBlock(PsiCodeBlock block) {
            CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
            try {
                this.myResult = new BlockStatementEvaluator(this.visitStatements(block.getStatements()));
            }
            finally {
                this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
            }
        }

        public void visitBlockStatement(PsiBlockStatement statement) {
            this.visitCodeBlock(statement.getCodeBlock());
        }

        public void visitLabeledStatement(PsiLabeledStatement labeledStatement) {
            PsiStatement statement = labeledStatement.getStatement();
            if (statement != null) {
                statement.accept((PsiElementVisitor)this);
            }
        }

        private static String getLabel(PsiElement element) {
            String label = null;
            if (element.getParent() instanceof PsiLabeledStatement) {
                label = ((PsiLabeledStatement)element.getParent()).getName();
            }
            return label;
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            Evaluator bodyEvaluator = this.accept((PsiElement)statement.getBody());
            Evaluator conditionEvaluator = this.accept((PsiElement)statement.getCondition());
            if (conditionEvaluator != null) {
                this.myResult = new DoWhileStatementEvaluator(new UnBoxingEvaluator(conditionEvaluator), bodyEvaluator, Builder.getLabel((PsiElement)statement));
            }
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            Evaluator bodyEvaluator = this.accept((PsiElement)statement.getBody());
            Evaluator conditionEvaluator = this.accept((PsiElement)statement.getCondition());
            if (conditionEvaluator != null) {
                this.myResult = new WhileStatementEvaluator(new UnBoxingEvaluator(conditionEvaluator), bodyEvaluator, Builder.getLabel((PsiElement)statement));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitForStatement(PsiForStatement statement) {
            CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
            try {
                Evaluator initializerEvaluator = this.accept((PsiElement)statement.getInitialization());
                Evaluator conditionEvaluator = this.accept((PsiElement)statement.getCondition());
                if (conditionEvaluator != null) {
                    conditionEvaluator = new UnBoxingEvaluator(conditionEvaluator);
                }
                Evaluator updateEvaluator = this.accept((PsiElement)statement.getUpdate());
                Evaluator bodyEvaluator = this.accept((PsiElement)statement.getBody());
                if (bodyEvaluator != null) {
                    this.myResult = new ForStatementEvaluator(initializerEvaluator, conditionEvaluator, updateEvaluator, bodyEvaluator, Builder.getLabel((PsiElement)statement));
                }
            }
            finally {
                this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitForeachStatement(PsiForeachStatement statement) {
            CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
            try {
                PsiParameter parameter2 = statement.getIterationParameter();
                String iterationParameterName = parameter2.getName();
                this.myCurrentFragmentEvaluator.setInitialValue(iterationParameterName, null);
                SyntheticVariableEvaluator iterationParameterEvaluator = new SyntheticVariableEvaluator(this.myCurrentFragmentEvaluator, iterationParameterName, null);
                Evaluator iteratedValueEvaluator = this.accept((PsiElement)statement.getIteratedValue());
                Evaluator bodyEvaluator = this.accept((PsiElement)statement.getBody());
                if (bodyEvaluator != null) {
                    this.myResult = new ForeachStatementEvaluator(iterationParameterEvaluator, iteratedValueEvaluator, bodyEvaluator, Builder.getLabel((PsiElement)statement));
                }
            }
            finally {
                this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
            }
        }

        @Nullable
        private Evaluator accept(@Nullable PsiElement element) {
            if (element == null || element instanceof PsiEmptyStatement) {
                return null;
            }
            element.accept((PsiElementVisitor)this);
            return this.myResult;
        }

        public void visitIfStatement(PsiIfStatement statement) {
            PsiExpression condition2;
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            thenBranch.accept((PsiElementVisitor)this);
            Evaluator thenEvaluator = this.myResult;
            PsiStatement elseBranch = statement.getElseBranch();
            Evaluator elseEvaluator = null;
            if (elseBranch != null) {
                elseBranch.accept((PsiElementVisitor)this);
                elseEvaluator = this.myResult;
            }
            if ((condition2 = statement.getCondition()) == null) {
                return;
            }
            condition2.accept((PsiElementVisitor)this);
            this.myResult = new IfStatementEvaluator(new UnBoxingEvaluator(this.myResult), thenEvaluator, elseEvaluator);
        }

        public void visitSwitchStatement(PsiSwitchStatement statement) {
            Evaluator expressionEvaluator;
            PsiCodeBlock body2 = statement.getBody();
            if (body2 != null && (expressionEvaluator = this.accept((PsiElement)statement.getExpression())) != null) {
                this.myResult = new SwitchStatementEvaluator(expressionEvaluator, this.visitStatements(body2.getStatements()), Builder.getLabel((PsiElement)statement));
            }
        }

        public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
            SmartList evaluators = new SmartList();
            PsiExpressionList caseValues2 = statement.getCaseValues();
            if (caseValues2 != null) {
                for (PsiExpression expression2 : caseValues2.getExpressions()) {
                    Evaluator evaluator = this.accept((PsiElement)expression2);
                    if (evaluator == null) continue;
                    evaluators.add(evaluator);
                }
            }
            this.myResult = new SwitchStatementEvaluator.SwitchCaseEvaluator((List<? extends Evaluator>)evaluators, statement.isDefaultCase());
        }

        public void visitBreakStatement(PsiBreakStatement statement) {
            PsiIdentifier labelIdentifier = statement.getLabelIdentifier();
            this.myResult = BreakContinueStatementEvaluator.createBreakEvaluator(labelIdentifier != null ? labelIdentifier.getText() : null);
        }

        public void visitContinueStatement(PsiContinueStatement statement) {
            PsiIdentifier labelIdentifier = statement.getLabelIdentifier();
            this.myResult = BreakContinueStatementEvaluator.createContinueEvaluator(labelIdentifier != null ? labelIdentifier.getText() : null);
        }

        public void visitExpressionListStatement(PsiExpressionListStatement statement) {
            this.myResult = new ExpressionListEvaluator(ContainerUtil.mapNotNull((Object[])statement.getExpressionList().getExpressions(), this::accept));
        }

        public void visitEmptyStatement(PsiEmptyStatement statement) {
        }

        public void visitExpressionStatement(PsiExpressionStatement statement) {
            statement.getExpression().accept((PsiElementVisitor)this);
        }

        public void visitExpression(PsiExpression expression2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitExpression " + expression2);
            }
        }

        public void visitPolyadicExpression(PsiPolyadicExpression wideExpression) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitPolyadicExpression " + wideExpression);
            }
            PsiExpression[] operands2 = wideExpression.getOperands();
            operands2[0].accept((PsiElementVisitor)this);
            Evaluator result = this.myResult;
            PsiType lType = operands2[0].getType();
            for (int i = 1; i < operands2.length; ++i) {
                PsiType typeForBinOp;
                PsiExpression expression2 = operands2[i];
                if (expression2 == null) {
                    Builder.throwExpressionInvalid((PsiElement)wideExpression);
                }
                expression2.accept((PsiElementVisitor)this);
                Evaluator rResult = this.myResult;
                IElementType opType = wideExpression.getOperationTokenType();
                PsiType rType = expression2.getType();
                if (rType == null) {
                    Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression2.getText()}));
                }
                if ((typeForBinOp = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)opType, (boolean)true)) == null) {
                    Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{wideExpression.getText()}));
                }
                this.myResult = Builder.createBinaryEvaluator(result, lType, rResult, rType, opType, typeForBinOp);
                lType = typeForBinOp;
                result = this.myResult;
            }
        }

        private static Evaluator createBinaryEvaluator(Evaluator lResult, PsiType lType, Evaluator rResult, @NotNull PsiType rType, @NotNull IElementType operation, @NotNull PsiType expressionExpectedType) {
            if (rType == null) {
                Builder.$$$reportNull$$$0(1);
            }
            if (operation == null) {
                Builder.$$$reportNull$$$0(2);
            }
            if (expressionExpectedType == null) {
                Builder.$$$reportNull$$$0(3);
            }
            if (Builder.isUnboxingInBinaryExpressionApplicable(lType, rType, operation)) {
                if (rType instanceof PsiClassType && UnBoxingEvaluator.isTypeUnboxable(rType.getCanonicalText())) {
                    rResult = new UnBoxingEvaluator(rResult);
                }
                if (lType instanceof PsiClassType && UnBoxingEvaluator.isTypeUnboxable(lType.getCanonicalText())) {
                    lResult = new UnBoxingEvaluator(lResult);
                }
            }
            if (Builder.isBinaryNumericPromotionApplicable(lType, rType, operation)) {
                PsiType _lType = lType;
                PsiPrimitiveType unboxedLType = PsiPrimitiveType.getUnboxedType((PsiType)lType);
                if (unboxedLType != null) {
                    _lType = unboxedLType;
                }
                PsiType _rType = rType;
                PsiPrimitiveType unboxedRType = PsiPrimitiveType.getUnboxedType((PsiType)rType);
                if (unboxedRType != null) {
                    _rType = unboxedRType;
                }
                if (PsiType.DOUBLE.equals((Object)_lType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_rType, (PsiType)PsiType.DOUBLE)) {
                        rResult = Builder.createTypeCastEvaluator(rResult, (PsiType)PsiType.DOUBLE);
                    }
                } else if (PsiType.DOUBLE.equals((Object)_rType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_lType, (PsiType)PsiType.DOUBLE)) {
                        lResult = Builder.createTypeCastEvaluator(lResult, (PsiType)PsiType.DOUBLE);
                    }
                } else if (PsiType.FLOAT.equals((Object)_lType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_rType, (PsiType)PsiType.FLOAT)) {
                        rResult = Builder.createTypeCastEvaluator(rResult, (PsiType)PsiType.FLOAT);
                    }
                } else if (PsiType.FLOAT.equals((Object)_rType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_lType, (PsiType)PsiType.FLOAT)) {
                        lResult = Builder.createTypeCastEvaluator(lResult, (PsiType)PsiType.FLOAT);
                    }
                } else if (PsiType.LONG.equals((Object)_lType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_rType, (PsiType)PsiType.LONG)) {
                        rResult = Builder.createTypeCastEvaluator(rResult, (PsiType)PsiType.LONG);
                    }
                } else if (PsiType.LONG.equals((Object)_rType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_lType, (PsiType)PsiType.LONG)) {
                        lResult = Builder.createTypeCastEvaluator(lResult, (PsiType)PsiType.LONG);
                    }
                } else {
                    if (!PsiType.INT.equals((Object)_lType) && TypeConversionUtil.areTypesConvertible((PsiType)_lType, (PsiType)PsiType.INT)) {
                        lResult = Builder.createTypeCastEvaluator(lResult, (PsiType)PsiType.INT);
                    }
                    if (!PsiType.INT.equals((Object)_rType) && TypeConversionUtil.areTypesConvertible((PsiType)_rType, (PsiType)PsiType.INT)) {
                        rResult = Builder.createTypeCastEvaluator(rResult, (PsiType)PsiType.INT);
                    }
                }
            } else if (operation == JavaTokenType.GTGT || operation == JavaTokenType.LTLT || operation == JavaTokenType.GTGTGT) {
                lResult = Builder.handleUnaryNumericPromotion(lType, lResult);
                rResult = Builder.handleUnaryNumericPromotion(rType, rResult);
            }
            return DisableGC.create(new BinaryExpressionEvaluator(lResult, rResult, operation, expressionExpectedType.getCanonicalText()));
        }

        private static boolean isBinaryNumericPromotionApplicable(PsiType lType, PsiType rType, IElementType opType) {
            if (lType == null || rType == null) {
                return false;
            }
            if (!TypeConversionUtil.isNumericType((PsiType)lType) || !TypeConversionUtil.isNumericType((PsiType)rType)) {
                return false;
            }
            if (opType == JavaTokenType.EQEQ || opType == JavaTokenType.NE) {
                if (PsiType.NULL.equals((Object)lType) || PsiType.NULL.equals((Object)rType)) {
                    return false;
                }
                if (lType instanceof PsiClassType && rType instanceof PsiClassType) {
                    return false;
                }
                if (lType instanceof PsiClassType) {
                    return PsiPrimitiveType.getUnboxedType((PsiType)lType) != null;
                }
                if (rType instanceof PsiClassType) {
                    return PsiPrimitiveType.getUnboxedType((PsiType)rType) != null;
                }
                return true;
            }
            return opType == JavaTokenType.ASTERISK || opType == JavaTokenType.DIV || opType == JavaTokenType.PERC || opType == JavaTokenType.PLUS || opType == JavaTokenType.MINUS || opType == JavaTokenType.LT || opType == JavaTokenType.LE || opType == JavaTokenType.GT || opType == JavaTokenType.GE || opType == JavaTokenType.AND || opType == JavaTokenType.XOR || opType == JavaTokenType.OR;
        }

        private static boolean isUnboxingInBinaryExpressionApplicable(PsiType lType, PsiType rType, IElementType opCode) {
            if (PsiType.NULL.equals((Object)lType) || PsiType.NULL.equals((Object)rType)) {
                return false;
            }
            if (opCode == JavaTokenType.EQEQ || opCode == JavaTokenType.NE) {
                return lType instanceof PsiPrimitiveType && rType instanceof PsiClassType || lType instanceof PsiClassType && rType instanceof PsiPrimitiveType;
            }
            if (opCode == JavaTokenType.PLUS && (lType instanceof PsiClassType && lType.equalsToText("java.lang.String") || rType instanceof PsiClassType && rType.equalsToText("java.lang.String"))) {
                return false;
            }
            return lType instanceof PsiClassType || rType instanceof PsiClassType;
        }

        @Nullable
        private static PsiType calcUnaryNumericPromotionType(PsiPrimitiveType type2) {
            if (PsiType.BYTE.equals((Object)type2) || PsiType.SHORT.equals((Object)type2) || PsiType.CHAR.equals((Object)type2) || PsiType.INT.equals((Object)type2)) {
                return PsiType.INT;
            }
            return null;
        }

        public void visitDeclarationStatement(PsiDeclarationStatement statement) {
            PsiElement[] declaredElements;
            ArrayList<AssignmentEvaluator> evaluators = new ArrayList<AssignmentEvaluator>();
            for (PsiElement declaredElement : declaredElements = statement.getDeclaredElements()) {
                if (declaredElement instanceof PsiLocalVariable) {
                    if (this.myCurrentFragmentEvaluator != null) {
                        PsiLocalVariable localVariable = (PsiLocalVariable)declaredElement;
                        PsiType lType = localVariable.getType();
                        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)localVariable.getProject());
                        try {
                            PsiExpression initialValue = elementFactory.createExpressionFromText(PsiTypesUtil.getDefaultValueOfType((PsiType)lType), null);
                            Object value2 = JavaConstantExpressionEvaluator.computeConstantExpression(initialValue, true);
                            this.myCurrentFragmentEvaluator.setInitialValue(localVariable.getName(), value2);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                        PsiExpression initializer = localVariable.getInitializer();
                        if (initializer == null) continue;
                        try {
                            if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)lType, (PsiExpression)initializer)) {
                                Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.incompatible.variable.initializer.type", (Object[])new Object[]{localVariable.getName()}));
                            }
                            PsiType rType = initializer.getType();
                            initializer.accept((PsiElementVisitor)this);
                            Evaluator rEvaluator = this.myResult;
                            PsiExpression localVarReference = elementFactory.createExpressionFromText(localVariable.getName(), (PsiElement)initializer);
                            localVarReference.accept((PsiElementVisitor)this);
                            Evaluator lEvaluator = this.myResult;
                            rEvaluator = Builder.handleAssignmentBoxingAndPrimitiveTypeConversions(localVarReference.getType(), rType, rEvaluator, statement.getProject());
                            AssignmentEvaluator assignment = new AssignmentEvaluator(lEvaluator, rEvaluator);
                            evaluators.add(assignment);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                        continue;
                    }
                    throw new EvaluateRuntimeException(new EvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.local.variable.declarations.not.supported", (Object[])new Object[0]), null));
                }
                throw new EvaluateRuntimeException(new EvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unsupported.declaration", (Object[])new Object[]{declaredElement.getText()}), null));
            }
            if (!evaluators.isEmpty()) {
                CodeFragmentEvaluator codeFragmentEvaluator = new CodeFragmentEvaluator(this.myCurrentFragmentEvaluator);
                codeFragmentEvaluator.setStatements(evaluators.toArray(new Evaluator[0]));
                this.myResult = codeFragmentEvaluator;
            } else {
                this.myResult = null;
            }
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitConditionalExpression " + expression2);
            }
            PsiExpression thenExpression2 = expression2.getThenExpression();
            PsiExpression elseExpression2 = expression2.getElseExpression();
            if (thenExpression2 == null || elseExpression2 == null) {
                Builder.throwExpressionInvalid((PsiElement)expression2);
            }
            PsiExpression condition2 = expression2.getCondition();
            condition2.accept((PsiElementVisitor)this);
            if (this.myResult == null) {
                Builder.throwExpressionInvalid((PsiElement)condition2);
            }
            UnBoxingEvaluator conditionEvaluator = new UnBoxingEvaluator(this.myResult);
            thenExpression2.accept((PsiElementVisitor)this);
            if (this.myResult == null) {
                Builder.throwExpressionInvalid((PsiElement)thenExpression2);
            }
            Evaluator thenEvaluator = this.myResult;
            elseExpression2.accept((PsiElementVisitor)this);
            if (this.myResult == null) {
                Builder.throwExpressionInvalid((PsiElement)elseExpression2);
            }
            Evaluator elseEvaluator = this.myResult;
            this.myResult = new ConditionalExpressionEvaluator(conditionEvaluator, thenEvaluator, elseEvaluator);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitReferenceExpression " + expression2);
            }
            PsiExpression qualifier = expression2.getQualifierExpression();
            JavaResolveResult resolveResult = expression2.advancedResolve(true);
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
                Value labeledValue = (Value)element.getUserData(CodeFragmentFactoryContextWrapper.LABEL_VARIABLE_VALUE_KEY);
                if (labeledValue != null) {
                    this.myResult = new IdentityEvaluator(labeledValue);
                    return;
                }
                PsiFile containingFile = element.getContainingFile();
                if (containingFile instanceof PsiCodeFragment && this.myCurrentFragmentEvaluator != null && this.myVisitedFragments.contains(containingFile)) {
                    JVMName jvmName = JVMNameUtil.getJVMQualifiedName(CompilingEvaluatorTypesUtil.getVariableType((PsiVariable)element));
                    this.myResult = new SyntheticVariableEvaluator(this.myCurrentFragmentEvaluator, ((PsiVariable)element).getName(), jvmName);
                    return;
                }
                PsiVariable psiVar = (PsiVariable)element;
                String localName = psiVar.getName();
                PsiClass variableClass = this.getContainingClass(psiVar);
                PsiClass positionClass = this.getPositionClass();
                if (Objects.equals(positionClass, variableClass)) {
                    PsiElement method = DebuggerUtilsEx.getContainingMethod((PsiElement)expression2);
                    boolean canScanFrames = method instanceof PsiLambdaExpression || ContextUtil.isJspImplicit(element);
                    this.myResult = new LocalVariableEvaluator(localName, canScanFrames);
                    return;
                }
                CaptureTraverser traverser = this.createTraverser((PsiElement)variableClass, "Base class not found for " + psiVar.getName(), false).oneLevelLess();
                if (traverser.isValid()) {
                    Object value2;
                    PsiExpression initializer = psiVar.getInitializer();
                    if (initializer != null && (value2 = JavaPsiFacade.getInstance((Project)psiVar.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)initializer)) != null) {
                        PsiType type2 = resolveResult.getSubstitutor().substitute(psiVar.getType());
                        this.myResult = new LiteralEvaluator(value2, type2.getCanonicalText());
                        return;
                    }
                    ThisEvaluator objectEvaluator = new ThisEvaluator(traverser);
                    this.myResult = Builder.createFallbackEvaluator(new FieldEvaluator(objectEvaluator, FieldEvaluator.createClassFilter(positionClass), "val$" + localName), new LocalVariableEvaluator(localName, true));
                    return;
                }
                Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.local.variable.missing.from.class.closure", (Object[])new Object[]{localName}));
            } else if (element instanceof PsiField) {
                Evaluator objectEvaluator;
                PsiField psiField = (PsiField)element;
                PsiClass fieldClass = psiField.getContainingClass();
                if (fieldClass == null) {
                    Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.cannot.resolve.field.class", (Object[])new Object[]{psiField.getName()}));
                    return;
                }
                if (psiField.hasModifierProperty("static")) {
                    JVMName className2 = JVMNameUtil.getContextClassJVMQualifiedName(SourcePosition.createFromElement((PsiElement)psiField));
                    if (className2 == null) {
                        className2 = JVMNameUtil.getJVMQualifiedName(fieldClass);
                    }
                    objectEvaluator = new TypeEvaluator(className2);
                } else if (qualifier != null) {
                    qualifier.accept((PsiElementVisitor)this);
                    objectEvaluator = this.myResult;
                } else {
                    CaptureTraverser traverser = this.createTraverser((PsiElement)fieldClass, fieldClass.getName(), true);
                    if (!traverser.isValid()) {
                        Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.cannot.sources.for.field.class", (Object[])new Object[]{psiField.getName()}));
                    }
                    objectEvaluator = new ThisEvaluator(traverser);
                }
                this.myResult = new FieldEvaluator(objectEvaluator, FieldEvaluator.createClassFilter(fieldClass), psiField.getName());
            } else {
                PsiElement nameElement = expression2.getReferenceNameElement();
                if (!(nameElement instanceof PsiIdentifier)) {
                    String elementDisplayString = nameElement != null ? nameElement.getText() : "(null)";
                    Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.identifier.expected", (Object[])new Object[]{elementDisplayString}));
                    return;
                }
                String name2 = nameElement.getText();
                if (qualifier != null) {
                    PsiElement qualifierTarget;
                    PsiElement psiElement = qualifierTarget = qualifier instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifier).resolve() : null;
                    if (qualifierTarget instanceof PsiClass) {
                        PsiClass psiClass = (PsiClass)qualifierTarget;
                        JVMName typeName = JVMNameUtil.getJVMQualifiedName(psiClass);
                        this.myResult = new FieldEvaluator(new TypeEvaluator(typeName), FieldEvaluator.createClassFilter(psiClass), name2);
                    } else {
                        qualifier.accept((PsiElementVisitor)this);
                        if (this.myResult == null) {
                            Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.cannot.evaluate.qualifier", (Object[])new Object[]{qualifier.getText()}));
                        }
                        this.myResult = new FieldEvaluator(this.myResult, FieldEvaluator.createClassFilter(qualifier.getType()), name2);
                    }
                } else {
                    this.myResult = Builder.createFallbackEvaluator(new LocalVariableEvaluator(name2, false), new FieldEvaluator(new ThisEvaluator(), FieldEvaluator.TargetClassFilter.ALL, name2));
                }
            }
        }

        private static Evaluator createFallbackEvaluator(final Evaluator primary, final Evaluator fallback) {
            return new Evaluator(){
                private boolean myIsFallback;

                @Override
                public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
                    try {
                        return primary.evaluate(context);
                    }
                    catch (EvaluateException e) {
                        try {
                            Object res = fallback.evaluate(context);
                            this.myIsFallback = true;
                            return res;
                        }
                        catch (EvaluateException e1) {
                            throw e;
                        }
                    }
                }

                @Override
                public Modifier getModifier() {
                    return this.myIsFallback ? fallback.getModifier() : primary.getModifier();
                }
            };
        }

        private static void throwExpressionInvalid(PsiElement expression2) {
            Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{expression2.getText()}));
        }

        private static void throwEvaluateException(String message2) throws EvaluateRuntimeException {
            throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)message2));
        }

        public void visitSuperExpression(PsiSuperExpression expression2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitSuperExpression " + expression2);
            }
            this.myResult = new SuperEvaluator(this.createTraverser(expression2.getQualifier()));
        }

        public void visitThisExpression(PsiThisExpression expression2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitThisExpression " + expression2);
            }
            this.myResult = new ThisEvaluator(this.createTraverser(expression2.getQualifier()));
        }

        private CaptureTraverser createTraverser(PsiJavaCodeReferenceElement qualifier) {
            if (qualifier != null) {
                return this.createTraverser(qualifier.resolve(), qualifier.getText(), false);
            }
            return CaptureTraverser.direct();
        }

        private CaptureTraverser createTraverser(PsiElement targetClass, String name2, boolean checkInheritance) {
            PsiClass fromClass = this.getPositionClass();
            if (!(targetClass instanceof PsiClass) || fromClass == null) {
                Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{name2}));
            }
            try {
                CaptureTraverser traverser = CaptureTraverser.create((PsiClass)targetClass, fromClass, checkInheritance);
                if (!traverser.isValid() && !fromClass.equals(this.myContextPsiClass)) {
                    return CaptureTraverser.create((PsiClass)targetClass, this.myContextPsiClass, checkInheritance);
                }
                return traverser;
            }
            catch (Exception e) {
                throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((Throwable)e));
            }
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
            PsiTypeElement checkType;
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitInstanceOfExpression " + expression2);
            }
            if ((checkType = expression2.getCheckType()) == null) {
                Builder.throwExpressionInvalid((PsiElement)expression2);
            }
            PsiType type2 = checkType.getType();
            expression2.getOperand().accept((PsiElementVisitor)this);
            Evaluator operandEvaluator = this.myResult;
            this.myResult = new InstanceofEvaluator(operandEvaluator, new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(type2)));
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
            PsiExpression expr2;
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitParenthesizedExpression " + expression2);
            }
            if ((expr2 = expression2.getExpression()) != null) {
                expr2.accept((PsiElementVisitor)this);
            }
        }

        public void visitPostfixExpression(PsiPostfixExpression expression2) {
            if (expression2.getType() == null) {
                Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression2.getText()}));
            }
            PsiExpression operandExpression = expression2.getOperand();
            operandExpression.accept((PsiElementVisitor)this);
            Evaluator operandEvaluator = this.myResult;
            IElementType operation = expression2.getOperationTokenType();
            PsiType operandType = operandExpression.getType();
            @Nullable PsiPrimitiveType unboxedOperandType = PsiPrimitiveType.getUnboxedType((PsiType)operandType);
            Evaluator incrementImpl = Builder.createBinaryEvaluator(operandEvaluator, operandType, new LiteralEvaluator(1, "int"), (PsiType)PsiType.INT, operation == JavaTokenType.PLUSPLUS ? JavaTokenType.PLUS : JavaTokenType.MINUS, (PsiType)(unboxedOperandType != null ? unboxedOperandType : operandType));
            if (unboxedOperandType != null) {
                incrementImpl = new BoxingEvaluator(incrementImpl);
            }
            this.myResult = new PostfixOperationEvaluator(operandEvaluator, incrementImpl);
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            PsiExpression operandExpression;
            PsiType expressionType = expression2.getType();
            if (expressionType == null) {
                Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression2.getText()}));
            }
            if ((operandExpression = expression2.getOperand()) == null) {
                Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.operand", (Object[])new Object[]{expression2.getText()}));
            }
            operandExpression.accept((PsiElementVisitor)this);
            Evaluator operandEvaluator = this.myResult;
            PsiType operandType = operandExpression.getType();
            @Nullable PsiPrimitiveType unboxedOperandType = PsiPrimitiveType.getUnboxedType((PsiType)operandType);
            IElementType operation = expression2.getOperationTokenType();
            if (operation == JavaTokenType.PLUSPLUS || operation == JavaTokenType.MINUSMINUS) {
                try {
                    Evaluator rightEval = Builder.createBinaryEvaluator(operandEvaluator, operandType, new LiteralEvaluator(1, "int"), (PsiType)PsiType.INT, operation == JavaTokenType.PLUSPLUS ? JavaTokenType.PLUS : JavaTokenType.MINUS, (PsiType)(unboxedOperandType != null ? unboxedOperandType : operandType));
                    this.myResult = new AssignmentEvaluator(operandEvaluator, unboxedOperandType != null ? new BoxingEvaluator(rightEval) : rightEval);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            } else {
                if (JavaTokenType.PLUS.equals(operation) || JavaTokenType.MINUS.equals(operation) || JavaTokenType.TILDE.equals(operation)) {
                    operandEvaluator = Builder.handleUnaryNumericPromotion(operandType, operandEvaluator);
                } else if (unboxedOperandType != null) {
                    operandEvaluator = new UnBoxingEvaluator(operandEvaluator);
                }
                this.myResult = new UnaryExpressionEvaluator(operation, expressionType.getCanonicalText(), operandEvaluator, expression2.getOperationSign().getText());
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            Evaluator objectEvaluator;
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitMethodCallExpression " + expression2);
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] argExpressions = argumentList.getExpressions();
            Evaluator[] argumentEvaluators = new Evaluator[argExpressions.length];
            for (int idx = 0; idx < argExpressions.length; ++idx) {
                PsiExpression psiExpression = argExpressions[idx];
                psiExpression.accept((PsiElementVisitor)this);
                if (this.myResult == null) {
                    Builder.throwExpressionInvalid((PsiElement)psiExpression);
                }
                argumentEvaluators[idx] = DisableGC.create(this.myResult);
            }
            PsiReferenceExpression methodExpr = expression2.getMethodExpression();
            JavaResolveResult resolveResult = methodExpr.advancedResolve(false);
            PsiMethod psiMethod = CompilingEvaluatorTypesUtil.getReferencedMethod(resolveResult);
            PsiExpression qualifier = methodExpr.getQualifierExpression();
            JVMName contextClass = null;
            if (psiMethod != null) {
                PsiClass methodPsiClass = psiMethod.getContainingClass();
                contextClass = JVMNameUtil.getJVMQualifiedName(methodPsiClass);
                if (psiMethod.hasModifierProperty("static")) {
                    objectEvaluator = new TypeEvaluator(contextClass);
                } else if (qualifier != null) {
                    qualifier.accept((PsiElementVisitor)this);
                    objectEvaluator = this.myResult;
                } else {
                    CaptureTraverser traverser = CaptureTraverser.direct();
                    PsiElement currentFileResolveScope = resolveResult.getCurrentFileResolveScope();
                    if (currentFileResolveScope instanceof PsiClass) {
                        traverser = this.createTraverser(currentFileResolveScope, ((PsiClass)currentFileResolveScope).getName(), false);
                    }
                    objectEvaluator = new ThisEvaluator(traverser);
                }
            } else if (qualifier != null) {
                PsiType type2 = qualifier.getType();
                if (type2 != null) {
                    contextClass = JVMNameUtil.getJVMQualifiedName(type2);
                }
                if (qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).resolve() instanceof PsiClass) {
                    if (contextClass == null) {
                        contextClass = JVMNameUtil.getJVMRawText(((PsiReferenceExpression)qualifier).getQualifiedName());
                    }
                    objectEvaluator = new TypeEvaluator(contextClass);
                } else {
                    qualifier.accept((PsiElementVisitor)this);
                    objectEvaluator = this.myResult;
                }
            } else {
                objectEvaluator = new ThisEvaluator();
                PsiClass positionClass = this.getPositionClass();
                if (positionClass != null) {
                    contextClass = JVMNameUtil.getJVMQualifiedName(positionClass);
                }
            }
            if (objectEvaluator == null) {
                Builder.throwExpressionInvalid((PsiElement)expression2);
            }
            if (psiMethod != null && !psiMethod.isConstructor() && psiMethod.getReturnType() == null) {
                Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.method.return.type", (Object[])new Object[]{psiMethod.getText()}));
            }
            boolean defaultInterfaceMethod = false;
            boolean mustBeVararg = false;
            if (psiMethod != null) {
                EvaluatorBuilderImpl.processBoxingConversions(psiMethod.getParameterList().getParameters(), argExpressions, resolveResult.getSubstitutor(), argumentEvaluators);
                defaultInterfaceMethod = psiMethod.hasModifierProperty("default");
                mustBeVararg = psiMethod.isVarArgs();
            }
            this.myResult = new MethodEvaluator(objectEvaluator, contextClass, methodExpr.getReferenceName(), psiMethod != null ? JVMNameUtil.getJVMSignature(psiMethod) : null, argumentEvaluators, defaultInterfaceMethod, mustBeVararg);
        }

        public void visitLiteralExpression(PsiLiteralExpression expression2) {
            HighlightInfo parsingError = HighlightUtil.checkLiteralExpressionParsingError(expression2, PsiUtil.getLanguageLevel((PsiElement)expression2), null);
            if (parsingError != null) {
                Builder.throwEvaluateException(parsingError.getDescription());
                return;
            }
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                Builder.throwEvaluateException(expression2 + ": null type");
                return;
            }
            this.myResult = new LiteralEvaluator(expression2.getValue(), type2.getCanonicalText());
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
            PsiExpression indexExpression = expression2.getIndexExpression();
            if (indexExpression == null) {
                Builder.throwExpressionInvalid((PsiElement)expression2);
            }
            indexExpression.accept((PsiElementVisitor)this);
            Evaluator indexEvaluator = Builder.handleUnaryNumericPromotion(indexExpression.getType(), this.myResult);
            expression2.getArrayExpression().accept((PsiElementVisitor)this);
            Evaluator arrayEvaluator = this.myResult;
            this.myResult = new ArrayAccessEvaluator(arrayEvaluator, indexEvaluator);
        }

        private static Evaluator handleUnaryNumericPromotion(PsiType operandExpressionType, Evaluator operandEvaluator) {
            PsiType promotionType;
            PsiPrimitiveType _unboxedIndexType;
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)operandExpressionType);
            if (unboxedType != null && !PsiType.BOOLEAN.equals((Object)unboxedType)) {
                operandEvaluator = new UnBoxingEvaluator(operandEvaluator);
            }
            Object object = _unboxedIndexType = unboxedType != null ? unboxedType : operandExpressionType;
            if (_unboxedIndexType instanceof PsiPrimitiveType && (promotionType = Builder.calcUnaryNumericPromotionType(_unboxedIndexType)) != null) {
                operandEvaluator = Builder.createTypeCastEvaluator(operandEvaluator, promotionType);
            }
            return operandEvaluator;
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
            boolean performCastToWrapperClass;
            PsiExpression operandExpr = expression2.getOperand();
            if (operandExpr == null) {
                Builder.throwExpressionInvalid((PsiElement)expression2);
            }
            operandExpr.accept((PsiElementVisitor)this);
            Evaluator operandEvaluator = this.myResult;
            PsiTypeElement castTypeElem = expression2.getCastType();
            if (castTypeElem == null) {
                Builder.throwExpressionInvalid((PsiElement)expression2);
            }
            PsiType castType = castTypeElem.getType();
            PsiType operandType = operandExpr.getType();
            if (operandType != null && !TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)castType) && PsiUtil.resolveClassInType((PsiType)operandType) != null) {
                throw new EvaluateRuntimeException(new EvaluateException(JavaErrorBundle.message("inconvertible.type.cast", JavaHighlightUtil.formatType(operandType), JavaHighlightUtil.formatType(castType))));
            }
            boolean shouldPerformBoxingConversion = operandType != null && TypeConversionUtil.boxingConversionApplicable((PsiType)castType, (PsiType)operandType);
            boolean castingToPrimitive = castType instanceof PsiPrimitiveType;
            if (shouldPerformBoxingConversion && castingToPrimitive) {
                operandEvaluator = new UnBoxingEvaluator(operandEvaluator);
            }
            boolean bl = performCastToWrapperClass = shouldPerformBoxingConversion && !castingToPrimitive;
            if (!(PsiUtil.resolveClassInClassTypeOnly((PsiType)castType) instanceof PsiTypeParameter)) {
                if (performCastToWrapperClass) {
                    castType = (PsiType)ObjectUtils.notNull((Object)PsiPrimitiveType.getUnboxedType((PsiType)castType), (Object)operandType);
                }
                this.myResult = Builder.createTypeCastEvaluator(operandEvaluator, castType);
            }
            if (performCastToWrapperClass) {
                this.myResult = new BoxingEvaluator(this.myResult);
            }
        }

        private static TypeCastEvaluator createTypeCastEvaluator(Evaluator operandEvaluator, PsiType castType) {
            if (castType instanceof PsiPrimitiveType) {
                return new TypeCastEvaluator(operandEvaluator, castType.getCanonicalText());
            }
            return new TypeCastEvaluator(operandEvaluator, new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(castType)));
        }

        public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
            PsiType type2 = expression2.getOperand().getType();
            if (type2 instanceof PsiPrimitiveType) {
                JVMName typeName = JVMNameUtil.getJVMRawText(((PsiPrimitiveType)type2).getBoxedTypeName());
                this.myResult = new FieldEvaluator(new TypeEvaluator(typeName), FieldEvaluator.TargetClassFilter.ALL, "TYPE");
            } else {
                this.myResult = new ClassObjectEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(type2)));
            }
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
            throw new EvaluateRuntimeException(new UnsupportedExpressionException(JavaDebuggerBundle.message((String)"evaluation.error.lambda.evaluation.not.supported", (Object[])new Object[0])));
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            PsiElement qualifier = expression2.getQualifier();
            PsiType interfaceType = expression2.getFunctionalInterfaceType();
            if (!Registry.is((String)"debugger.compiling.evaluator.method.refs") && interfaceType != null && qualifier != null) {
                String code = null;
                try {
                    PsiElement resolved = expression2.resolve();
                    if (resolved instanceof PsiMethod) {
                        PsiMethod method = (PsiMethod)resolved;
                        PsiClass containingClass = method.getContainingClass();
                        if (containingClass != null) {
                            String find;
                            boolean bind = false;
                            if (method.isConstructor()) {
                                find = "findConstructor(" + containingClass.getQualifiedName() + ".class, mt)";
                            } else if (qualifier instanceof PsiSuperExpression) {
                                find = "in(" + containingClass.getQualifiedName() + ".class).findSpecial(" + containingClass.getQualifiedName() + ".class, \"" + method.getName() + "\", mt, " + containingClass.getQualifiedName() + ".class)";
                                bind = true;
                            } else {
                                find = containingClass.getQualifiedName() + ".class, \"" + method.getName() + "\", mt)";
                                if (method.hasModifier(JvmModifier.STATIC)) {
                                    find = "findStatic(" + find;
                                } else {
                                    find = "findVirtual(" + find;
                                    if (qualifier instanceof PsiReference) {
                                        PsiElement resolve2 = ((PsiReference)qualifier).resolve();
                                        if (!(resolve2 instanceof PsiClass)) {
                                            bind = true;
                                        }
                                    } else {
                                        bind = true;
                                    }
                                }
                            }
                            String bidStr = bind ? "mh = mh.bindTo(" + qualifier.getText() + ");\n" : "";
                            code = "MethodType mt = MethodType.fromMethodDescriptorString(\"" + JVMNameUtil.getJVMSignature(method) + "\", null);\nMethodHandle mh = MethodHandles.lookup()." + find + ";\n" + bidStr + "MethodHandleProxies.asInterfaceInstance(" + interfaceType.getCanonicalText() + ".class, mh);";
                        }
                    } else if (PsiUtil.isArrayClass((PsiElement)resolved)) {
                        code = "MethodType mt = MethodType.methodType(Object.class, Class.class, int.class);\nMethodHandle mh = MethodHandles.publicLookup().findStatic(Array.class, \"newInstance\", mt);\nmh = mh.bindTo(" + StringUtil.substringBeforeLast((String)qualifier.getText(), (String)"[]") + ".class)\nMethodHandleProxies.asInterfaceInstance(" + interfaceType.getCanonicalText() + ".class, mh);";
                    }
                    if (code != null) {
                        this.myResult = this.buildFromJavaCode(code, "java.lang.invoke.MethodHandle,java.lang.invoke.MethodHandleProxies,java.lang.invoke.MethodHandles,java.lang.invoke.MethodType,java.lang.reflect.Array", (PsiElement)expression2);
                        return;
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
            throw new EvaluateRuntimeException(new UnsupportedExpressionException(JavaDebuggerBundle.message((String)"evaluation.error.method.reference.evaluation.not.supported", (Object[])new Object[0])));
        }

        private Evaluator buildFromJavaCode(String code, String imports2, @NotNull PsiElement context) {
            if (context == null) {
                Builder.$$$reportNull$$$0(4);
            }
            TextWithImportsImpl text2 = new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, code, imports2, (FileType)StdFileTypes.JAVA);
            JavaCodeFragment codeFragment = DefaultCodeFragmentFactory.getInstance().createCodeFragment(text2, context, context.getProject());
            return this.accept((PsiElement)codeFragment);
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            PsiType expressionPsiType = expression2.getType();
            if (expressionPsiType instanceof PsiArrayType) {
                Evaluator dimensionEvaluator = null;
                PsiExpression[] dimensions = expression2.getArrayDimensions();
                if (dimensions.length == 1) {
                    PsiExpression dimensionExpression = dimensions[0];
                    dimensionExpression.accept((PsiElementVisitor)this);
                    if (this.myResult != null) {
                        dimensionEvaluator = Builder.handleUnaryNumericPromotion(dimensionExpression.getType(), this.myResult);
                    } else {
                        Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.invalid.array.dimension.expression", (Object[])new Object[]{dimensionExpression.getText()}));
                    }
                } else if (dimensions.length > 1) {
                    Builder.throwEvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.multi.dimensional.arrays.creation.not.supported", (Object[])new Object[0]));
                }
                Evaluator initializerEvaluator = null;
                PsiArrayInitializerExpression arrayInitializer = expression2.getArrayInitializer();
                if (arrayInitializer != null) {
                    if (dimensionEvaluator != null) {
                        Builder.throwExpressionInvalid((PsiElement)expression2);
                    }
                    arrayInitializer.accept((PsiElementVisitor)this);
                    if (this.myResult != null) {
                        initializerEvaluator = Builder.handleUnaryNumericPromotion(arrayInitializer.getType(), this.myResult);
                    } else {
                        Builder.throwExpressionInvalid((PsiElement)arrayInitializer);
                    }
                }
                if (dimensionEvaluator == null && initializerEvaluator == null) {
                    Builder.throwExpressionInvalid((PsiElement)expression2);
                }
                this.myResult = new NewArrayInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(expressionPsiType)), dimensionEvaluator, initializerEvaluator);
            } else if (expressionPsiType instanceof PsiClassType) {
                PsiClass containingClass;
                PsiClass aClass = CompilingEvaluatorTypesUtil.getClass((PsiClassType)expressionPsiType);
                if (aClass instanceof PsiAnonymousClass) {
                    throw new EvaluateRuntimeException(new UnsupportedExpressionException(JavaDebuggerBundle.message((String)"evaluation.error.anonymous.class.evaluation.not.supported", (Object[])new Object[0])));
                }
                PsiExpressionList argumentList = expression2.getArgumentList();
                if (argumentList == null) {
                    Builder.throwExpressionInvalid((PsiElement)expression2);
                }
                PsiExpression[] argExpressions = argumentList.getExpressions();
                JavaResolveResult constructorResolveResult = expression2.resolveMethodGenerics();
                PsiMethod constructor = CompilingEvaluatorTypesUtil.getReferencedConstructor((PsiMethod)constructorResolveResult.getElement());
                if (constructor == null && argExpressions.length > 0) {
                    throw new EvaluateRuntimeException(new EvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.cannot.resolve.constructor", (Object[])new Object[]{expression2.getText()}), null));
                }
                Object[] argumentEvaluators = new Evaluator[argExpressions.length];
                for (int idx = 0; idx < argExpressions.length; ++idx) {
                    PsiExpression argExpression = argExpressions[idx];
                    argExpression.accept((PsiElementVisitor)this);
                    if (this.myResult != null) {
                        argumentEvaluators[idx] = DisableGC.create(this.myResult);
                        continue;
                    }
                    Builder.throwExpressionInvalid((PsiElement)argExpression);
                }
                if (constructor != null) {
                    EvaluatorBuilderImpl.processBoxingConversions(constructor.getParameterList().getParameters(), argExpressions, constructorResolveResult.getSubstitutor(), (Evaluator[])argumentEvaluators);
                }
                if (aClass != null && (containingClass = aClass.getContainingClass()) != null && !aClass.hasModifierProperty("static")) {
                    PsiExpression qualifier = expression2.getQualifier();
                    if (qualifier != null) {
                        qualifier.accept((PsiElementVisitor)this);
                        if (this.myResult != null) {
                            argumentEvaluators = (Evaluator[])ArrayUtil.prepend((Object)this.myResult, (Object[])argumentEvaluators);
                        }
                    } else {
                        argumentEvaluators = (Evaluator[])ArrayUtil.prepend((Object)new ThisEvaluator(this.createTraverser((PsiElement)containingClass, "this", false)), (Object[])argumentEvaluators);
                    }
                }
                JVMName signature = JVMNameUtil.getJVMConstructorSignature(constructor, aClass);
                PsiType instanceType = CompilingEvaluatorTypesUtil.getClassType((PsiClassType)expressionPsiType);
                this.myResult = new NewClassInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(instanceType)), signature, (Evaluator[])argumentEvaluators);
            } else if (expressionPsiType != null) {
                Builder.throwEvaluateException("Unsupported expression type: " + expressionPsiType.getPresentableText());
            } else {
                Builder.throwEvaluateException("Unknown type for expression: " + expression2.getText());
            }
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
            PsiExpression[] initializers = expression2.getInitializers();
            Evaluator[] evaluators = new Evaluator[initializers.length];
            PsiType type2 = expression2.getType();
            boolean primitive = type2 instanceof PsiArrayType && ((PsiArrayType)type2).getComponentType() instanceof PsiPrimitiveType;
            for (int idx = 0; idx < initializers.length; ++idx) {
                PsiExpression initializer = initializers[idx];
                initializer.accept((PsiElementVisitor)this);
                if (this.myResult != null) {
                    Evaluator coerced = primitive ? Builder.handleUnaryNumericPromotion(initializer.getType(), this.myResult) : new BoxingEvaluator(this.myResult);
                    evaluators[idx] = DisableGC.create(coerced);
                    continue;
                }
                Builder.throwExpressionInvalid((PsiElement)initializer);
            }
            this.myResult = new ArrayInitializerEvaluator(evaluators);
            if (type2 != null && !(expression2.getParent() instanceof PsiNewExpression)) {
                this.myResult = new NewArrayInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(type2)), null, this.myResult);
            }
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
            PsiExpression description;
            PsiExpression condition2 = statement.getAssertCondition();
            if (condition2 == null) {
                Builder.throwEvaluateException("Assert condition expected in: " + statement.getText());
            }
            String descriptionText = (description = statement.getAssertDescription()) != null ? description.getText() : "";
            this.myResult = new AssertStatementEvaluator(this.buildFromJavaCode("if (!(" + condition2.getText() + ")) { throw new java.lang.AssertionError(" + descriptionText + ");}", "", (PsiElement)statement));
        }

        @Nullable
        private PsiClass getContainingClass(@NotNull PsiVariable variable) {
            PsiClass element;
            if (variable == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return (element = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)variable.getParent(), PsiClass.class, (boolean)false)) == null ? this.myContextPsiClass : element;
        }

        @Nullable
        private PsiClass getPositionClass() {
            return this.myPositionPsiClass != null ? this.myPositionPsiClass : this.myContextPsiClass;
        }

        protected ExpressionEvaluator buildElement(PsiElement element) throws EvaluateException {
            LOG.assertTrue(element.isValid());
            this.myContextPsiClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)element, PsiClass.class, (boolean)false);
            try {
                element.accept((PsiElementVisitor)this);
            }
            catch (EvaluateRuntimeException e) {
                throw e.getCause();
            }
            if (this.myResult == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{element.toString()}));
            }
            return new ExpressionEvaluatorImpl(this.myResult);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionExpectedType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitErrorElement";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createBinaryEvaluator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildFromJavaCode";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContainingClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

