/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.descriptors.data;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.ui.impl.watch.MethodReturnValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.sun.jdi.Method;
import com.sun.jdi.Value;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodReturnValueData
extends DescriptorData<MethodReturnValueDescriptorImpl> {
    @Nullable
    private final Value myReturnValue;
    @NotNull
    private final Method myMethod;

    public MethodReturnValueData(@NotNull Method method, @Nullable Value returnValue) {
        if (method == null) {
            MethodReturnValueData.$$$reportNull$$$0(0);
        }
        this.myMethod = method;
        this.myReturnValue = returnValue;
    }

    @Nullable
    public Value getReturnValue() {
        return this.myReturnValue;
    }

    @NotNull
    public Method getMethod() {
        Method method = this.myMethod;
        if (method == null) {
            MethodReturnValueData.$$$reportNull$$$0(1);
        }
        return method;
    }

    @Override
    protected MethodReturnValueDescriptorImpl createDescriptorImpl(@NotNull Project project) {
        if (project == null) {
            MethodReturnValueData.$$$reportNull$$$0(2);
        }
        return new MethodReturnValueDescriptorImpl(project, this.myMethod, this.myReturnValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodReturnValueData that = (MethodReturnValueData)o;
        if (!this.myMethod.equals(that.myMethod)) {
            return false;
        }
        return Objects.equals(this.myReturnValue, that.myReturnValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.myReturnValue, this.myMethod);
    }

    @Override
    public DisplayKey<MethodReturnValueDescriptorImpl> getDisplayKey() {
        return new MethodReturnValueDisplayKey(this.myMethod, this.myReturnValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/descriptors/data/MethodReturnValueData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/descriptors/data/MethodReturnValueData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptorImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MethodReturnValueDisplayKey
    extends Pair<Method, Value>
    implements DisplayKey<MethodReturnValueDescriptorImpl> {
        MethodReturnValueDisplayKey(@NotNull Method method, @Nullable Value value2) {
            if (method == null) {
                MethodReturnValueDisplayKey.$$$reportNull$$$0(0);
            }
            super((Object)method, (Object)value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/debugger/impl/descriptors/data/MethodReturnValueData$MethodReturnValueDisplayKey", "<init>"));
        }
    }
}

