/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentCapabilities;
import com.intellij.debugger.memory.agent.MemoryAgentImpl;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.intellij.debugger.memory.agent.extractor.ProxyExtractor;
import com.intellij.debugger.memory.agent.parsers.BooleanParser;
import com.intellij.debugger.memory.agent.parsers.GcRootsPathsParser;
import com.intellij.debugger.memory.agent.parsers.LongArrayParser;
import com.intellij.debugger.memory.agent.parsers.LongValueParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MemoryAgentOperations {
    private static final Key<MemoryAgent> MEMORY_AGENT_KEY = Key.create((String)"MEMORY_AGENT_KEY");
    private static final Logger LOG = Logger.getInstance(MemoryAgentOperations.class);

    MemoryAgentOperations() {
    }

    static long estimateObjectSize(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference reference) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentOperations.$$$reportNull$$$0(0);
        }
        if (reference == null) {
            MemoryAgentOperations.$$$reportNull$$$0(1);
        }
        Value result = MemoryAgentOperations.callMethod(evaluationContext, "size", Collections.singletonList(reference));
        return LongValueParser.INSTANCE.parse(result);
    }

    static long @NotNull [] estimateObjectsSizes(@NotNull EvaluationContextImpl evaluationContext, @NotNull List<ObjectReference> references) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentOperations.$$$reportNull$$$0(2);
        }
        if (references == null) {
            MemoryAgentOperations.$$$reportNull$$$0(3);
        }
        ArrayReference array = MemoryAgentOperations.wrapWithArray(evaluationContext, references);
        Value result = MemoryAgentOperations.callMethod(evaluationContext, "estimateRetainedSize", Collections.singletonList(array));
        long[] lArray = LongArrayParser.INSTANCE.parse(result).stream().mapToLong(Long::longValue).toArray();
        if (lArray == null) {
            MemoryAgentOperations.$$$reportNull$$$0(4);
        }
        return lArray;
    }

    @NotNull
    static ReferringObjectsInfo findReferringObjects(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference reference, int limit) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentOperations.$$$reportNull$$$0(5);
        }
        if (reference == null) {
            MemoryAgentOperations.$$$reportNull$$$0(6);
        }
        IntegerValue limitValue = evaluationContext.getDebugProcess().getVirtualMachineProxy().mirrorOf(limit);
        Value value2 = MemoryAgentOperations.callMethod(evaluationContext, "gcRoots", Arrays.asList(reference, limitValue));
        ReferringObjectsInfo referringObjectsInfo = GcRootsPathsParser.INSTANCE.parse(value2);
        if (referringObjectsInfo == null) {
            MemoryAgentOperations.$$$reportNull$$$0(7);
        }
        return referringObjectsInfo;
    }

    @NotNull
    static MemoryAgent getAgent(@NotNull DebugProcessImpl debugProcess) {
        MemoryAgent agent;
        if (debugProcess == null) {
            MemoryAgentOperations.$$$reportNull$$$0(8);
        }
        MemoryAgent memoryAgent = (agent = (MemoryAgent)debugProcess.getUserData(MEMORY_AGENT_KEY)) == null ? MemoryAgentImpl.DISABLED : agent;
        if (memoryAgent == null) {
            MemoryAgentOperations.$$$reportNull$$$0(9);
        }
        return memoryAgent;
    }

    static void initializeAgent(@NotNull EvaluationContextImpl context) {
        if (context == null) {
            MemoryAgentOperations.$$$reportNull$$$0(10);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        MemoryAgent agent = MemoryAgentImpl.DISABLED;
        try {
            agent = new MemoryAgentImpl(MemoryAgentOperations.initializeCapabilities(context));
        }
        catch (EvaluateException e) {
            LOG.error("Could not initialize memory agent. ", (Throwable)e);
        }
        context.getDebugProcess().putUserData(MEMORY_AGENT_KEY, agent);
    }

    private static MemoryAgentCapabilities initializeCapabilities(@NotNull EvaluationContextImpl context) throws EvaluateException {
        ClassType proxyType;
        boolean isAgentLoaded;
        if (context == null) {
            MemoryAgentOperations.$$$reportNull$$$0(11);
        }
        if (!(isAgentLoaded = MemoryAgentOperations.checkAgentCapability(context, proxyType = MemoryAgentOperations.getProxyType(context), "isLoaded"))) {
            return MemoryAgentCapabilities.DISABLED;
        }
        MemoryAgentCapabilities.Builder builder = new MemoryAgentCapabilities.Builder();
        return builder.setCanEstimateObjectSize(MemoryAgentOperations.checkAgentCapability(context, proxyType, "canEstimateObjectSize")).setCanEstimateObjectsSizes(MemoryAgentOperations.checkAgentCapability(context, proxyType, "canEstimateObjectsSizes")).setCanFindGcRoots(MemoryAgentOperations.checkAgentCapability(context, proxyType, "canFindGcRoots")).buildLoaded();
    }

    @NotNull
    private static ClassType getProxyType(@NotNull EvaluationContextImpl evaluationContext) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentOperations.$$$reportNull$$$0(12);
        }
        boolean valueBefore = evaluationContext.isAutoLoadClasses();
        ClassType classType = MemoryAgentOperations.getOrLoadProxyType(evaluationContext);
        ClassType classType2 = classType;
        if (classType2 == null) {
            MemoryAgentOperations.$$$reportNull$$$0(13);
        }
        return classType2;
        finally {
            evaluationContext.setAutoLoadClasses(valueBefore);
        }
    }

    private static ClassType getOrLoadProxyType(@NotNull EvaluationContextImpl evaluationContext) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentOperations.$$$reportNull$$$0(14);
        }
        ClassObjectReference classObjectReference = (ClassObjectReference)evaluationContext.computeAndKeep(() -> {
            long start = System.currentTimeMillis();
            ReferenceType referenceType = MemoryAgentOperations.loadUtilityClass(evaluationContext);
            if (referenceType == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)"Could not load memory agent proxy class");
            }
            long duration = System.currentTimeMillis() - start;
            LOG.info("Loading of agent proxy class took " + duration + " ms");
            return referenceType.classObject();
        });
        return (ClassType)classObjectReference.reflectedType();
    }

    private static boolean checkAgentCapability(@NotNull EvaluationContextImpl evaluationContext, @NotNull ClassType proxyType, @NotNull String capabilityMethodName) {
        if (evaluationContext == null) {
            MemoryAgentOperations.$$$reportNull$$$0(15);
        }
        if (proxyType == null) {
            MemoryAgentOperations.$$$reportNull$$$0(16);
        }
        if (capabilityMethodName == null) {
            MemoryAgentOperations.$$$reportNull$$$0(17);
        }
        try {
            Value value2 = MemoryAgentOperations.callMethod(evaluationContext, proxyType, capabilityMethodName, Collections.emptyList());
            return BooleanParser.INSTANCE.parse(value2);
        }
        catch (EvaluateException e) {
            LOG.warn("Exception while capability checking: ", (Throwable)e);
            return false;
        }
    }

    private static Value callMethod(@NotNull EvaluationContextImpl evaluationContext, @NotNull String methodName, @NotNull List<? extends Value> args) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentOperations.$$$reportNull$$$0(18);
        }
        if (methodName == null) {
            MemoryAgentOperations.$$$reportNull$$$0(19);
        }
        if (args == null) {
            MemoryAgentOperations.$$$reportNull$$$0(20);
        }
        ClassType proxyType = MemoryAgentOperations.getProxyType(evaluationContext);
        return MemoryAgentOperations.callMethod(evaluationContext, proxyType, methodName, args);
    }

    @NotNull
    private static Value callMethod(@NotNull EvaluationContextImpl evaluationContext, @NotNull ClassType proxyType, @NotNull String methodName, @NotNull List<? extends Value> args) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentOperations.$$$reportNull$$$0(21);
        }
        if (proxyType == null) {
            MemoryAgentOperations.$$$reportNull$$$0(22);
        }
        if (methodName == null) {
            MemoryAgentOperations.$$$reportNull$$$0(23);
        }
        if (args == null) {
            MemoryAgentOperations.$$$reportNull$$$0(24);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        long start = System.currentTimeMillis();
        List<Method> methods = proxyType.methodsByName(methodName);
        if (methods.isEmpty()) {
            throw EvaluateExceptionUtil.createEvaluateException((String)("Could not find method with such name: " + methodName));
        }
        if (methods.size() > 1) {
            throw EvaluateExceptionUtil.createEvaluateException((String)("Too many methods \"" + methodName + "\" found. Count: " + methods.size()));
        }
        Method method = methods.get(0);
        if (!method.isStatic()) {
            throw EvaluateExceptionUtil.createEvaluateException((String)"Utility method should be static");
        }
        Object result = evaluationContext.computeAndKeep(() -> evaluationContext.getDebugProcess().invokeMethod(evaluationContext, proxyType, method, args, true));
        LOG.info("Memory agent's method \"" + methodName + "\" took " + (System.currentTimeMillis() - start) + " ms");
        Object t = result;
        if (t == null) {
            MemoryAgentOperations.$$$reportNull$$$0(25);
        }
        return t;
    }

    private static byte @NotNull [] readUtilityClass() {
        byte[] byArray = new ProxyExtractor().extractProxy();
        if (byArray == null) {
            MemoryAgentOperations.$$$reportNull$$$0(26);
        }
        return byArray;
    }

    @Nullable
    private static ReferenceType loadUtilityClass(@NotNull EvaluationContextImpl context) throws EvaluateException {
        if (context == null) {
            MemoryAgentOperations.$$$reportNull$$$0(27);
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        byte[] bytes = MemoryAgentOperations.readUtilityClass();
        context.setAutoLoadClasses(true);
        ClassLoaderReference classLoader = ClassLoadingUtils.getClassLoader(context, debugProcess);
        ClassLoadingUtils.defineClass("com.intellij.memory.agent.proxy.IdeaNativeAgentProxy", bytes, context, debugProcess, classLoader);
        try {
            return debugProcess.loadClass(context, "com.intellij.memory.agent.proxy.IdeaNativeAgentProxy", classLoader);
        }
        catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException e) {
            throw EvaluateExceptionUtil.createEvaluateException((String)"Could not load proxy class", (Throwable)e);
        }
    }

    @NotNull
    private static ArrayReference wrapWithArray(@NotNull EvaluationContextImpl context, @NotNull List<ObjectReference> references) throws EvaluateException {
        if (context == null) {
            MemoryAgentOperations.$$$reportNull$$$0(28);
        }
        if (references == null) {
            MemoryAgentOperations.$$$reportNull$$$0(29);
        }
        long start = System.currentTimeMillis();
        ArrayType longArray = (ArrayType)context.getDebugProcess().findClass(context, "java.lang.Object[]", context.getClassLoader());
        ArrayReference instancesArray = longArray.newInstance(references.size());
        try {
            instancesArray.setValues(references);
        }
        catch (ClassNotLoadedException | InvalidTypeException e) {
            throw EvaluateExceptionUtil.createEvaluateException((String)"Could not wrap objects with array", (Throwable)e);
        }
        LOG.info("Wrapping values with array took " + (System.currentTimeMillis() - start) + " ms");
        ArrayReference arrayReference = instancesArray;
        if (arrayReference == null) {
            MemoryAgentOperations.$$$reportNull$$$0(30);
        }
        return arrayReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 25: 
            case 26: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 25: 
            case 26: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 25: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/agent/MemoryAgentOperations";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 10: 
            case 11: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capabilityMethodName";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/agent/MemoryAgentOperations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "estimateObjectsSizes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferringObjects";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyType";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "callMethod";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "readUtilityClass";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "estimateObjectSize";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "estimateObjectsSizes";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 25: 
            case 26: 
            case 30: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findReferringObjects";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAgent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initializeAgent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initializeCapabilities";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProxyType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOrLoadProxyType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkAgentCapability";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "callMethod";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "loadUtilityClass";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 25: 
            case 26: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

