/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class JavaHotSwapConfigurableUi
implements ConfigurableUi<DebuggerSettings> {
    private JCheckBox myHotswapInBackground;
    private JCheckBox myCbCompileBeforeHotswap;
    private JCheckBox myCbHangWarningEnabled;
    private JRadioButton myRbAlways;
    private JRadioButton myRbNever;
    private JRadioButton myRbAsk;

    JavaHotSwapConfigurableUi() {
    }

    public void reset(@NotNull DebuggerSettings settings) {
        if (settings == null) {
            JavaHotSwapConfigurableUi.$$$reportNull$$$0(0);
        }
        this.myHotswapInBackground.setSelected(settings.HOTSWAP_IN_BACKGROUND);
        this.myCbCompileBeforeHotswap.setSelected(settings.COMPILE_BEFORE_HOTSWAP);
        this.myCbHangWarningEnabled.setSelected(settings.HOTSWAP_HANG_WARNING_ENABLED);
        if ("RunHotswapAlways".equals(settings.RUN_HOTSWAP_AFTER_COMPILE)) {
            this.myRbAlways.setSelected(true);
        } else if ("RunHotswapNever".equals(settings.RUN_HOTSWAP_AFTER_COMPILE)) {
            this.myRbNever.setSelected(true);
        } else {
            this.myRbAsk.setSelected(true);
        }
    }

    public void apply(@NotNull DebuggerSettings settings) {
        if (settings == null) {
            JavaHotSwapConfigurableUi.$$$reportNull$$$0(1);
        }
        this.getSettingsTo(settings);
    }

    private void getSettingsTo(DebuggerSettings settings) {
        settings.HOTSWAP_IN_BACKGROUND = this.myHotswapInBackground.isSelected();
        settings.COMPILE_BEFORE_HOTSWAP = this.myCbCompileBeforeHotswap.isSelected();
        settings.HOTSWAP_HANG_WARNING_ENABLED = this.myCbHangWarningEnabled.isSelected();
        settings.RUN_HOTSWAP_AFTER_COMPILE = this.myRbAlways.isSelected() ? "RunHotswapAlways" : (this.myRbNever.isSelected() ? "RunHotswapNever" : "RunHotswapAsk");
    }

    public boolean isModified(@NotNull DebuggerSettings currentSettings) {
        if (currentSettings == null) {
            JavaHotSwapConfigurableUi.$$$reportNull$$$0(2);
        }
        DebuggerSettings debuggerSettings = currentSettings.clone();
        this.getSettingsTo(debuggerSettings);
        return !debuggerSettings.equals(currentSettings);
    }

    @NotNull
    public JComponent getComponent() {
        Insets insets;
        JPanel panel2 = new JPanel(new GridBagLayout());
        this.myCbCompileBeforeHotswap = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.hotswap.configurable.compile.before.hotswap", (Object[])new Object[0]));
        this.myCbHangWarningEnabled = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.hotswap.configurable.enable.vm.hang.warning", (Object[])new Object[0]));
        this.myHotswapInBackground = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.hotswap.configurable.hotswap.background", (Object[])new Object[0]));
        this.myRbAlways = new JRadioButton(JavaDebuggerBundle.message((String)"label.debugger.hotswap.configurable.always", (Object[])new Object[0]));
        this.myRbNever = new JRadioButton(JavaDebuggerBundle.message((String)"label.debugger.hotswap.configurable.never", (Object[])new Object[0]));
        this.myRbAsk = new JRadioButton(JavaDebuggerBundle.message((String)"label.debugger.hotswap.configurable.ask", (Object[])new Object[0]));
        panel2.add((Component)this.myCbCompileBeforeHotswap, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        panel2.add((Component)this.myCbHangWarningEnabled, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsTop((int)4), 0, 0));
        panel2.add((Component)this.myHotswapInBackground, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsTop((int)4), 0, 0));
        int cbLeftOffset = 0;
        Border border = this.myCbCompileBeforeHotswap.getBorder();
        if (border != null && (insets = border.getBorderInsets(this.myCbCompileBeforeHotswap)) != null) {
            cbLeftOffset = insets.left;
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbAlways);
        group.add(this.myRbNever);
        group.add(this.myRbAsk);
        Box box = Box.createHorizontalBox();
        box.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        box.add(this.myRbAlways);
        box.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        box.add(this.myRbNever);
        box.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        box.add(this.myRbAsk);
        JPanel reloadPanel = new JPanel(new BorderLayout());
        reloadPanel.add((Component)box, "Center");
        reloadPanel.add((Component)new JLabel(JavaDebuggerBundle.message((String)"label.debugger.hotswap.configurable.reload.classes", (Object[])new Object[0])), "West");
        panel2.add((Component)reloadPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, (Insets)JBUI.insets((int)4, (int)cbLeftOffset, (int)0, (int)0), 0, 0));
        JPanel jPanel = panel2;
        if (jPanel == null) {
            JavaHotSwapConfigurableUi.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/settings/JavaHotSwapConfigurableUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/settings/JavaHotSwapConfigurableUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

