/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

public abstract class EditorEvaluationCommand<T>
extends DebuggerContextCommandImpl {
    protected final PsiElement myElement;
    @Nullable
    private final Editor myEditor;
    protected final ProgressIndicator myProgressIndicator;

    public EditorEvaluationCommand(@Nullable Editor editor, PsiElement expression2, DebuggerContextImpl context, ProgressIndicator indicator) {
        super(context);
        this.myProgressIndicator = indicator;
        this.myEditor = editor;
        this.myElement = expression2;
    }

    @Override
    public PrioritizedTask.Priority getPriority() {
        return PrioritizedTask.Priority.HIGH;
    }

    protected abstract T evaluate(EvaluationContextImpl var1) throws EvaluateException;

    public T evaluate() throws EvaluateException {
        Object[] objectArray = new Object[1];
        objectArray[0] = ReadAction.compute(() -> ((PsiElement)this.myElement).getText());
        this.myProgressIndicator.setText(JavaDebuggerBundle.message((String)"progress.evaluating", (Object[])objectArray));
        try {
            T result = this.evaluate(this.getDebuggerContext().createEvaluationContext());
            ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled((ProgressIndicator)this.myProgressIndicator);
            return result;
        }
        catch (EvaluateException e) {
            if (this.myEditor != null) {
                DebuggerInvocationUtil.invokeLater(this.myElement.getProject(), () -> EditorEvaluationCommand.showEvaluationHint(this.myEditor, this.myElement, e), this.myProgressIndicator.getModalityState());
            }
            throw e;
        }
    }

    public static void showEvaluationHint(Editor myEditor, PsiElement myElement, EvaluateException e) {
        if (myEditor.isDisposed() || !myEditor.getComponent().isVisible()) {
            return;
        }
        HintManager.getInstance().showErrorHint(myEditor, e.getMessage(), myElement.getTextRange().getStartOffset(), myElement.getTextRange().getEndOffset(), (short)2, 9, 1500);
    }
}

