/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.settings.TraceSettings;
import com.intellij.debugger.ui.breakpoints.EditClassFiltersDialog;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;

public class CallTracingPropertiesPanel
extends XBreakpointCustomPropertiesPanel<XLineBreakpoint<JavaLineBreakpointProperties>> {
    private final Project myProject;
    private JBCheckBox myStartTracing;
    private JBCheckBox myEndTracing;

    public CallTracingPropertiesPanel(Project project) {
        this.myProject = project;
    }

    @NotNull
    public JComponent getComponent() {
        this.myStartTracing = new JBCheckBox(JavaDebuggerBundle.message((String)"checkbox.start.tracing", (Object[])new Object[0]));
        this.myEndTracing = new JBCheckBox(JavaDebuggerBundle.message((String)"checkbox.stop.tracing", (Object[])new Object[0]));
        JButton filters = new JButton(JavaDebuggerBundle.message((String)"checkbox.tracking.filters", (Object[])new Object[0]));
        JPanel _panel = new JPanel(new FlowLayout(0, 6, 0));
        _panel.add((Component)this.myStartTracing);
        _panel.add((Component)this.myEndTracing);
        _panel.add(filters);
        _panel.setBorder(IdeBorderFactory.createTitledBorder((String)JavaDebuggerBundle.message((String)"checkbox.tracing", (Object[])new Object[0])));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBCheckBox toUncheck = null;
                if (CallTracingPropertiesPanel.this.myStartTracing.isSelected() && CallTracingPropertiesPanel.this.myEndTracing.isSelected()) {
                    Object source = e.getSource();
                    if (CallTracingPropertiesPanel.this.myStartTracing.equals(source)) {
                        toUncheck = CallTracingPropertiesPanel.this.myEndTracing;
                    } else if (CallTracingPropertiesPanel.this.myEndTracing.equals(source)) {
                        toUncheck = CallTracingPropertiesPanel.this.myStartTracing;
                    }
                    if (toUncheck != null) {
                        toUncheck.setSelected(false);
                    }
                }
            }
        };
        this.myStartTracing.addActionListener(listener);
        this.myEndTracing.addActionListener(listener);
        filters.addActionListener(e -> {
            EditClassFiltersDialog dialog = new EditClassFiltersDialog(this.myProject);
            TraceSettings traceSettings = TraceSettings.getInstance();
            dialog.setFilters(traceSettings.getClassFilters(), traceSettings.getClassExclusionFilters());
            dialog.setTitle(JavaDebuggerBundle.message((String)"tracing.class.filters", (Object[])new Object[0]));
            dialog.show();
            if (dialog.getExitCode() == 0) {
                traceSettings.setClassFilters(dialog.getFilters());
                traceSettings.setClassExclusionFilters(dialog.getExclusionFilters());
            }
        });
        JPanel jPanel = _panel;
        if (jPanel == null) {
            CallTracingPropertiesPanel.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public void loadFrom(@NotNull XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            CallTracingPropertiesPanel.$$$reportNull$$$0(1);
        }
        this.myStartTracing.setSelected(((JavaLineBreakpointProperties)breakpoint.getProperties()).isTRACING_START());
        this.myEndTracing.setSelected(((JavaLineBreakpointProperties)breakpoint.getProperties()).isTRACING_END());
    }

    public void saveTo(@NotNull XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            CallTracingPropertiesPanel.$$$reportNull$$$0(2);
        }
        boolean changed = ((JavaLineBreakpointProperties)breakpoint.getProperties()).setTRACING_START(this.myStartTracing.isSelected());
        boolean bl = changed = ((JavaLineBreakpointProperties)breakpoint.getProperties()).setTRACING_END(this.myEndTracing.isSelected()) || changed;
        if (changed) {
            ((XBreakpointBase)breakpoint).fireBreakpointChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/CallTracingPropertiesPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/CallTracingPropertiesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

