/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

public abstract class UnboxableTypeRenderer
extends CompoundReferenceRenderer {
    public UnboxableTypeRenderer(String className2) {
        super(StringUtil.getShortName((String)className2), new LabelRenderer(){

            @Override
            public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) throws EvaluateException {
                return DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)UnBoxingEvaluator.getInnerPrimitiveValue((ObjectReference)descriptor.getValue()));
            }

            @Override
            public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
                return false;
            }
        }, null);
        LOG.assertTrue(UnBoxingEvaluator.isTypeUnboxable(className2));
        this.setClassName(className2);
        this.setEnabled(true);
    }

    @Override
    public boolean isApplicable(Type type2) {
        return type2 instanceof ReferenceType && StringUtil.equals((CharSequence)type2.name(), (CharSequence)this.getClassName());
    }

    public static class DoubleRenderer
    extends UnboxableTypeRenderer {
        public DoubleRenderer() {
            super("java.lang.Double");
        }
    }

    public static class FloatRenderer
    extends UnboxableTypeRenderer {
        public FloatRenderer() {
            super("java.lang.Float");
        }
    }

    public static class LongRenderer
    extends UnboxableTypeRenderer {
        public LongRenderer() {
            super("java.lang.Long");
        }
    }

    public static class IntegerRenderer
    extends UnboxableTypeRenderer {
        public IntegerRenderer() {
            super("java.lang.Integer");
        }
    }

    public static class ShortRenderer
    extends UnboxableTypeRenderer {
        public ShortRenderer() {
            super("java.lang.Short");
        }
    }

    public static class CharacterRenderer
    extends UnboxableTypeRenderer {
        public CharacterRenderer() {
            super("java.lang.Character");
        }
    }

    public static class ByteRenderer
    extends UnboxableTypeRenderer {
        public ByteRenderer() {
            super("java.lang.Byte");
        }
    }

    public static class BooleanRenderer
    extends UnboxableTypeRenderer {
        public BooleanRenderer() {
            super("java.lang.Boolean");
        }
    }
}

