/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.palette;

import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteItemsComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.Gray;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.KeyStroke;

public class PaletteGroupComponent
extends JCheckBox {
    private PaletteItemsComponent myItemsComponent;

    public PaletteGroupComponent(PaletteGroup group) {
        this.setText(group.getName());
        this.setSelected(true);
        this.setIcon(AllIcons.Nodes.Folder);
        this.setSelectedIcon(AllIcons.Nodes.Folder);
        this.setFont(this.getFont().deriveFont(1));
        this.setFocusPainted(false);
        this.setMargin(new Insets(0, 3, 0, 3));
        this.setOpaque(true);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteGroupComponent.this.myItemsComponent.setVisible(PaletteGroupComponent.this.isSelected());
            }
        });
        this.initActions();
    }

    @Override
    public Color getBackground() {
        if (this.isFocusOwner()) {
            return UIUtil.getListSelectionBackground((boolean)true);
        }
        if (StartupUiUtil.isUnderDarcula()) {
            return Gray._100;
        }
        return super.getBackground();
    }

    @Override
    public Color getForeground() {
        if (this.isFocusOwner()) {
            return UIUtil.getListSelectionForeground();
        }
        return super.getForeground();
    }

    public PaletteItemsComponent getItemsComponent() {
        return this.myItemsComponent;
    }

    public void setItemsComponent(PaletteItemsComponent itemsComponent) {
        this.myItemsComponent = itemsComponent;
    }

    private void initActions() {
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "moveFocusDown");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "moveFocusUp");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "collapse");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "expand");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("moveFocusDown", new MoveFocusAction(true));
        actionMap.put("moveFocusUp", new MoveFocusAction(false));
        actionMap.put("collapse", new ExpandAction(false));
        actionMap.put("expand", new ExpandAction(true));
    }

    private class ExpandAction
    extends AbstractAction {
        private final boolean myExpand;

        ExpandAction(boolean expand) {
            this.myExpand = expand;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myExpand != PaletteGroupComponent.this.isSelected()) {
                PaletteGroupComponent.this.setSelected(this.myExpand);
                if (PaletteGroupComponent.this.myItemsComponent != null) {
                    PaletteGroupComponent.this.myItemsComponent.setVisible(PaletteGroupComponent.this.isSelected());
                }
            }
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private final boolean myMoveDown;

        MoveFocusAction(boolean moveDown) {
            this.myMoveDown = moveDown;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Container container = kfm.getCurrentFocusCycleRoot();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
                Component next;
                FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
                if (policy == null) {
                    policy = kfm.getDefaultFocusTraversalPolicy();
                }
                Component component = next = this.myMoveDown ? policy.getComponentAfter(container, PaletteGroupComponent.this) : policy.getComponentBefore(container, PaletteGroupComponent.this);
                if (next instanceof PaletteItemsComponent) {
                    PaletteItemsComponent list = (PaletteItemsComponent)((Object)((Object)next));
                    if (list.getModel().getSize() != 0) {
                        list.takeFocusFrom(list == PaletteGroupComponent.this.myItemsComponent ? 0 : -1);
                        return;
                    }
                    Component component2 = next = this.myMoveDown ? policy.getComponentAfter(container, next) : policy.getComponentBefore(container, next);
                }
                if (next instanceof PaletteGroupComponent) {
                    IdeFocusManager.getGlobalInstance().requestFocus(next, true);
                }
            });
        }
    }
}

