/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.TestDiscoveryExtension;
import com.intellij.execution.testDiscovery.indices.DiscoveredTestDataHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Couple;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class TestDiscoveryIndex
implements Disposable {
    static final Logger LOG = Logger.getInstance(TestDiscoveryIndex.class);
    private volatile DiscoveredTestDataHolder myHolder;
    private final Object myLock;
    private final Path basePath;

    public static TestDiscoveryIndex getInstance(@NotNull Project project) {
        if (project == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(0);
        }
        return (TestDiscoveryIndex)project.getService(TestDiscoveryIndex.class);
    }

    TestDiscoveryIndex(@NotNull Project project) {
        if (project == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(1);
        }
        this(TestDiscoveryExtension.baseTestDiscoveryPathForProject(project));
    }

    @NonInjectable
    public TestDiscoveryIndex(@NotNull Path basePath) {
        if (basePath == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(2);
        }
        this.myLock = new Object();
        this.basePath = basePath;
    }

    public boolean hasTestTrace(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) {
        Boolean result;
        if (testClassName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(3);
        }
        if (testMethodName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(4);
        }
        return (result = (Boolean)this.executeUnderLock(holder -> holder.hasTestTrace(testClassName, testMethodName, frameworkId))) == Boolean.TRUE;
    }

    public void removeTestTrace(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) {
        if (testClassName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(5);
        }
        if (testMethodName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(6);
        }
        this.executeUnderLock(holder -> {
            holder.removeTestTrace(testClassName, testMethodName, frameworkId);
            return null;
        });
    }

    @NotNull
    public MultiMap<String, String> getTestsByFile(String relativePath, byte frameworkId) {
        MultiMap map2 = (MultiMap)this.executeUnderLock(holder -> holder.getTestsByFile(relativePath, frameworkId));
        MultiMap multiMap = map2 == null ? MultiMap.empty() : map2;
        if (multiMap == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(7);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, String> getTestsByClassName(@NotNull String classFQName, byte frameworkId) {
        MultiMap map2;
        if (classFQName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(8);
        }
        MultiMap multiMap = (map2 = (MultiMap)this.executeUnderLock(holder -> holder.getTestsByClassName(classFQName, frameworkId))) == null ? MultiMap.empty() : map2;
        if (multiMap == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(9);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, String> getTestsByMethodName(@NotNull String classFQName, @NotNull String methodName, byte frameworkId) {
        MultiMap map2;
        if (classFQName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(10);
        }
        if (methodName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(11);
        }
        MultiMap multiMap = (map2 = (MultiMap)this.executeUnderLock(holder -> holder.getTestsByMethodName(classFQName, methodName, frameworkId))) == null ? MultiMap.empty() : map2;
        if (multiMap == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(12);
        }
        return multiMap;
    }

    @NotNull
    public Collection<String> getTestModulesByMethodName(@NotNull String classFQName, @NotNull String methodName, byte frameworkId) {
        Collection modules;
        if (classFQName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(13);
        }
        if (methodName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(14);
        }
        Collection<Object> collection = (modules = (Collection)this.executeUnderLock(holder -> holder.getTestModulesByMethodName(classFQName, methodName, frameworkId))) == null ? Collections.emptySet() : modules;
        if (collection == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getAffectedFiles(Couple<String> testQName, byte frameworkId) {
        Collection files = (Collection)this.executeUnderLock(holder -> holder.getAffectedFiles(testQName, frameworkId));
        Collection<Object> collection = files == null ? Collections.emptySet() : files;
        if (collection == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(16);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            DiscoveredTestDataHolder holder = this.myHolder;
            if (holder != null) {
                holder.dispose();
                this.myHolder = null;
            }
        }
    }

    public void updateTestData(@NotNull String testClassName, @NotNull String testMethodName, @NotNull MultiMap<String, String> usedMethods, @NotNull List<String> usedFiles, @Nullable String moduleName, byte frameworkId) {
        if (testClassName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(17);
        }
        if (testMethodName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(18);
        }
        if (usedMethods == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(19);
        }
        if (usedFiles == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(20);
        }
        this.executeUnderLock(holder -> {
            holder.updateTestData(testClassName, testMethodName, usedMethods, usedFiles, moduleName, frameworkId);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiscoveredTestDataHolder getHolder() {
        DiscoveredTestDataHolder holder = this.myHolder;
        if (holder == null) {
            Object object = this.myLock;
            synchronized (object) {
                holder = this.myHolder;
                if (holder == null && this.basePath != null) {
                    this.myHolder = holder = new DiscoveredTestDataHolder(this.basePath);
                }
            }
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R executeUnderLock(ThrowableConvertor<DiscoveredTestDataHolder, R, IOException> action) {
        Object object = this.myLock;
        synchronized (object) {
            DiscoveredTestDataHolder holder = this.getHolder();
            if (holder == null || holder.isDisposed()) {
                return null;
            }
            try {
                return (R)action.convert((Object)holder);
            }
            catch (Throwable throwable) {
                LOG.error("Unexpected problem", throwable);
                holder.dispose();
                PathKt.delete((Path)this.basePath);
                this.myHolder = null;
                return null;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 3: 
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClassName";
                break;
            }
            case 4: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethodName";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/TestDiscoveryIndex";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFQName";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedMethods";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/TestDiscoveryIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsByFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsByClassName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsByMethodName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestModulesByMethodName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasTestTrace";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeTestTrace";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTestsByClassName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTestsByMethodName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTestModulesByMethodName";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateTestData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class MyPostStartUpActivity
    implements StartupActivity.DumbAware {
        MyPostStartUpActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyPostStartUpActivity.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            NonUrgentExecutor.getInstance().execute(() -> {
                TestDiscoveryIndex service = TestDiscoveryIndex.getInstance(project);
                if (!Files.exists(service.basePath, new LinkOption[0])) {
                    return;
                }
                service.getHolder();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testDiscovery/TestDiscoveryIndex$MyPostStartUpActivity", "runActivity"));
        }
    }
}

