/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.LocalTestDiscoveryProducer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TestDiscoveryProducer {
    public static final ExtensionPointName<TestDiscoveryProducer> EP = ExtensionPointName.create((String)"com.intellij.testDiscoveryProducer");
    public static final Logger LOG = Logger.getInstance(LocalTestDiscoveryProducer.class);

    @NotNull
    public MultiMap<String, String> getDiscoveredTests(@NotNull Project var1, @NotNull List<? extends Couple<String>> var2, byte var3);

    @NotNull
    public MultiMap<String, String> getDiscoveredTestsForFiles(@NotNull Project var1, @NotNull List<String> var2, byte var3);

    public boolean isRemote();

    public static void consumeDiscoveredTests(@NotNull Project project, @NotNull List<Couple<String>> classesAndMethods, byte frameworkId, @NotNull List<String> filePaths, @NotNull TestProcessor processor) {
        if (project == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(0);
        }
        if (classesAndMethods == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(1);
        }
        if (filePaths == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(3);
        }
        MultiMap<String, String> visitedTests = new MultiMap<String, String>(){

            @NotNull
            protected Collection<String> createCollection() {
                return new THashSet();
            }
        };
        for (TestDiscoveryProducer producer : EP.getExtensionList()) {
            for (Map.Entry entry : ContainerUtil.concat((Iterable)producer.getDiscoveredTests(project, classesAndMethods, frameworkId).entrySet(), (Iterable)producer.getDiscoveredTestsForFiles(project, filePaths, frameworkId).entrySet())) {
                String className2 = (String)entry.getKey();
                for (String methodRawName : (Collection)entry.getValue()) {
                    if (visitedTests.get((Object)className2).contains(methodRawName)) continue;
                    visitedTests.putValue((Object)className2, (Object)methodRawName);
                    Couple<String> couple = TestDiscoveryProducer.extractParameter(methodRawName);
                    if (processor.process(className2, (String)couple.first, (String)couple.second)) continue;
                    return;
                }
            }
        }
    }

    @NotNull
    public List<String> getAffectedFilePaths(@NotNull Project var1, @NotNull List<? extends Couple<String>> var2, byte var3);

    @NotNull
    public List<String> getAffectedFilePathsByClassName(@NotNull Project var1, @NotNull String var2, byte var3);

    @NotNull
    public List<String> getFilesWithoutTests(@NotNull Project var1, @NotNull Collection<String> var2) throws IOException;

    public static void consumeAffectedPaths(@NotNull Project project, @NotNull List<? extends Couple<String>> testFqns, @NotNull Consumer<? super String> pathsConsumer, byte frameworkId) {
        if (project == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(4);
        }
        if (testFqns == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(5);
        }
        if (pathsConsumer == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(6);
        }
        for (TestDiscoveryProducer extension : EP.getExtensionList()) {
            for (String path : extension.getAffectedFilePaths(project, testFqns, frameworkId)) {
                pathsConsumer.consume((Object)path);
            }
        }
    }

    public static void consumeAffectedPaths(@NotNull Project project, @NotNull String testClassName, @NotNull Consumer<? super String> pathsConsumer, byte frameworkId) {
        if (project == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(7);
        }
        if (testClassName == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(8);
        }
        if (pathsConsumer == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(9);
        }
        for (TestDiscoveryProducer extension : EP.getExtensionList()) {
            for (String path : extension.getAffectedFilePathsByClassName(project, testClassName, frameworkId)) {
                pathsConsumer.consume((Object)path);
            }
        }
    }

    @NotNull
    public static Couple<String> extractParameter(@NotNull String rawName) {
        int idx;
        if (rawName == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(10);
        }
        Couple couple = (idx = rawName.indexOf(91)) == -1 ? Couple.of((Object)rawName, null) : Couple.of((Object)rawName.substring(0, idx), (Object)rawName.substring(idx));
        if (couple == null) {
            TestDiscoveryProducer.$$$reportNull$$$0(11);
        }
        return couple;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesAndMethods";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFqns";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsConsumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClassName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/TestDiscoveryProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/TestDiscoveryProducer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "extractParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "consumeDiscoveredTests";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "consumeAffectedPaths";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractParameter";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface PsiTestProcessor {
        public boolean process(@NotNull PsiClass var1, @Nullable PsiMethod var2, @Nullable String var3);
    }

    @FunctionalInterface
    public static interface TestProcessor {
        public boolean process(@NotNull String var1, @NotNull String var2, @Nullable String var3);
    }
}

