/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalSystem;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.externalSystem.JavaModuleData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.pom.java.LanguageLevel;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J6\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/externalSystem/JavaModuleDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/externalSystem/JavaModuleData;", "Lcom/intellij/openapi/project/Project;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "importData", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "importLanguageLevel", "module", "Lcom/intellij/openapi/module/Module;", "javaModuleData", "importTargetBytecodeVersion", "intellij.java.impl"})
public final class JavaModuleDataService
extends AbstractProjectDataService<JavaModuleData, Project> {
    @NotNull
    public Key<JavaModuleData> getTargetDataKey() {
        return JavaModuleData.KEY;
    }

    public void importData(@NotNull Collection<? extends DataNode<JavaModuleData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkParameterIsNotNull(toImport, (String)"toImport");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        if (projectData == null) {
            return;
        }
        for (DataNode<JavaModuleData> dataNode : toImport) {
            Module module;
            DataNode moduleNode;
            if (dataNode.getParent(ModuleData.class) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleNode, (String)"javaModuleNode.getParent\u2026::class.java) ?: continue");
            if ((Module)moduleNode.getUserData(AbstractModuleDataService.MODULE_KEY) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"moduleNode.getUserData(A\u2026e.MODULE_KEY) ?: continue");
            Object object = dataNode.getData();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"javaModuleNode.data");
            JavaModuleData javaModuleData = (JavaModuleData)((Object)object);
            this.importLanguageLevel(module, javaModuleData, modelsProvider);
            this.importTargetBytecodeVersion(module, javaModuleData);
        }
    }

    private final void importLanguageLevel(Module module, JavaModuleData javaModuleData, IdeModifiableModelsProvider modelsProvider) {
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        Intrinsics.checkExpressionValueIsNotNull((Object)modifiableRootModel, (String)"modelsProvider.getModifiableRootModel(module)");
        ModifiableRootModel modifiableRootModel2 = modifiableRootModel;
        LanguageLevelProjectExtension languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance((Project)module.getProject());
        LanguageLevelModuleExtension languageLevelModuleExtension = (LanguageLevelModuleExtension)modifiableRootModel2.getModuleExtension(LanguageLevelModuleExtension.class);
        LanguageLevel languageLevel = javaModuleData.getLanguageLevel();
        LanguageLevelProjectExtension languageLevelProjectExtension2 = languageLevelProjectExtension;
        Intrinsics.checkExpressionValueIsNotNull((Object)languageLevelProjectExtension2, (String)"languageLevelProjectExtension");
        LanguageLevel languageLevel2 = languageLevelProjectExtension2.getLanguageLevel();
        Intrinsics.checkExpressionValueIsNotNull((Object)languageLevel2, (String)"languageLevelProjectExtension.languageLevel");
        LanguageLevel projectLanguageLevel = languageLevel2;
        LanguageLevelModuleExtension languageLevelModuleExtension2 = languageLevelModuleExtension;
        Intrinsics.checkExpressionValueIsNotNull((Object)languageLevelModuleExtension2, (String)"languageLevelModuleExtension");
        LanguageLevel languageLevel3 = languageLevel;
        languageLevelModuleExtension2.setLanguageLevel(languageLevel3 == projectLanguageLevel ? null : languageLevel);
    }

    private final void importTargetBytecodeVersion(Module module, JavaModuleData javaModuleData) {
        String targetBytecodeVersion;
        CompilerConfiguration compilerConfiguration;
        CompilerConfiguration compilerConfiguration2 = compilerConfiguration = CompilerConfiguration.getInstance((Project)module.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerConfiguration2, (String)"compilerConfiguration");
        String projectTargetBytecodeVersion = compilerConfiguration2.getProjectBytecodeTarget();
        String string = targetBytecodeVersion = javaModuleData.getTargetBytecodeVersion();
        compilerConfiguration.setBytecodeTargetLevel(module, Intrinsics.areEqual((Object)string, (Object)projectTargetBytecodeVersion) ? null : targetBytecodeVersion);
    }
}

