/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.core.JavaPsiBundle;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaCreateFromTemplateHandler;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CreateClassAction
extends JavaCreateTemplateInPackageAction<PsiClass>
implements DumbAware {
    public CreateClassAction() {
        super("", JavaBundle.message((String)"action.create.new.class.description", (Object[])new Object[0]), PlatformIcons.CLASS_ICON, true);
    }

    protected void buildDialog(final Project project, PsiDirectory directory, CreateFileFromTemplateDialog.Builder builder) {
        LanguageLevel level;
        builder.setTitle(JavaBundle.message((String)"action.create.new.class", (Object[])new Object[0])).addKind(JavaPsiBundle.message((String)"node.class.tooltip", (Object[])new Object[0]), PlatformIcons.CLASS_ICON, "Class").addKind(JavaPsiBundle.message((String)"node.interface.tooltip", (Object[])new Object[0]), PlatformIcons.INTERFACE_ICON, "Interface");
        if (HighlightUtil.Feature.RECORDS.isAvailable((PsiElement)directory)) {
            builder.addKind(JavaPsiBundle.message((String)"node.record.tooltip", (Object[])new Object[0]), PlatformIcons.RECORD_ICON, "Record");
        }
        if ((level = PsiUtil.getLanguageLevel((PsiElement)directory)).isAtLeast(LanguageLevel.JDK_1_5)) {
            builder.addKind(JavaPsiBundle.message((String)"node.enum.tooltip", (Object[])new Object[0]), PlatformIcons.ENUM_ICON, "Enum");
            builder.addKind(JavaPsiBundle.message((String)"node.annotation.tooltip", (Object[])new Object[0]), PlatformIcons.ANNOTATION_TYPE_ICON, "AnnotationType");
        }
        FileTemplate[] fileTemplateArray = FileTemplateManager.getInstance((Project)project).getAllTemplates();
        int n = fileTemplateArray.length;
        for (int i = 0; i < n; ++i) {
            JavaCreateFromTemplateHandler handler = new JavaCreateFromTemplateHandler();
            FileTemplate template = fileTemplateArray[i];
            if (!handler.handlesTemplate(template) || !JavaCreateFromTemplateHandler.canCreate(directory)) continue;
            builder.addKind(template.getName(), JavaFileType.INSTANCE.getIcon(), template.getName());
        }
        builder.setValidator((InputValidator)new InputValidatorEx(){

            public String getErrorText(String inputString) {
                if (inputString.length() > 0 && !PsiNameHelper.getInstance((Project)project).isQualifiedName(inputString)) {
                    return "This is not a valid Java qualified name";
                }
                String shortName = StringUtil.getShortName((String)inputString);
                if (HighlightClassUtil.isRestrictedIdentifier(shortName, level)) {
                    return JavaErrorBundle.message("restricted.identifier", shortName);
                }
                return null;
            }

            public boolean checkInput(String inputString) {
                return true;
            }

            public boolean canClose(String inputString) {
                return !StringUtil.isEmptyOrSpaces((String)inputString) && this.getErrorText(inputString) == null;
            }
        });
    }

    protected String removeExtension(String templateName, String className2) {
        return StringUtil.trimEnd((String)className2, (String)".java");
    }

    @NotNull
    protected String getErrorTitle() {
        String string = JavaBundle.message((String)"title.cannot.create.class", (Object[])new Object[0]);
        if (string == null) {
            CreateClassAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected String getActionName(PsiDirectory directory, @NotNull String newName, String templateName) {
        if (newName == null) {
            CreateClassAction.$$$reportNull$$$0(1);
        }
        return JavaBundle.message((String)"progress.creating.class", (Object[])new Object[]{StringUtil.getQualifiedName((String)JavaDirectoryService.getInstance().getPackage(directory).getQualifiedName(), (String)newName)});
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected final PsiClass doCreate(PsiDirectory dir, String className2, String templateName) throws IncorrectOperationException {
        return JavaDirectoryService.getInstance().createClass(dir, className2, templateName, true);
    }

    protected PsiElement getNavigationElement(@NotNull PsiClass createdElement) {
        if (createdElement == null) {
            CreateClassAction.$$$reportNull$$$0(2);
        }
        return createdElement.getLBrace();
    }

    protected void postProcess(PsiClass createdElement, String templateName, Map<String, String> customProperties) {
        super.postProcess((PsiElement)createdElement, templateName, customProperties);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CreateClassAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorTitle";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CreateClassAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

