/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageElementNode;
import com.intellij.ide.projectView.impl.nodes.PackageViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.PackageViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PsiPackageFavoriteNodeProvider
extends FavoriteNodeProvider {
    public Collection<AbstractTreeNode<?>> getFavoriteNodes(DataContext context, @NotNull ViewSettings viewSettings) {
        block10: {
            String currentViewId;
            ArrayList result;
            Project project;
            block9: {
                PsiElement element;
                if (viewSettings == null) {
                    PsiPackageFavoriteNodeProvider.$$$reportNull$$$0(0);
                }
                if ((project = (Project)CommonDataKeys.PROJECT.getData(context)) == null) {
                    return null;
                }
                PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context);
                if (elements == null && (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context)) != null) {
                    elements = new PsiElement[]{element};
                }
                result = new ArrayList();
                if (elements != null) {
                    for (PsiElement element2 : elements) {
                        PsiPackage psiPackage;
                        PsiDirectory[] directories;
                        if (!(element2 instanceof PsiPackage) || (directories = (psiPackage = (PsiPackage)element2).getDirectories()).length <= 0) continue;
                        VirtualFile firstDir = directories[0].getVirtualFile();
                        boolean isLibraryRoot = ProjectRootsUtil.isLibraryRoot((VirtualFile)firstDir, (Project)project);
                        PackageElement packageElement = new PackageElement((Module)LangDataKeys.MODULE.getData(context), psiPackage, isLibraryRoot);
                        result.add((AbstractTreeNode<?>)new PackageElementNode(project, packageElement, viewSettings));
                    }
                    return result.isEmpty() ? null : result;
                }
                currentViewId = ProjectView.getInstance((Project)project).getCurrentViewId();
                Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(context);
                if (modules == null) break block9;
                for (Module module : modules) {
                    if ("PackagesPane".equals(currentViewId)) {
                        result.add((AbstractTreeNode<?>)new PackageViewModuleNode(project, module, viewSettings));
                        continue;
                    }
                    result.add((AbstractTreeNode<?>)new ProjectViewModuleNode(project, module, viewSettings));
                }
                break block10;
            }
            ModuleGroup[] data = (ModuleGroup[])ModuleGroup.ARRAY_DATA_KEY.getData(context);
            if (data == null) break block10;
            for (ModuleGroup moduleGroup : data) {
                if ("PackagesPane".equals(currentViewId)) {
                    result.add((AbstractTreeNode<?>)new PackageViewModuleGroupNode(project, moduleGroup, viewSettings));
                    continue;
                }
                result.add((AbstractTreeNode<?>)new ProjectViewModuleGroupNode(project, moduleGroup, viewSettings));
            }
        }
        return null;
    }

    public AbstractTreeNode createNode(Project project, Object element, @NotNull ViewSettings viewSettings) {
        if (viewSettings == null) {
            PsiPackageFavoriteNodeProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PackageElement) {
            return new PackageElementNode(project, (PackageElement)element, viewSettings);
        }
        return super.createNode(project, element, viewSettings);
    }

    public boolean elementContainsFile(Object element, VirtualFile vFile) {
        if (element instanceof PackageElement) {
            PsiDirectory[] directories;
            HashSet find = new HashSet();
            ContentIterator contentIterator = fileOrDir -> {
                if (fileOrDir.getPath().equals(vFile.getPath())) {
                    find.add(Boolean.TRUE);
                }
                return true;
            };
            PackageElement packageElement = (PackageElement)element;
            PsiPackage aPackage = packageElement.getPackage();
            Project project = aPackage.getProject();
            GlobalSearchScope scope = packageElement.getModule() != null ? GlobalSearchScope.moduleScope((Module)packageElement.getModule()) : GlobalSearchScope.projectScope((Project)project);
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            for (PsiDirectory directory : directories = aPackage.getDirectories(scope)) {
                projectFileIndex.iterateContentUnderDirectory(directory.getVirtualFile(), contentIterator);
            }
            return !find.isEmpty();
        }
        return false;
    }

    public int getElementWeight(Object element, boolean isSortByType) {
        if (element instanceof PackageElement) {
            return 2;
        }
        return -1;
    }

    public String getElementLocation(Object element) {
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            Module module = packageElement.getModule();
            return (module != null ? module.getName() + ":" : "") + packageElement.getPackage().getQualifiedName();
        }
        return null;
    }

    public boolean isInvalidElement(Object element) {
        return element instanceof PackageElement && !((PackageElement)element).getPackage().isValid();
    }

    @NotNull
    public String getFavoriteTypeId() {
        return "package";
    }

    public String getElementUrl(Object element) {
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            PsiPackage aPackage = packageElement.getPackage();
            return aPackage.getQualifiedName();
        }
        return null;
    }

    public String getElementModuleName(Object element) {
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            Module module = packageElement.getModule();
            return module == null ? null : module.getName();
        }
        return null;
    }

    public Object[] createPathFromUrl(Project project, String url, String moduleName) {
        Module module = moduleName != null ? ModuleManager.getInstance((Project)project).findModuleByName(moduleName) : null;
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(url);
        if (aPackage == null) {
            return null;
        }
        PackageElement packageElement = new PackageElement(module, aPackage, false);
        return new Object[]{packageElement};
    }

    public PsiElement getPsiElement(Object element) {
        if (element instanceof PackageElement) {
            return ((PackageElement)element).getPackage();
        }
        return super.getPsiElement(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "viewSettings";
        objectArray2[1] = "com/intellij/ide/favoritesTreeView/PsiPackageFavoriteNodeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFavoriteNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

