/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.call;

import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CalleeMethodsTreeStructure;
import com.intellij.ide.hierarchy.call.CallerMethodsTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.PopupHandler;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class CallHierarchyBrowser
extends CallHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance(CallHierarchyBrowser.class);

    public CallHierarchyBrowser(@NotNull Project project, @NotNull PsiMember method) {
        if (project == null) {
            CallHierarchyBrowser.$$$reportNull$$$0(0);
        }
        if (method == null) {
            CallHierarchyBrowser.$$$reportNull$$$0(1);
        }
        super(project, (PsiElement)method);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public CallHierarchyBrowser(@NotNull Project project, @NotNull PsiMethod method) {
        if (project == null) {
            CallHierarchyBrowser.$$$reportNull$$$0(2);
        }
        if (method == null) {
            CallHierarchyBrowser.$$$reportNull$$$0(3);
        }
        super(project, (PsiElement)method);
    }

    protected void createTrees(@NotNull Map<String, JTree> type2TreeMap) {
        if (type2TreeMap == null) {
            CallHierarchyBrowser.$$$reportNull$$$0(4);
        }
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("CallHierarchyPopupMenu");
        JTree tree1 = this.createTree(false);
        PopupHandler.installPopupHandler((JComponent)tree1, (ActionGroup)group, (String)"CallHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        BaseOnThisMethodAction baseOnThisMethodAction = new BaseOnThisMethodAction();
        baseOnThisMethodAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("CallHierarchy").getShortcutSet(), tree1);
        type2TreeMap.put(CallHierarchyBrowser.getCalleeType(), tree1);
        JTree tree2 = this.createTree(false);
        PopupHandler.installPopupHandler((JComponent)tree2, (ActionGroup)group, (String)"CallHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        baseOnThisMethodAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("CallHierarchy").getShortcutSet(), tree2);
        type2TreeMap.put(CallHierarchyBrowser.getCallerType(), tree2);
    }

    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            CallHierarchyBrowser.$$$reportNull$$$0(5);
        }
        if (descriptor instanceof CallHierarchyNodeDescriptor) {
            CallHierarchyNodeDescriptor nodeDescriptor = (CallHierarchyNodeDescriptor)descriptor;
            return nodeDescriptor.getEnclosingElement();
        }
        return null;
    }

    protected PsiElement getOpenFileElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            CallHierarchyBrowser.$$$reportNull$$$0(6);
        }
        if (descriptor instanceof CallHierarchyNodeDescriptor) {
            CallHierarchyNodeDescriptor nodeDescriptor = (CallHierarchyNodeDescriptor)descriptor;
            return nodeDescriptor.getTargetElement();
        }
        return null;
    }

    protected boolean isApplicableElement(@NotNull PsiElement e) {
        if (e == null) {
            CallHierarchyBrowser.$$$reportNull$$$0(7);
        }
        return e instanceof PsiMethod || e instanceof PsiField;
    }

    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        if (typeName == null) {
            CallHierarchyBrowser.$$$reportNull$$$0(8);
        }
        if (psiElement == null) {
            CallHierarchyBrowser.$$$reportNull$$$0(9);
        }
        if (CallHierarchyBrowser.getCallerType().equals(typeName)) {
            return new CallerMethodsTreeStructure(this.myProject, (PsiMember)psiElement, this.getCurrentScopeType());
        }
        if (CallHierarchyBrowser.getCalleeType().equals(typeName)) {
            return new CalleeMethodsTreeStructure(this.myProject, (PsiMember)psiElement, this.getCurrentScopeType());
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    protected Comparator<NodeDescriptor<?>> getComparator() {
        return JavaHierarchyUtil.getComparator(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2TreeMap";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/hierarchy/call/CallHierarchyBrowser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createTrees";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementFromDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getOpenFileElementFromDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createHierarchyTreeStructure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class BaseOnThisMethodAction
    extends CallHierarchyBrowserBase.BaseOnThisMethodAction {
    }
}

