/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class MarkGeneratedSourceRootAction
extends MarkRootActionBase {
    public MarkGeneratedSourceRootAction() {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setIcon(AllIcons.Modules.GeneratedSourceRoot);
        ModuleSourceRootEditHandler handler = ModuleSourceRootEditHandler.getEditHandler((JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
        if (handler == null) {
            return;
        }
        String typeName = handler.getFullRootTypeName();
        presentation.setText(JavaBundle.message((String)"action.text.generated.root.0", (Object[])new Object[]{typeName}));
        presentation.setDescription(JavaBundle.message((String)"action.description.mark.directory.as.a.0.for.generated.files", (Object[])new Object[]{typeName.toLowerCase(Locale.getDefault())}));
    }

    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module) {
        if (selection == null) {
            MarkGeneratedSourceRootAction.$$$reportNull$$$0(0);
        }
        if (module == null) {
            MarkGeneratedSourceRootAction.$$$reportNull$$$0(1);
        }
        if (!MarkGeneratedSourceRootAction.isJavaModule(module)) {
            return false;
        }
        if (selection.myHaveSelectedFilesUnderSourceRoots) {
            return false;
        }
        if (!selection.mySelectedDirectories.isEmpty()) {
            return true;
        }
        for (SourceFolder root : selection.mySelectedRoots) {
            JavaSourceRootProperties properties = (JavaSourceRootProperties)root.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
            if (properties == null || properties.isForGeneratedSources()) continue;
            return true;
        }
        return false;
    }

    private static boolean isJavaModule(Module module) {
        ModuleType moduleType = ModuleType.get((Module)module);
        return moduleType instanceof JavaModuleType || moduleType != null && "PLUGIN_MODULE".equals(moduleType.getId());
    }

    protected void modifyRoots(@NotNull VirtualFile vFile, @NotNull ContentEntry entry) {
        if (vFile == null) {
            MarkGeneratedSourceRootAction.$$$reportNull$$$0(2);
        }
        if (entry == null) {
            MarkGeneratedSourceRootAction.$$$reportNull$$$0(3);
        }
        JavaSourceRootProperties properties = JpsJavaExtensionService.getInstance().createSourceRootProperties("", true);
        entry.addSourceFolder(vFile, (JpsModuleSourceRootType)JavaSourceRootType.SOURCE, (JpsElement)properties);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/actions/MarkGeneratedSourceRootAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

