/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.core.JavaPsiBundle;
import com.intellij.java.JavaBundle;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SuperMethodWarningUtil {
    public static final Key<PsiMethod[]> SIBLINGS = Key.create((String)"MULTIPLE_INHERITANCE");

    private SuperMethodWarningUtil() {
    }

    public static PsiMethod @NotNull [] checkSuperMethods(@NotNull PsiMethod method, @NotNull String actionString) {
        if (method == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(0);
        }
        if (actionString == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        return SuperMethodWarningUtil.checkSuperMethods(method, actionString, Collections.emptyList());
    }

    public static PsiMethod @NotNull [] getTargetMethodCandidates(@NotNull PsiMethod method, @NotNull Collection<? extends PsiElement> ignore) {
        PsiClass aClass;
        if (method == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(2);
        }
        if (ignore == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(3);
        }
        if ((aClass = method.getContainingClass()) == null) {
            PsiMethod[] psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) {
                SuperMethodWarningUtil.$$$reportNull$$$0(4);
            }
            return psiMethodArray;
        }
        Collection<PsiMethod> superMethods = SuperMethodWarningUtil.getSuperMethods(method, aClass, ignore);
        if (superMethods.isEmpty()) {
            PsiMethod[] psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) {
                SuperMethodWarningUtil.$$$reportNull$$$0(5);
            }
            return psiMethodArray;
        }
        PsiMethod[] psiMethodArray = superMethods.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(6);
        }
        return psiMethodArray;
    }

    public static PsiMethod @NotNull [] checkSuperMethods(@NotNull PsiMethod method, @NotNull String actionString, @NotNull Collection<? extends PsiElement> ignore) {
        if (method == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(7);
        }
        if (actionString == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(8);
        }
        if (ignore == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiMethod[] methodTargetCandidates = SuperMethodWarningUtil.getTargetMethodCandidates(method, ignore);
        if (methodTargetCandidates.length == 1 && methodTargetCandidates[0] == method) {
            if (methodTargetCandidates == null) {
                SuperMethodWarningUtil.$$$reportNull$$$0(10);
            }
            return methodTargetCandidates;
        }
        HashSet<String> superClasses = new HashSet<String>();
        boolean superAbstract = false;
        boolean parentInterface = false;
        for (PsiMethod superMethod : methodTargetCandidates) {
            PsiClass containingClass = superMethod.getContainingClass();
            superClasses.add(containingClass.getQualifiedName());
            boolean isInterface = containingClass.isInterface();
            superAbstract |= isInterface || superMethod.hasModifierProperty("abstract");
            parentInterface |= isInterface;
        }
        int shouldIncludeBase = SuperMethodWarningUtil.showDialog(method.getProject(), DescriptiveNameUtil.getDescriptiveName((PsiElement)method), actionString, superAbstract, parentInterface, method.getContainingClass().isInterface(), ArrayUtilRt.toStringArray(superClasses));
        switch (shouldIncludeBase) {
            case 0: {
                if (methodTargetCandidates == null) {
                    SuperMethodWarningUtil.$$$reportNull$$$0(11);
                }
                return methodTargetCandidates;
            }
            case 1: {
                PsiMethod[] psiMethodArray = new PsiMethod[]{method};
                if (psiMethodArray == null) {
                    SuperMethodWarningUtil.$$$reportNull$$$0(12);
                }
                return psiMethodArray;
            }
        }
        if (PsiMethod.EMPTY_ARRAY == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(13);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    static Collection<PsiMethod> getSuperMethods(@NotNull PsiMethod method, PsiClass aClass, @NotNull Collection<? extends PsiElement> ignore) {
        VirtualFile virtualFile;
        if (method == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(14);
        }
        if (ignore == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        Collection superMethods = DeepestSuperMethodsSearch.search((PsiMethod)method).findAll();
        superMethods.removeAll(ignore);
        if (superMethods.isEmpty() && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)aClass)) != null && ProjectRootManager.getInstance((Project)aClass.getProject()).getFileIndex().isInSourceContent(virtualFile)) {
            PsiMethod[] siblingSuperMethod = new PsiMethod[1];
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                siblingSuperMethod[0] = (PsiMethod)ReadAction.compute(() -> FindSuperElementsHelper.getSiblingInheritedViaSubClass(method));
            }, JavaBundle.message((String)"progress.title.searching.for.sub.classes", (Object[])new Object[0]), true, aClass.getProject())) {
                throw new ProcessCanceledException();
            }
            if (siblingSuperMethod[0] != null) {
                superMethods.add(siblingSuperMethod[0]);
                superMethods.add(method);
            }
        }
        Collection collection = superMethods;
        if (collection == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(16);
        }
        return collection;
    }

    public static PsiMethod checkSuperMethod(@NotNull PsiMethod method, @NotNull String actionString) {
        if (method == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(17);
        }
        if (actionString == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return method;
        }
        PsiMethod superMethod = method.findDeepestSuperMethod();
        if (superMethod == null) {
            return method;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return superMethod;
        }
        PsiClass containingClass = superMethod.getContainingClass();
        int useSuperMethod = SuperMethodWarningUtil.showDialog(method.getProject(), DescriptiveNameUtil.getDescriptiveName((PsiElement)method), actionString, containingClass.isInterface() || superMethod.hasModifierProperty("abstract"), containingClass.isInterface(), aClass.isInterface(), containingClass.getQualifiedName());
        switch (useSuperMethod) {
            case 0: {
                return superMethod;
            }
            case 1: {
                return method;
            }
        }
        return null;
    }

    public static void checkSuperMethod(@NotNull PsiMethod method, @NotNull String actionString, @NotNull PsiElementProcessor<? super PsiMethod> processor, @NotNull Editor editor) {
        if (method == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(19);
        }
        if (actionString == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(21);
        }
        if (editor == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(22);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            processor.execute((PsiElement)method);
            return;
        }
        PsiMethod[] superMethods = method.findDeepestSuperMethods();
        if (superMethods.length == 0) {
            processor.execute((PsiElement)method);
            return;
        }
        PsiClass containingClass = superMethods[0].getContainingClass();
        if (containingClass == null) {
            processor.execute((PsiElement)method);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            processor.execute((PsiElement)superMethods[0]);
            return;
        }
        PsiMethod[] methods = new PsiMethod[]{superMethods[0], method};
        String renameBase = actionString + " base method" + (superMethods.length > 1 ? "s" : "");
        String renameCurrent = actionString + " only current method";
        String title = method.getName() + (superMethods.length > 1 ? " has super methods" : (containingClass.isInterface() && !aClass.isInterface() ? " implements" : " overrides") + " method of " + SymbolPresentationUtil.getSymbolPresentableText((PsiElement)containingClass));
        JBPopupFactory.getInstance().createPopupChooserBuilder((List)ContainerUtil.newArrayList((Object[])new String[]{renameBase, renameCurrent})).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(value2 -> {
            if (value2.equals(renameBase)) {
                try {
                    methods[0].putUserData(SIBLINGS, (Object)superMethods);
                    processor.execute((PsiElement)methods[0]);
                }
                finally {
                    methods[0].putUserData(SIBLINGS, null);
                }
            } else {
                processor.execute((PsiElement)methods[1]);
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    @Messages.YesNoCancelResult
    private static int showDialog(@NotNull Project project, @NotNull String name2, @NotNull String actionString, boolean isSuperAbstract, boolean isParentInterface, boolean isContainedInInterface, String ... classNames) {
        if (project == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(23);
        }
        if (name2 == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(24);
        }
        if (actionString == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(25);
        }
        if (classNames == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(26);
        }
        String message2 = SuperMethodWarningUtil.getDialogMessage(name2, actionString, isSuperAbstract, isParentInterface, isContainedInInterface, classNames);
        return Messages.showYesNoCancelDialog((Project)project, (String)message2, (String)JavaBundle.message((String)"dialog.title.super.method.found", (Object[])new Object[0]), (String)JavaBundle.message((String)"button.base.method", (Object[])new Object[0]), (String)JavaBundle.message((String)"button.current.method", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon());
    }

    @NotNull
    private static String getDialogMessage(@NotNull String name2, @NotNull String actionString, boolean isSuperAbstract, boolean isParentInterface, boolean isContainedInInterface, String @NotNull [] classNames) {
        if (name2 == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(27);
        }
        if (actionString == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(28);
        }
        if (classNames == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(29);
        }
        StringBuilder labelText = new StringBuilder();
        String classType = isParentInterface ? JavaBundle.message((String)"element.of.interface", (Object[])new Object[0]) : JavaBundle.message((String)"element.of.class", (Object[])new Object[0]);
        String methodString = JavaPsiBundle.message((String)"element.method", (Object[])new Object[0]);
        labelText.append("<html>").append(JavaBundle.message((String)"label.method", (Object[])new Object[]{name2})).append("<br>");
        if (classNames.length == 1) {
            String className2 = classNames[0];
            labelText.append(isContainedInInterface || !isSuperAbstract ? JavaBundle.message((String)"label.overrides.method.of_class_or_interface.name", (Object[])new Object[]{methodString, classType, className2}) : JavaBundle.message((String)"label.implements.method.of_class_or_interface.name", (Object[])new Object[]{methodString, classType, className2}));
            labelText.append("<br>");
        } else {
            labelText.append(JavaBundle.message((String)"label.implements.method.of_interfaces", (Object[])new Object[0]));
            for (String className3 : classNames) {
                labelText.append("<br>&emsp;'").append(className3).append("'");
            }
        }
        labelText.append("<br>");
        labelText.append(JavaBundle.message((String)"prompt.do.you.want.to.action_verb.the.method.from_class", (Object[])new Object[]{actionString, classNames.length}));
        String string = labelText.toString();
        if (string == null) {
            SuperMethodWarningUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 8: 
            case 18: 
            case 20: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionString";
                break;
            }
            case 3: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignore";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/SuperMethodWarningUtil";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/SuperMethodWarningUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetMethodCandidates";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "checkSuperMethods";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperMethods";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperMethods";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTargetMethodCandidates";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 30: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSuperMethods";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperMethod";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDialogMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

