/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.actions.JavaQualifiedNameProvider;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.gotoByName.DefaultClassNavigationContributor;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSymbolNavigationContributor
implements ChooseByNameContributorEx,
GotoClassContributor {
    private static final Logger LOG = Logger.getInstance(DefaultSymbolNavigationContributor.class);

    @Nullable
    public String getQualifiedName(NavigationItem item) {
        if (item instanceof PsiClass) {
            return DefaultClassNavigationContributor.getQualifiedNameForClass((PsiClass)item);
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return "$";
    }

    private static boolean isOpenable(PsiMember member) {
        PsiFile file = member.getContainingFile();
        return file != null && file.getVirtualFile() != null;
    }

    private static boolean hasSuperMethodCandidates(PsiMethod method, GlobalSearchScope scope, Condition<? super PsiMember> qualifiedMatcher) {
        if (method.hasModifierProperty("private") || method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        int parametersCount = method.getParameterList().getParametersCount();
        return !InheritanceUtil.processSupers((PsiClass)containingClass, (boolean)false, superClass -> {
            if (PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)superClass)) {
                for (PsiMethod candidate : superClass.findMethodsByName(method.getName(), false)) {
                    if (parametersCount != candidate.getParameterList().getParametersCount() || candidate.hasModifierProperty("private") || candidate.hasModifierProperty("static") || !qualifiedMatcher.value((Object)candidate)) continue;
                    return false;
                }
            }
            return true;
        });
    }

    private static boolean hasSuperMethod(PsiMethod method, GlobalSearchScope scope, Condition<? super PsiMember> qualifiedMatcher, String pattern) {
        if (pattern.contains(".") && Registry.is((String)"ide.goto.symbol.include.overrides.on.qualified.patterns")) {
            return false;
        }
        if (!DefaultSymbolNavigationContributor.hasSuperMethodCandidates(method, scope, qualifiedMatcher)) {
            return false;
        }
        for (HierarchicalMethodSignature signature : method.getHierarchicalMethodSignature().getSuperSignatures()) {
            PsiMethod superMethod = signature.getMethod();
            if (!PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)superMethod) || !qualifiedMatcher.value((Object)superMethod)) continue;
            return true;
        }
        return false;
    }

    public void processNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            DefaultSymbolNavigationContributor.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            DefaultSymbolNavigationContributor.$$$reportNull$$$0(1);
        }
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)scope.getProject());
        cache.processAllClassNames(processor, scope, filter);
        cache.processAllFieldNames(processor, scope, filter);
        cache.processAllMethodNames(processor, scope, filter);
    }

    public void processElementsWithName(@NotNull String name2, @NotNull Processor<? super NavigationItem> processor, @NotNull FindSymbolParameters parameters2) {
        boolean success;
        if (name2 == null) {
            DefaultSymbolNavigationContributor.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            DefaultSymbolNavigationContributor.$$$reportNull$$$0(3);
        }
        if (parameters2 == null) {
            DefaultSymbolNavigationContributor.$$$reportNull$$$0(4);
        }
        GlobalSearchScope scope = parameters2.getSearchScope();
        IdFilter filter = parameters2.getIdFilter();
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)scope.getProject());
        String completePattern = parameters2.getCompletePattern();
        Condition<PsiMember> qualifiedMatcher = DefaultSymbolNavigationContributor.getQualifiedNameMatcher(completePattern);
        THashSet collectedMethods = new THashSet();
        boolean bl = success = cache.processFieldsWithName(name2, field -> {
            if (DefaultSymbolNavigationContributor.isOpenable((PsiMember)field) && qualifiedMatcher.value(field)) {
                return processor.process(field);
            }
            return true;
        }, scope, filter) && cache.processClassesWithName(name2, aClass -> {
            if (DefaultSymbolNavigationContributor.isOpenable((PsiMember)aClass) && qualifiedMatcher.value(aClass)) {
                return processor.process(aClass);
            }
            return true;
        }, scope, filter) && cache.processMethodsWithName(name2, arg_0 -> DefaultSymbolNavigationContributor.lambda$processElementsWithName$3(qualifiedMatcher, (Set)collectedMethods, arg_0), scope, filter);
        if (success) {
            Iterator iterator = collectedMethods.iterator();
            while (iterator.hasNext()) {
                PsiMethod method = (PsiMethod)iterator.next();
                if (!DefaultSymbolNavigationContributor.hasSuperMethod(method, scope, qualifiedMatcher, completePattern) && !processor.process((Object)method)) {
                    return;
                }
                ProgressManager.checkCanceled();
                iterator.remove();
            }
        }
    }

    private static Condition<PsiMember> getQualifiedNameMatcher(String completePattern) {
        if (completePattern.contains("#") && completePattern.endsWith(")")) {
            return member -> member instanceof PsiMethod && JavaQualifiedNameProvider.hasQualifiedName(completePattern, (PsiMethod)member);
        }
        if (completePattern.contains(".") || completePattern.contains("#")) {
            String normalized = StringUtil.replace((String)StringUtil.replace((String)completePattern, (String)"#", (String)".*"), (String)".", (String)".*");
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + normalized)).build();
            return member -> {
                String qualifiedName = PsiUtil.getMemberQualifiedName((PsiMember)member);
                return qualifiedName != null && matcher.matches(qualifiedName);
            };
        }
        return Conditions.alwaysTrue();
    }

    private static /* synthetic */ boolean lambda$processElementsWithName$3(Condition qualifiedMatcher, Set collectedMethods, PsiMethod method) {
        if (!method.isConstructor() && DefaultSymbolNavigationContributor.isOpenable((PsiMember)method) && qualifiedMatcher.value((Object)method)) {
            collectedMethods.add(method);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/gotoByName/DefaultSymbolNavigationContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementsWithName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class JavadocSeparatorContributor
    implements ChooseByNameContributorEx,
    GotoClassContributor {
        @Nullable
        public String getQualifiedName(NavigationItem item) {
            return null;
        }

        @Nullable
        public String getQualifiedNameSeparator() {
            return "#";
        }

        public void processNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
            if (processor == null) {
                JavadocSeparatorContributor.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                JavadocSeparatorContributor.$$$reportNull$$$0(1);
            }
        }

        public void processElementsWithName(@NotNull String name2, @NotNull Processor<? super NavigationItem> processor, @NotNull FindSymbolParameters parameters2) {
            if (name2 == null) {
                JavadocSeparatorContributor.$$$reportNull$$$0(2);
            }
            if (processor == null) {
                JavadocSeparatorContributor.$$$reportNull$$$0(3);
            }
            if (parameters2 == null) {
                JavadocSeparatorContributor.$$$reportNull$$$0(4);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/gotoByName/DefaultSymbolNavigationContributor$JavadocSeparatorContributor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processNames";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processElementsWithName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyComparator
    implements Comparator<PsiModifierListOwner> {
        public static final MyComparator INSTANCE = new MyComparator();
        private final DefaultPsiElementCellRenderer myRenderer = new DefaultPsiElementCellRenderer();

        private MyComparator() {
        }

        @Override
        public int compare(PsiModifierListOwner element1, PsiModifierListOwner element2) {
            String text2;
            String text1;
            int kind2;
            int level2;
            if (element1 == element2) {
                return 0;
            }
            PsiModifierList modifierList1 = element1.getModifierList();
            PsiModifierList modifierList2 = element2.getModifierList();
            int level1 = modifierList1 == null ? 4 : PsiUtil.getAccessLevel((PsiModifierList)modifierList1);
            int n = level2 = modifierList2 == null ? 4 : PsiUtil.getAccessLevel((PsiModifierList)modifierList2);
            if (level1 != level2) {
                return level2 - level1;
            }
            int kind1 = MyComparator.getElementTypeLevel((PsiElement)element1);
            if (kind1 != (kind2 = MyComparator.getElementTypeLevel((PsiElement)element2))) {
                return kind1 - kind2;
            }
            if (element1 instanceof PsiMethod) {
                LOG.assertTrue(element2 instanceof PsiMethod);
                PsiParameter[] params1 = ((PsiMethod)element1).getParameterList().getParameters();
                PsiParameter[] params2 = ((PsiMethod)element2).getParameterList().getParameters();
                if (params1.length != params2.length) {
                    return params1.length - params2.length;
                }
            }
            if (!(text1 = this.myRenderer.getElementText((PsiElement)element1)).equals(text2 = this.myRenderer.getElementText((PsiElement)element2))) {
                return text1.compareTo(text2);
            }
            String containerText1 = this.myRenderer.getContainerText((PsiElement)element1, text1);
            String containerText2 = this.myRenderer.getContainerText((PsiElement)element2, text2);
            if (containerText1 == null) {
                containerText1 = "";
            }
            if (containerText2 == null) {
                containerText2 = "";
            }
            return containerText1.compareTo(containerText2);
        }

        private static int getElementTypeLevel(PsiElement element) {
            if (element instanceof PsiMethod) {
                return 1;
            }
            if (element instanceof PsiField) {
                return 2;
            }
            if (element instanceof PsiClass) {
                return 3;
            }
            LOG.error((Object)element);
            return 0;
        }
    }
}

