/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard.modes;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.newProjectWizard.modes.CreateFromSourcesMode;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;

public class CreateModuleFromSourcesMode
extends CreateFromSourcesMode {
    private TextFieldWithBrowseButton myPathPanel;

    @Override
    public boolean isAvailable(WizardContext context) {
        return !context.isCreatingNewProject();
    }

    @Override
    public ProjectBuilder getModuleBuilder() {
        this.myProjectBuilder.setBaseProjectPath(this.myPathPanel.getText().trim());
        return this.myProjectBuilder;
    }

    @Override
    public JComponent getAdditionalSettings(WizardContext wizardContext) {
        this.myPathPanel = new TextFieldWithBrowseButton();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myPathPanel.addBrowseFolderListener(JavaUiBundle.message("chooser.title.select.directory.containing.module.files", new Object[0]), null, wizardContext.getProject(), descriptor);
        this.onChosen(false);
        return this.myPathPanel;
    }

    @Override
    public boolean validate() throws ConfigurationException {
        String path = this.myPathPanel.getText().trim();
        File file = new File(path);
        if (!file.exists()) {
            throw new ConfigurationException("File '" + path + "' doesn't exist");
        }
        if (!file.isDirectory()) {
            throw new ConfigurationException("'" + path + "' is not a directory");
        }
        return super.validate();
    }

    @Override
    public void onChosen(boolean enabled) {
        UIUtil.setEnabled((Component)this.myPathPanel, (boolean)enabled, (boolean)true);
        if (enabled) {
            this.myPathPanel.getTextField().requestFocusInWindow();
        }
    }

    @Override
    public void dispose() {
        this.myPathPanel = null;
        super.dispose();
    }
}

