/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.SwingWorker;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public abstract class AbstractStepWithProgress<Result>
extends ModuleWizardStep {
    private static final Logger LOG = Logger.getInstance(AbstractStepWithProgress.class);
    @NonNls
    private static final String PROGRESS_PANEL = "progress_panel";
    @NonNls
    private static final String RESULTS_PANEL = "results_panel";
    private JPanel myPanel;
    private JLabel myTitleLabel;
    private JLabel myProgressLabel;
    private JLabel myProgressLabel2;
    private ProgressIndicator myProgressIndicator;
    private final String myPromptStopSearch;

    public AbstractStepWithProgress(String promptStopSearching) {
        this.myPromptStopSearch = promptStopSearching;
    }

    public final JComponent getComponent() {
        if (this.myPanel == null) {
            this.myPanel = new JPanel(new CardLayout());
            this.myPanel.setBorder(BorderFactory.createEtchedBorder());
            this.myPanel.add((Component)this.createProgressPanel(), PROGRESS_PANEL);
            this.myPanel.add((Component)this.createResultsPanel(), RESULTS_PANEL);
        }
        return this.myPanel;
    }

    protected abstract JComponent createResultsPanel();

    protected abstract String getProgressText();

    protected abstract boolean shouldRunProgress();

    protected abstract Result calculate();

    protected abstract void onFinished(Result var1, boolean var2);

    private JPanel createProgressPanel() {
        JPanel progressPanel = new JPanel(new GridBagLayout());
        this.myTitleLabel = new JLabel();
        this.myTitleLabel.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
        progressPanel.add((Component)this.myTitleLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)5, (int)10), 0, 0));
        this.myProgressLabel = new JLabel();
        progressPanel.add((Component)this.myProgressLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.myProgressLabel2 = new JLabel(){

            @Override
            public void setText(String text2) {
                super.setText(StringUtil.trimMiddle((String)text2, (int)80));
            }
        };
        progressPanel.add((Component)this.myProgressLabel2, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        JButton stopButton = new JButton(JavaUiBundle.message("button.stop.searching", new Object[0]));
        stopButton.addActionListener(__ -> this.cancelSearch());
        progressPanel.add((Component)stopButton, new GridBagConstraints(1, -1, 1, 2, 0.0, 1.0, 18, 0, (Insets)JBUI.insets((int)10, (int)0, (int)0, (int)10), 0, 0));
        return progressPanel;
    }

    public void performStep() {
        Result result = this.calculate();
        this.createResultsPanel();
        this.onFinished(result, false);
        this.updateDataModel();
    }

    private void cancelSearch() {
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.cancel();
        }
    }

    private synchronized boolean isProgressRunning() {
        return this.myProgressIndicator != null && this.myProgressIndicator.isRunning();
    }

    public void updateStep() {
        if (this.shouldRunProgress()) {
            this.runProgress();
        } else {
            this.showCard(RESULTS_PANEL);
        }
    }

    private void runProgress() {
        final MyProgressIndicator progress = new MyProgressIndicator();
        progress.setModalityProgress(null);
        String title = this.getProgressText();
        if (title != null) {
            this.myTitleLabel.setText(title);
        }
        this.showCard(PROGRESS_PANEL);
        this.myProgressIndicator = progress;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Object result = ProgressManager.getInstance().runProcess(() -> this.calculate(), (ProgressIndicator)progress);
            this.onFinished(result, false);
            return;
        }
        UiNotifyConnector.doWhenFirstShown((JComponent)this.myPanel, () -> new SwingWorker<Result>(){

            public Result construct() {
                LOG.debug("Start calculation in " + (Object)((Object)AbstractStepWithProgress.this) + " using worker " + ((Object)((Object)this)).toString());
                Ref result = Ref.create(null);
                ProgressManager.getInstance().runProcess(() -> result.set(AbstractStepWithProgress.this.calculate()), (ProgressIndicator)progress);
                LOG.debug("Finish calculation in " + (Object)((Object)AbstractStepWithProgress.this) + " using worker " + ((Object)((Object)this)).toString());
                return result.get();
            }

            public void finished() {
                LOG.debug("Schedule showing results for " + (Object)((Object)AbstractStepWithProgress.this) + " using worker " + ((Object)((Object)this)).toString());
                AbstractStepWithProgress.this.myProgressIndicator = null;
                ApplicationManager.getApplication().invokeLater(() -> {
                    LOG.debug("Show results for " + (Object)((Object)AbstractStepWithProgress.this));
                    Object result = this.get();
                    AbstractStepWithProgress.this.onFinished(result, progress.isCanceled());
                    AbstractStepWithProgress.this.showCard(AbstractStepWithProgress.RESULTS_PANEL);
                });
            }
        }.start());
    }

    private void showCard(String id) {
        ((CardLayout)this.myPanel.getLayout()).show(this.myPanel, id);
        this.myPanel.revalidate();
    }

    public boolean validate() throws ConfigurationException {
        if (this.isProgressRunning()) {
            int answer = Messages.showOkCancelDialog((Component)this.getComponent(), (String)this.myPromptStopSearch, (String)JavaUiBundle.message("title.question", new Object[0]), (String)JavaUiBundle.message("action.continue.searching", new Object[0]), (String)JavaUiBundle.message("action.stop.searching", new Object[0]), (Icon)Messages.getWarningIcon());
            if (answer != 0) {
                this.cancelSearch();
            }
            return false;
        }
        return true;
    }

    public void onStepLeaving() {
        if (this.isProgressRunning()) {
            this.cancelSearch();
        }
    }

    protected class MyProgressIndicator
    extends ProgressIndicatorBase {
        protected MyProgressIndicator() {
        }

        public void setText(String text2) {
            this.updateLabel(AbstractStepWithProgress.this.myProgressLabel, text2);
            super.setText(text2);
        }

        public void setText2(String text2) {
            this.updateLabel(AbstractStepWithProgress.this.myProgressLabel2, text2);
            super.setText2(text2);
        }

        private void updateLabel(JLabel label, String text2) {
            UIUtil.invokeLaterIfNeeded(() -> label.setText(text2));
        }
    }
}

