/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.refactoring.rename.AutomaticRenamingDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JavaModuleRenameListener
implements ModuleListener {
    public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
        if (project == null) {
            JavaModuleRenameListener.$$$reportNull$$$0(0);
        }
        if (modules == null) {
            JavaModuleRenameListener.$$$reportNull$$$0(1);
        }
        if (oldNameProvider == null) {
            JavaModuleRenameListener.$$$reportNull$$$0(2);
        }
        ArrayList<Pair> suggestions = new ArrayList<Pair>();
        for (Module module : modules) {
            PsiJavaModule javaModule;
            if (ModuleType.get((Module)module) != JavaModuleType.getModuleType() || (javaModule = (PsiJavaModule)Stream.of(ModuleRootManager.getInstance((Module)module).getSourceRoots(false)).map(root -> JavaModuleGraphUtil.findDescriptorByFile(root, project)).filter(Objects::nonNull).findFirst().orElse(null)) == null || !javaModule.getName().equals(LightJavaModule.moduleName((String)oldNameProvider.fun((Object)module)))) continue;
            suggestions.add(Pair.pair((Object)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)javaModule), (Object)LightJavaModule.moduleName(module.getName())));
        }
        if (!suggestions.isEmpty()) {
            AppUIExecutor.onUiThread((ModalityState)ModalityState.NON_MODAL).later().inSmartMode(project).execute(() -> JavaModuleRenameListener.renameModules(project, suggestions));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void renameModules(Project project, List<? extends Pair<SmartPsiElementPointer<PsiJavaModule>, String>> suggestions) {
        MyAutomaticRenamer renamer = new MyAutomaticRenamer();
        for (Pair<SmartPsiElementPointer<PsiJavaModule>, String> pair2 : suggestions) {
            PsiJavaModule javaModule = (PsiJavaModule)((SmartPsiElementPointer)pair2.first).getElement();
            if (javaModule == null) continue;
            renamer.addElement(javaModule, (String)pair2.second);
        }
        if (!renamer.getElements().isEmpty()) {
            AutomaticRenamingDialog dialog = new AutomaticRenamingDialog(project, (AutomaticRenamer)renamer);
            dialog.showOptionsPanel();
            if (dialog.showAndGet()) {
                void var4_6;
                Object var4_5 = null;
                for (Map.Entry entry : renamer.getRenames().entrySet()) {
                    String newName = (String)entry.getValue();
                    if (newName == null) continue;
                    if (var4_6 == null) {
                        RenameProcessor renameProcessor = new RenameProcessor(project, (PsiElement)entry.getKey(), newName, dialog.isSearchInComments(), dialog.isSearchTextOccurrences());
                        continue;
                    }
                    var4_6.addElement((PsiElement)entry.getKey(), newName);
                }
                if (var4_6 != null) {
                    var4_6.run();
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "modules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "oldNameProvider";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/java/JavaModuleRenameListener";
        objectArray[2] = "modulesRenamed";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyAutomaticRenamer
    extends AutomaticRenamer {
        private MyAutomaticRenamer() {
        }

        private void addElement(PsiJavaModule module, String newName) {
            this.myElements.add(module);
            this.suggestAllNames(module.getName(), newName);
        }

        @Nls(capitalization=Nls.Capitalization.Title)
        public String getDialogTitle() {
            return JavaRefactoringBundle.message((String)"auto.rename.module.dialog.title", (Object[])new Object[0]);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getDialogDescription() {
            return JavaRefactoringBundle.message((String)"auto.rename.module.dialog.description", (Object[])new Object[0]);
        }

        public String entityName() {
            return JavaRefactoringBundle.message((String)"auto.rename.module.entity", (Object[])new Object[0]);
        }
    }
}

