/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLanguageLevelPusher
implements FilePropertyPusher<LanguageLevel> {
    private static final FileAttribute PERSISTENCE = new FileAttribute("language_level_persistence", 3, true);

    public static void pushLanguageLevel(@NotNull Project project) {
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(0);
        }
        PushedFilePropertiesUpdater instance = PushedFilePropertiesUpdater.getInstance((Project)project);
        for (FilePropertyPusher pusher : EP_NAME.getExtensionList()) {
            if (!(pusher instanceof JavaLanguageLevelPusher)) continue;
            instance.pushAll(new FilePropertyPusher[]{pusher});
        }
    }

    @NotNull
    public Key<LanguageLevel> getFileDataKey() {
        Key key2 = LanguageLevel.KEY;
        if (key2 == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(1);
        }
        return key2;
    }

    public boolean pushDirectoriesOnly() {
        return true;
    }

    @NotNull
    public LanguageLevel getDefaultValue() {
        LanguageLevel languageLevel = LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(2);
        }
        return languageLevel;
    }

    public LanguageLevel getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(3);
        }
        return null;
    }

    public LanguageLevel getImmediateValue(@NotNull Module module) {
        if (module == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(4);
        }
        return EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(5);
        }
        return false;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(6);
        }
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(7);
        }
        return ProjectFileIndex.SERVICE.getInstance((Project)project).isInSourceContent(file);
    }

    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull LanguageLevel level) throws IOException {
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(8);
        }
        if (fileOrDir == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(9);
        }
        if (level == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(10);
        }
        try (DataInputStream iStream = PERSISTENCE.readAttribute(fileOrDir);){
            int oldLevelOrdinal;
            if (iStream != null && (oldLevelOrdinal = DataInputOutputUtil.readINT((DataInput)iStream)) == level.ordinal()) {
                return;
            }
        }
        var5_5 = null;
        try (DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);){
            DataInputOutputUtil.writeINT((DataOutput)oStream, (int)level.ordinal());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        for (VirtualFile child : fileOrDir.getChildren()) {
            if (child.isDirectory() || !JavaLanguageLevelPusher.isJavaLike(child.getFileType())) continue;
            PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(child);
        }
    }

    private static boolean isJavaLike(FileType type2) {
        return type2 instanceof LanguageFileType && ((LanguageFileType)type2).getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(11);
        }
    }

    @Nullable
    public String getInconsistencyLanguageLevelMessage(@NotNull String message2, @NotNull PsiElement element, @NotNull LanguageLevel level, @NotNull PsiFile file) {
        if (message2 == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(12);
        }
        if (element == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(13);
        }
        if (level == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(14);
        }
        if (file == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(15);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDataKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pushLanguageLevel";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "persistAttribute";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "afterRootsChanged";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getInconsistencyLanguageLevelMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

