/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibrariesHelper;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.text.StringTokenizer;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibrariesHelperImpl
extends LibrariesHelper {
    public VirtualFile findJarByClass(Library library, @NonNls String fqn) {
        return library == null ? null : this.findRootByClass(Arrays.asList(library.getFiles(OrderRootType.CLASSES)), fqn);
    }

    @Nullable
    public VirtualFile findRootByClass(@NotNull List<? extends VirtualFile> roots, String fqn) {
        if (roots == null) {
            LibrariesHelperImpl.$$$reportNull$$$0(0);
        }
        for (VirtualFile virtualFile : roots) {
            if (!LibrariesHelperImpl.findInFile(virtualFile, new StringTokenizer(fqn, "."))) continue;
            return virtualFile;
        }
        return null;
    }

    public boolean isClassAvailableInLibrary(Library library, String fqn) {
        String[] urls = library.getUrls(OrderRootType.CLASSES);
        return this.isClassAvailable(urls, fqn);
    }

    public boolean isClassAvailable(String[] urls, String fqn) {
        for (String url : urls) {
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
            if (file == null) continue;
            if (!(file.getFileSystem() instanceof JarFileSystem) && !file.isDirectory()) {
                file = JarFileSystem.getInstance().getJarRootForLocalFile(file);
            }
            if (file == null || !LibrariesHelperImpl.findInFile(file, new StringTokenizer(fqn, "."))) continue;
            return true;
        }
        return false;
    }

    private static boolean findInFile(VirtualFile root, StringTokenizer filePath) {
        VirtualFile child;
        if (!filePath.hasMoreTokens()) {
            return true;
        }
        String name2 = filePath.nextToken();
        if (!filePath.hasMoreTokens()) {
            name2 = name2 + ".class";
        }
        return (child = root.findChild(name2)) != null && LibrariesHelperImpl.findInFile(child, filePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/roots/libraries/LibrariesHelperImpl", "findRootByClass"));
    }
}

