/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ProjectTopics;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleJdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClasspathEditor
extends ModuleElementsEditor
implements ModuleRootListener {
    @Deprecated
    public static final String NAME = "Dependencies";
    private ClasspathPanelImpl myPanel;
    private ClasspathFormatPanel myClasspathFormatPanel;

    public ClasspathEditor(ModuleConfigurationState state) {
        super(state);
        Disposable disposable = Disposer.newDisposable();
        state.getProject().getMessageBus().connect(disposable).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)this);
        this.registerDisposable(disposable);
    }

    public boolean isModified() {
        return super.isModified() || this.myClasspathFormatPanel != null && this.myClasspathFormatPanel.isModified();
    }

    public String getHelpTopic() {
        return "projectStructure.modules.dependencies";
    }

    public String getDisplayName() {
        return ClasspathEditor.getName();
    }

    public void saveData() {
        this.myPanel.stopEditing();
    }

    public void apply() throws ConfigurationException {
        if (this.myClasspathFormatPanel != null) {
            this.myClasspathFormatPanel.apply();
        }
    }

    public void canApply() throws ConfigurationException {
        super.canApply();
        if (this.myClasspathFormatPanel != null) {
            this.myClasspathFormatPanel.canApply();
        }
    }

    public JComponent createComponentImpl() {
        this.myPanel = new ClasspathPanelImpl(this.getState());
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        panel2.add((Component)this.myPanel, "Center");
        ModuleJdkConfigurable jdkConfigurable = new ModuleJdkConfigurable(this, ProjectStructureConfigurable.getInstance(this.myProject).getProjectJdksModel()){

            @Override
            protected ModifiableRootModel getRootModel() {
                return ClasspathEditor.this.getModifiableModel();
            }
        };
        panel2.add((Component)jdkConfigurable.createComponent(), "North");
        jdkConfigurable.reset();
        this.registerDisposable(jdkConfigurable);
        ClasspathStorageProvider[] providers2 = (ClasspathStorageProvider[])ClasspathStorageProvider.EXTENSION_POINT_NAME.getExtensions();
        if (providers2.length > 0) {
            this.myClasspathFormatPanel = new ClasspathFormatPanel(providers2, this.getModel());
            panel2.add((Component)this.myClasspathFormatPanel, "South");
        }
        return panel2;
    }

    private ModifiableRootModel getModifiableModel() {
        return this.getState().getRootModel();
    }

    public void selectOrderEntry(@NotNull OrderEntry entry) {
        if (entry == null) {
            ClasspathEditor.$$$reportNull$$$0(0);
        }
        this.myPanel.selectOrderEntry(entry);
    }

    public void moduleStateChanged() {
        if (this.myPanel != null) {
            this.myPanel.initFromModel();
        }
    }

    public void rootsChanged(@NotNull ModuleRootEvent event) {
        if (event == null) {
            ClasspathEditor.$$$reportNull$$$0(1);
        }
        if (this.myPanel != null) {
            this.myPanel.rootsChanged();
        }
    }

    public void setSdk(@Nullable Sdk newJDK) {
        ModifiableRootModel model = this.getModel();
        if (newJDK != null) {
            model.setSdk(newJDK);
        } else {
            model.inheritSdk();
        }
        if (this.myPanel != null) {
            this.myPanel.forceInitFromModel();
        }
    }

    public static String getName() {
        return JavaCompilerBundle.message((String)"modules.classpath.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ClasspathEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "selectOrderEntry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "rootsChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ClasspathFormatPanel
    extends JPanel {
        private final ModifiableRootModel rootModel;
        private final JComboBox<String> comboBoxClasspathFormat;

        private ClasspathFormatPanel(ClasspathStorageProvider[] providers2, ModifiableRootModel model) {
            super(new GridBagLayout());
            this.rootModel = model;
            this.add((Component)new JLabel(JavaUiBundle.message("project.roots.classpath.format.label", new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)10, (int)6, (int)6, (int)0), 0, 0));
            LinkedHashMap<String, String> formatIdToDescription = new LinkedHashMap<String, String>();
            formatIdToDescription.put("default", JavaUiBundle.message("project.roots.classpath.format.default.descr", new Object[0]));
            for (ClasspathStorageProvider provider : providers2) {
                formatIdToDescription.put(provider.getID(), provider.getDescription());
            }
            this.comboBoxClasspathFormat = new ComboBox((Object[])ArrayUtilRt.toStringArray(formatIdToDescription.keySet()));
            this.comboBoxClasspathFormat.setRenderer((ListCellRenderer<String>)SimpleListCellRenderer.create((String)"", formatIdToDescription::get));
            this.comboBoxClasspathFormat.setSelectedItem(this.getModuleClasspathFormat());
            this.add(this.comboBoxClasspathFormat, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)6, (int)6, (int)6, (int)0), 0, 0));
        }

        private String getSelectedClasspathFormat() {
            return (String)this.comboBoxClasspathFormat.getSelectedItem();
        }

        private String getModuleClasspathFormat() {
            return ClassPathStorageUtil.getStorageType((Module)this.rootModel.getModule());
        }

        private boolean isModified() {
            return !this.getSelectedClasspathFormat().equals(this.getModuleClasspathFormat());
        }

        public void canApply() throws ConfigurationException {
            ClasspathStorageProvider provider = ClasspathStorage.getProvider((String)this.getSelectedClasspathFormat());
            if (provider != null) {
                provider.assertCompatible((ModuleRootModel)this.rootModel);
            }
        }

        private void apply() throws ConfigurationException {
            this.canApply();
            ClasspathStorage.setStorageType((ModuleRootModel)this.rootModel, (String)this.getSelectedClasspathFormat());
        }
    }
}

