/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.pom.java.AcceptedLanguageLevelsSettings;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class LanguageLevelCombo
extends ComboBox<Object> {
    private final String myDefaultItem;

    public LanguageLevelCombo(String defaultItem) {
        this.myDefaultItem = defaultItem;
        this.insertItemAt(this.myDefaultItem, 0);
        for (LanguageLevel level : LanguageLevel.values()) {
            if (level == LanguageLevel.JDK_X) continue;
            this.addItem(level);
        }
        this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Object>(){

            protected void customizeCellRenderer(@NotNull JList<?> list, Object value2, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value2 instanceof LanguageLevel) {
                    this.append(((LanguageLevel)value2).getPresentableText());
                } else if (value2 instanceof String) {
                    this.append((String)value2);
                    LanguageLevel defaultLevel = LanguageLevelCombo.this.getDefaultLevel();
                    if (defaultLevel != null) {
                        this.append(" (" + defaultLevel.getPresentableText() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/roots/ui/configuration/LanguageLevelCombo$1", "customizeCellRenderer"));
            }
        });
    }

    private void checkAcceptedLevel(LanguageLevel selectedLevel) {
        if (selectedLevel == null) {
            return;
        }
        LanguageLevel level = AcceptedLanguageLevelsSettings.checkAccepted((Component)((Object)this), selectedLevel);
        if (level == null) {
            this.setSelectedItem(AcceptedLanguageLevelsSettings.getHighestAcceptedLevel());
        }
    }

    public void reset(@NotNull Project project) {
        if (project == null) {
            LanguageLevelCombo.$$$reportNull$$$0(0);
        }
        Sdk sdk = ProjectRootManagerEx.getInstanceEx((Project)project).getProjectSdk();
        this.sdkUpdated(sdk, project.isDefault());
        LanguageLevelProjectExtension extension = LanguageLevelProjectExtension.getInstance((Project)project);
        if (extension.isDefault()) {
            this.setSelectedItem(this.myDefaultItem);
        } else {
            this.setSelectedItem(extension.getLanguageLevel());
        }
    }

    protected abstract LanguageLevel getDefaultLevel();

    void sdkUpdated(Sdk sdk, boolean isDefaultProject) {
        JavaSdkVersion version;
        LanguageLevel newLevel = null;
        if (sdk != null && (version = JavaSdk.getInstance().getVersion(sdk)) != null) {
            newLevel = version.getMaxLanguageLevel();
        }
        this.updateDefaultLevel(newLevel, isDefaultProject);
        if (this.getSelectedItem() == this.myDefaultItem) {
            this.checkAcceptedLevel(newLevel);
        }
    }

    private void updateDefaultLevel(LanguageLevel newLevel, boolean isDefaultProject) {
        if (newLevel == null && !isDefaultProject && this.getSelectedItem() == this.myDefaultItem) {
            this.setSelectedItem(this.getDefaultLevel());
        }
        this.repaint();
    }

    public LanguageLevel getSelectedLevel() {
        Object item = this.getSelectedItem();
        return item instanceof LanguageLevel ? (LanguageLevel)item : this.getDefaultLevel();
    }

    public boolean isDefault() {
        return !(this.getSelectedItem() instanceof LanguageLevel);
    }

    public void setSelectedItem(Object anObject) {
        super.setSelectedItem(anObject == null || anObject == LanguageLevel.JDK_X ? this.myDefaultItem : anObject);
        this.checkAcceptedLevel(this.getSelectedLevel());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/LanguageLevelCombo", "reset"));
    }
}

