/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleSourceItemGroup
extends PackagingSourceItem {
    private final Module myModule;

    public ModuleSourceItemGroup(@NotNull Module module) {
        if (module == null) {
            ModuleSourceItemGroup.$$$reportNull$$$0(0);
        }
        super(true);
        this.myModule = module;
    }

    @NotNull
    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            ModuleSourceItemGroup.$$$reportNull$$$0(1);
        }
        return new ModuleSourceItemPresentation(this.myModule, context);
    }

    public boolean equals(Object obj) {
        return obj instanceof ModuleSourceItemGroup && this.myModule.equals(((ModuleSourceItemGroup)((Object)obj)).myModule);
    }

    public int hashCode() {
        return this.myModule.hashCode();
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            ModuleSourceItemGroup.$$$reportNull$$$0(2);
        }
        LinkedHashSet modules = new LinkedHashSet();
        ModuleSourceItemGroup.collectDependentModules(this.myModule, modules, context);
        Artifact artifact = context.getArtifact();
        ArtifactType artifactType = artifact.getArtifactType();
        LinkedHashSet<PackagingSourceItem> items = new LinkedHashSet<PackagingSourceItem>();
        for (Module module : modules) {
            for (PackagingSourceItemsProvider provider : (PackagingSourceItemsProvider[])PackagingSourceItemsProvider.EP_NAME.getExtensions()) {
                ModuleSourceItemGroup parent = new ModuleSourceItemGroup(module);
                for (PackagingSourceItem sourceItem : provider.getSourceItems(context, artifact, (PackagingSourceItem)parent)) {
                    if (!artifactType.isSuitableItem(sourceItem) || !sourceItem.isProvideElements()) continue;
                    items.add(sourceItem);
                }
            }
        }
        ArrayList result = new ArrayList();
        PackagingElementFactory factory = PackagingElementFactory.getInstance();
        for (PackagingSourceItem item : items) {
            String path = artifactType.getDefaultPathFor(item.getKindOfProducedElements());
            if (path == null) continue;
            result.addAll(factory.createParentDirectories(path, item.createElements(context)));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            ModuleSourceItemGroup.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static void collectDependentModules(Module module, Set<? super Module> modules, ArtifactEditorContext context) {
        if (!modules.add((Module)module)) {
            return;
        }
        for (OrderEntry entry : context.getModulesProvider().getRootModel(module).getOrderEntries()) {
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry moduleEntry = (ModuleOrderEntry)entry;
            Module dependency = moduleEntry.getModule();
            DependencyScope scope = moduleEntry.getScope();
            if (dependency == null || !scope.isForProductionRuntime()) continue;
            ModuleSourceItemGroup.collectDependentModules(dependency, modules, context);
        }
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ModuleSourceItemGroup.$$$reportNull$$$0(4);
        }
        return module;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleSourceItemGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleSourceItemGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createElements";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModuleSourceItemPresentation
    extends SourceItemPresentation {
        private final Module myModule;
        private final ArtifactEditorContext myContext;

        ModuleSourceItemPresentation(@NotNull Module module, ArtifactEditorContext context) {
            if (module == null) {
                ModuleSourceItemPresentation.$$$reportNull$$$0(0);
            }
            this.myModule = module;
            this.myContext = context;
        }

        public String getPresentableName() {
            return ModuleGrouper.instanceFor((Project)this.myContext.getProject(), (ModifiableModuleModel)this.myContext.getModifiableModuleModel()).getShortenedName(this.myModule);
        }

        public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
            if (presentationData == null) {
                ModuleSourceItemPresentation.$$$reportNull$$$0(1);
            }
            presentationData.setIcon(ModuleType.get((Module)this.myModule).getIcon());
            presentationData.addText(this.getPresentableName(), mainAttributes);
        }

        public boolean canNavigateToSource() {
            return true;
        }

        public void navigateToSource() {
            this.myContext.selectModule(this.myModule);
        }

        public int getWeight() {
            return 50;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentationData";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleSourceItemGroup$ModuleSourceItemPresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

