/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.LibraryScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.classpath.InlineModuleDependencyAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyVisitorFactory;
import com.intellij.packageDependencies.actions.AnalyzeDependenciesOnSpecifiedTargetHandler;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

class AnalyzeModuleDependencyAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(AnalyzeModuleDependencyAction.class);
    private final ClasspathPanel myPanel;

    AnalyzeModuleDependencyAction(ClasspathPanel panel2) {
        super(JavaUiBundle.message("action.text.analyze.this.dependency", new Object[0]));
        this.myPanel = panel2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Map<GlobalSearchScope, OrderEntry> additionalScopes;
        OrderEntry selectedEntry;
        GlobalSearchScope mainScope;
        if (e == null) {
            AnalyzeModuleDependencyAction.$$$reportNull$$$0(0);
        }
        LOG.assertTrue((mainScope = this.getScopeForOrderEntry(selectedEntry = this.myPanel.getSelectedEntry())) != null);
        ModulesProvider modulesProvider = this.myPanel.getModuleConfigurationState().getModulesProvider();
        if (selectedEntry instanceof ModuleOrderEntry) {
            Module depModule = ((ModuleOrderEntry)selectedEntry).getModule();
            LOG.assertTrue(depModule != null);
            Map<OrderEntry, OrderEntry> additionalDependencies = JavaProjectRootsUtil.findExportedDependenciesReachableViaThisDependencyOnly(this.myPanel.getRootModel().getModule(), depModule, (RootModelProvider)modulesProvider);
            additionalScopes = new LinkedHashMap();
            for (Map.Entry<OrderEntry, OrderEntry> entry : additionalDependencies.entrySet()) {
                additionalScopes.put(this.getScopeForOrderEntry(entry.getKey()), entry.getValue());
            }
        } else {
            additionalScopes = Collections.emptyMap();
        }
        final ArrayList scopes = new ArrayList(additionalScopes.keySet());
        scopes.add(mainScope);
        new AnalyzeDependenciesOnSpecifiedTargetHandler(this.myPanel.getProject(), new AnalysisScope(this.myPanel.getModuleConfigurationState().getRootModel().getModule()), GlobalSearchScope.union((GlobalSearchScope[])scopes.toArray(GlobalSearchScope.EMPTY_ARRAY))){

            protected boolean shouldShowDependenciesPanel(List<? extends DependenciesBuilder> builders) {
                Set usedScopes = AnalyzeModuleDependencyAction.findUsedScopes(builders, scopes);
                if (usedScopes.contains(mainScope)) {
                    Messages.showInfoMessage((Project)this.myProject, (String)JavaUiBundle.message("message.text.dependencies.were.successfully.collected.in.0.toolwindow", "Dependency Viewer"), (String)AnalyzeModuleDependencyAction.this.getTemplateText());
                    return true;
                }
                List usedEntries = usedScopes.stream().map(additionalScopes::get).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (usedEntries.isEmpty()) {
                    String message2 = "No code dependencies were found." + AnalyzeModuleDependencyAction.this.generateSkipImportsWarning() + " Would you like to remove the dependency?";
                    if (Messages.showOkCancelDialog((Project)this.myProject, (String)message2, (String)AnalyzeModuleDependencyAction.this.getTemplateText(), (String)CommonBundle.message((String)"button.remove", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon()) == 0) {
                        AnalyzeModuleDependencyAction.this.myPanel.getRootModel().removeOrderEntry(selectedEntry);
                    }
                    return false;
                }
                String usedExportedEntriesText = "'" + ((OrderEntry)usedEntries.get(0)).getPresentableName() + "'";
                if (usedEntries.size() == 2) {
                    usedExportedEntriesText = usedExportedEntriesText + " and '" + ((OrderEntry)usedEntries.get(1)).getPresentableName() + "'";
                } else if (usedEntries.size() > 2) {
                    usedExportedEntriesText = usedExportedEntriesText + " and " + (usedEntries.size() - 1) + " more dependencies";
                }
                String replacementText = usedEntries.size() == 1 ? "a direct dependency on '" + ((OrderEntry)usedEntries.get(0)).getPresentableName() + "'" : "direct dependencies";
                String message3 = "No direct code dependencies were found." + AnalyzeModuleDependencyAction.this.generateSkipImportsWarning() + "\nHowever " + usedExportedEntriesText + " exported by '" + StringUtil.decapitalize((String)selectedEntry.getPresentableName()) + "' " + (usedEntries.size() > 1 ? "are" : "is") + " used in code.\nDo you want to replace dependency on '" + selectedEntry.getPresentableName() + "' by " + replacementText + "?";
                String[] options = new String[]{"Replace", "Show Dependencies", Messages.getCancelButton()};
                switch (Messages.showDialog((Project)this.myProject, (String)message3, (String)AnalyzeModuleDependencyAction.this.getTemplateText(), (String[])options, (int)0, (Icon)Messages.getWarningIcon())) {
                    case 0: {
                        InlineModuleDependencyAction.inlineEntry(AnalyzeModuleDependencyAction.this.myPanel, selectedEntry, usedEntries::contains);
                        return false;
                    }
                    case 1: {
                        return true;
                    }
                }
                return false;
            }

            protected boolean canStartInBackground() {
                return false;
            }
        }.analyze();
    }

    private String generateSkipImportsWarning() {
        if (DependencyVisitorFactory.VisitorOptions.fromSettings((Project)this.myPanel.getProject()).skipImports()) {
            return " " + CodeInsightBundle.message((String)"dependencies.in.imports.message", (Object[])new Object[0]);
        }
        return "";
    }

    private static Set<GlobalSearchScope> findUsedScopes(List<? extends DependenciesBuilder> builders, List<? extends GlobalSearchScope> scopes) {
        LinkedHashSet<GlobalSearchScope> usedScopes = new LinkedHashSet<GlobalSearchScope>();
        for (DependenciesBuilder dependenciesBuilder : builders) {
            for (Set files : dependenciesBuilder.getDependencies().values()) {
                for (PsiFile file : files) {
                    VirtualFile virtualFile = file.getVirtualFile();
                    if (virtualFile == null) continue;
                    for (GlobalSearchScope globalSearchScope : scopes) {
                        if (!globalSearchScope.contains(virtualFile)) continue;
                        usedScopes.add(globalSearchScope);
                    }
                }
            }
        }
        return usedScopes;
    }

    @Contract(value="null -> null")
    private GlobalSearchScope getScopeForOrderEntry(OrderEntry selectedEntry) {
        if (selectedEntry instanceof ModuleSourceOrderEntry) {
            return GlobalSearchScope.moduleScope((Module)selectedEntry.getOwnerModule());
        }
        if (selectedEntry instanceof ModuleOrderEntry) {
            Module module = ((ModuleOrderEntry)selectedEntry).getModule();
            return module != null ? GlobalSearchScope.moduleScope((Module)module) : null;
        }
        if (selectedEntry instanceof LibraryOrderEntry) {
            Library library = ((LibraryOrderEntry)selectedEntry).getLibrary();
            return library != null ? new LibraryScope(this.myPanel.getProject(), library) : null;
        }
        return null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AnalyzeModuleDependencyAction.$$$reportNull$$$0(1);
        }
        OrderEntry entry = this.myPanel.getSelectedEntry();
        e.getPresentation().setVisible(entry instanceof ModuleOrderEntry && ((ModuleOrderEntry)entry).getModule() != null || entry instanceof LibraryOrderEntry && ((LibraryOrderEntry)entry).getLibrary() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/AnalyzeModuleDependencyAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

