/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import org.jetbrains.annotations.NotNull;

public class AddLibraryToModuleDependenciesAction
extends DumbAwareAction {
    @NotNull
    private final Project myProject;
    @NotNull
    private final BaseLibrariesConfigurable myConfigurable;

    public AddLibraryToModuleDependenciesAction(@NotNull Project project, @NotNull BaseLibrariesConfigurable configurable) {
        if (project == null) {
            AddLibraryToModuleDependenciesAction.$$$reportNull$$$0(0);
        }
        if (configurable == null) {
            AddLibraryToModuleDependenciesAction.$$$reportNull$$$0(1);
        }
        super(JavaUiBundle.message("action.text.add.to.modules", new Object[0]), JavaUiBundle.message("action.description.add.the.library.to.the.dependencies.list.of.chosen.modules", new Object[0]), null);
        this.myProject = project;
        this.myConfigurable = configurable;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddLibraryToModuleDependenciesAction.$$$reportNull$$$0(2);
        }
        ProjectStructureElement element = this.myConfigurable.getSelectedElement();
        boolean visible = false;
        if (element instanceof LibraryProjectStructureElement) {
            LibraryEx library = (LibraryEx)((LibraryProjectStructureElement)element).getLibrary();
            visible = !LibraryEditingUtil.getSuitableModules(ModuleStructureConfigurable.getInstance(this.myProject), (LibraryKind)library.getKind(), (Library)library).isEmpty();
        }
        e.getPresentation().setVisible(visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        LibraryProjectStructureElement element;
        if (e == null) {
            AddLibraryToModuleDependenciesAction.$$$reportNull$$$0(3);
        }
        if ((element = (LibraryProjectStructureElement)this.myConfigurable.getSelectedElement()) == null) {
            return;
        }
        Library library = element.getLibrary();
        LibraryEditingUtil.showDialogAndAddLibraryToDependencies(library, this.myProject, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/AddLibraryToModuleDependenciesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

