/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.impl.artifacts.ArtifactManagerImpl;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.PathUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class ArtifactVirtualFileListener
implements BulkFileListener {
    private final CachedValue<MultiValuesMap<String, Artifact>> myParentPathsToArtifacts;
    private final ArtifactManagerImpl myArtifactManager;

    ArtifactVirtualFileListener(@NotNull Project project, @NotNull ArtifactManagerImpl artifactManager) {
        if (project == null) {
            ArtifactVirtualFileListener.$$$reportNull$$$0(0);
        }
        if (artifactManager == null) {
            ArtifactVirtualFileListener.$$$reportNull$$$0(1);
        }
        this.myArtifactManager = artifactManager;
        this.myParentPathsToArtifacts = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            MultiValuesMap<String, Artifact> result = this.computeParentPathToArtifactMap();
            return CachedValueProvider.Result.createSingleDependency(result, (Object)artifactManager.getModificationTracker());
        }, false);
    }

    private MultiValuesMap<String, Artifact> computeParentPathToArtifactMap() {
        final MultiValuesMap result = new MultiValuesMap();
        for (final Artifact artifact : this.myArtifactManager.getArtifacts()) {
            ArtifactUtil.processFileOrDirectoryCopyElements(artifact, new PackagingElementProcessor<FileOrDirectoryCopyPackagingElement<?>>(){

                @Override
                public boolean process(@NotNull FileOrDirectoryCopyPackagingElement<?> element, @NotNull PackagingElementPath pathToElement) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (pathToElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    String path = element.getFilePath();
                    while (path.length() > 0) {
                        result.put((Object)path, (Object)artifact);
                        path = PathUtil.getParentPath((String)path);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "pathToElement";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactVirtualFileListener$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, this.myArtifactManager.getResolvingContext(), false);
        }
        return result;
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            ArtifactVirtualFileListener.$$$reportNull$$$0(2);
        }
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileMoveEvent) {
                this.filePathChanged(((VFileMoveEvent)vFileEvent).getOldPath(), vFileEvent.getPath());
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            this.propertyChanged((VFilePropertyChangeEvent)vFileEvent);
        }
    }

    private void filePathChanged(final @NotNull String oldPath, final @NotNull String newPath) {
        Collection artifacts;
        if (oldPath == null) {
            ArtifactVirtualFileListener.$$$reportNull$$$0(3);
        }
        if (newPath == null) {
            ArtifactVirtualFileListener.$$$reportNull$$$0(4);
        }
        if ((artifacts = ((MultiValuesMap)this.myParentPathsToArtifacts.getValue()).get((Object)oldPath)) != null) {
            ModifiableArtifactModel model = this.myArtifactManager.createModifiableModel();
            for (Artifact artifact : artifacts) {
                ModifiableArtifact copy = model.getOrCreateModifiableArtifact(artifact);
                ArtifactUtil.processFileOrDirectoryCopyElements((Artifact)copy, new PackagingElementProcessor<FileOrDirectoryCopyPackagingElement<?>>(){

                    @Override
                    public boolean process(@NotNull FileOrDirectoryCopyPackagingElement<?> element, @NotNull PackagingElementPath pathToElement) {
                        String path;
                        if (element == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (pathToElement == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (FileUtil.startsWith((String)(path = element.getFilePath()), (String)oldPath)) {
                            element.setFilePath(newPath + path.substring(oldPath.length()));
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "pathToElement";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactVirtualFileListener$2";
                        objectArray[2] = "process";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, this.myArtifactManager.getResolvingContext(), false);
            }
            model.commit();
        }
    }

    private void propertyChanged(@NotNull VFilePropertyChangeEvent event) {
        VirtualFile parent;
        if (event == null) {
            ArtifactVirtualFileListener.$$$reportNull$$$0(5);
        }
        if ("name".equals(event.getPropertyName()) && (parent = event.getFile().getParent()) != null) {
            String parentPath = parent.getPath();
            this.filePathChanged(parentPath + "/" + event.getOldValue(), parentPath + "/" + event.getNewValue());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/artifacts/ArtifactVirtualFileListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "filePathChanged";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

