/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.CommonBundle;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.compiler.make.ManifestBuilder;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.util.PathUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestFileUtil {
    private static final Logger LOG = Logger.getInstance(ManifestFileUtil.class);
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    public static final String MANIFEST_FILE_NAME = PathUtil.getFileName((String)"META-INF/MANIFEST.MF");
    public static final String MANIFEST_DIR_NAME = PathUtil.getParentPath((String)"META-INF/MANIFEST.MF");

    private ManifestFileUtil() {
    }

    @Nullable
    public static VirtualFile findManifestFile(@NotNull CompositePackagingElement<?> root, PackagingElementResolvingContext context, ArtifactType artifactType) {
        if (root == null) {
            ManifestFileUtil.$$$reportNull$$$0(0);
        }
        return ArtifactUtil.findSourceFileByOutputPath(root, MANIFEST_PATH, context, artifactType);
    }

    @Nullable
    public static VirtualFile suggestManifestFileDirectory(@NotNull CompositePackagingElement<?> root, PackagingElementResolvingContext context, ArtifactType artifactType) {
        VirtualFile metaInfDir;
        if (root == null) {
            ManifestFileUtil.$$$reportNull$$$0(1);
        }
        if ((metaInfDir = ArtifactUtil.findSourceFileByOutputPath(root, MANIFEST_DIR_NAME, context, artifactType)) != null) {
            return metaInfDir;
        }
        final Ref sourceDir = Ref.create(null);
        final Ref sourceFile = Ref.create(null);
        ArtifactUtil.processElementsWithSubstitutions(root.getChildren(), context, artifactType, PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                VirtualFile file;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof FileCopyPackagingElement) {
                    VirtualFile file2 = ((FileCopyPackagingElement)element).findFile();
                    if (file2 != null) {
                        sourceFile.set((Object)file2);
                    }
                } else if (element instanceof DirectoryCopyPackagingElement && (file = ((DirectoryCopyPackagingElement)element).findFile()) != null) {
                    sourceDir.set((Object)file);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/elements/ManifestFileUtil$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!sourceDir.isNull()) {
            return (VirtualFile)sourceDir.get();
        }
        Project project = context.getProject();
        return ManifestFileUtil.suggestBaseDir(project, (VirtualFile)sourceFile.get());
    }

    @Nullable
    public static VirtualFile suggestManifestFileDirectory(@NotNull Project project, @Nullable Module module) {
        OrderEnumerator enumerator;
        VirtualFile[] files;
        if (project == null) {
            ManifestFileUtil.$$$reportNull$$$0(2);
        }
        if ((files = (enumerator = module != null ? OrderEnumerator.orderEntries((Module)module) : OrderEnumerator.orderEntries((Project)project)).withoutDepModules().withoutLibraries().withoutSdk().productionOnly().sources().getRoots()).length > 0) {
            return files[0];
        }
        return ManifestFileUtil.suggestBaseDir(project, null);
    }

    @Nullable
    private static VirtualFile suggestBaseDir(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            ManifestFileUtil.$$$reportNull$$$0(3);
        }
        VirtualFile[] contentRoots = ProjectRootManager.getInstance((Project)project).getContentRoots();
        if (file == null && contentRoots.length > 0) {
            return contentRoots[0];
        }
        if (file != null) {
            for (VirtualFile contentRoot : contentRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) continue;
                return contentRoot;
            }
        }
        return project.getBaseDir();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Manifest readManifest(@NotNull VirtualFile manifestFile) {
        if (manifestFile == null) {
            ManifestFileUtil.$$$reportNull$$$0(4);
        }
        try (InputStream inputStream = manifestFile.getInputStream();){
            Manifest manifest = new Manifest(inputStream);
            return manifest;
        }
        catch (IOException ignored) {
            return new Manifest();
        }
    }

    public static void updateManifest(@NotNull VirtualFile file, @Nullable String mainClass, @Nullable List<String> classpath, boolean replaceValues) {
        if (file == null) {
            ManifestFileUtil.$$$reportNull$$$0(5);
        }
        Manifest manifest = ManifestFileUtil.readManifest(file);
        Attributes mainAttributes = manifest.getMainAttributes();
        if (mainClass != null) {
            mainAttributes.put(Attributes.Name.MAIN_CLASS, mainClass);
        } else if (replaceValues) {
            mainAttributes.remove(Attributes.Name.MAIN_CLASS);
        }
        if (classpath != null && !classpath.isEmpty()) {
            List<String> updatedClasspath;
            if (replaceValues) {
                updatedClasspath = classpath;
            } else {
                updatedClasspath = new ArrayList<String>();
                String oldClasspath = (String)mainAttributes.get(Attributes.Name.CLASS_PATH);
                if (!StringUtil.isEmpty((String)oldClasspath)) {
                    updatedClasspath.addAll(StringUtil.split((String)oldClasspath, (String)" "));
                }
                for (String path : classpath) {
                    if (updatedClasspath.contains(path)) continue;
                    updatedClasspath.add(path);
                }
            }
            mainAttributes.put(Attributes.Name.CLASS_PATH, StringUtil.join(updatedClasspath, (String)" "));
        } else if (replaceValues) {
            mainAttributes.remove(Attributes.Name.CLASS_PATH);
        }
        ManifestBuilder.setVersionAttribute((Attributes)mainAttributes);
        ApplicationManager.getApplication().runWriteAction(() -> {
            try (OutputStream outputStream = file.getOutputStream(ManifestFileUtil.class);){
                manifest.write(outputStream);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        });
    }

    @NotNull
    public static ManifestFileConfiguration createManifestFileConfiguration(@NotNull VirtualFile manifestFile) {
        if (manifestFile == null) {
            ManifestFileUtil.$$$reportNull$$$0(6);
        }
        String path = manifestFile.getPath();
        Manifest manifest = ManifestFileUtil.readManifest(manifestFile);
        String mainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        String classpathText = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        ArrayList classpath = new ArrayList();
        if (classpathText != null) {
            classpath.addAll(StringUtil.split((String)classpathText, (String)" "));
        }
        return new ManifestFileConfiguration(path, classpath, mainClass, manifestFile.isWritable());
    }

    public static List<String> getClasspathForElements(List<? extends PackagingElement<?>> elements, PackagingElementResolvingContext context, ArtifactType artifactType) {
        final ArrayList<String> classpath = new ArrayList<String>();
        PackagingElementProcessor processor = new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (element instanceof FileCopyPackagingElement) {
                    String fileName = ((FileCopyPackagingElement)element).getOutputFileName();
                    classpath.add(DeploymentUtil.appendToPath((String)path.getPathString(), (String)fileName));
                } else if (element instanceof DirectoryCopyPackagingElement) {
                    classpath.add(path.getPathString());
                } else if (element instanceof ArchivePackagingElement) {
                    String archiveName = ((ArchivePackagingElement)element).getName();
                    classpath.add(DeploymentUtil.appendToPath((String)path.getPathString(), (String)archiveName));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/elements/ManifestFileUtil$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (PackagingElement<?> element : elements) {
            ArtifactUtil.processPackagingElements(element, null, processor, context, true, artifactType);
        }
        return classpath;
    }

    @Nullable
    public static VirtualFile showDialogAndCreateManifest(ArtifactEditorContext context, CompositePackagingElement<?> element) {
        FileChooserDescriptor descriptor = ManifestFileUtil.createDescriptorForManifestDirectory();
        VirtualFile directory = ManifestFileUtil.suggestManifestFileDirectory(element, (PackagingElementResolvingContext)context, context.getArtifactType());
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)context.getProject(), (VirtualFile)directory);
        if (file == null) {
            return null;
        }
        return ManifestFileUtil.createManifestFile(file, context.getProject());
    }

    @Nullable
    public static VirtualFile createManifestFile(@NotNull VirtualFile directory, @NotNull Project project) {
        if (directory == null) {
            ManifestFileUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ManifestFileUtil.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        try {
            return (VirtualFile)WriteAction.compute(() -> {
                VirtualFile dir = directory;
                if (!dir.getName().equals(MANIFEST_DIR_NAME)) {
                    dir = VfsUtil.createDirectoryIfMissing((VirtualFile)dir, (String)MANIFEST_DIR_NAME);
                }
                VirtualFile f = dir.createChildData((Object)dir, MANIFEST_FILE_NAME);
                try (OutputStream output = f.getOutputStream((Object)dir);){
                    Manifest manifest = new Manifest();
                    ManifestBuilder.setVersionAttribute((Attributes)manifest.getMainAttributes());
                    manifest.write(output);
                }
                return f;
            });
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
            return null;
        }
    }

    public static FileChooserDescriptor createDescriptorForManifestDirectory() {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(JavaCompilerBundle.message((String)"select.directory.for.meta.inf.manifest.mf.file", (Object[])new Object[0]));
        return descriptor;
    }

    public static void addManifestFileToLayout(@NotNull String path, @NotNull ArtifactEditorContext context, @NotNull CompositePackagingElement<?> element) {
        if (path == null) {
            ManifestFileUtil.$$$reportNull$$$0(9);
        }
        if (context == null) {
            ManifestFileUtil.$$$reportNull$$$0(10);
        }
        if (element == null) {
            ManifestFileUtil.$$$reportNull$$$0(11);
        }
        context.editLayout(context.getArtifact(), () -> {
            VirtualFile file = ManifestFileUtil.findManifestFile(element, (PackagingElementResolvingContext)context, context.getArtifactType());
            if (file == null || !FileUtil.pathsEqual((String)file.getPath(), (String)path)) {
                PackagingElementFactory.getInstance().addFileCopy(element, MANIFEST_DIR_NAME, path, MANIFEST_FILE_NAME);
            }
        });
    }

    @Nullable
    public static PsiClass selectMainClass(Project project, @Nullable String initialClassName) {
        TreeClassChooserFactory chooserFactory = TreeClassChooserFactory.getInstance((Project)project);
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        PsiClass aClass = initialClassName != null ? JavaPsiFacade.getInstance((Project)project).findClass(initialClassName, searchScope) : null;
        TreeClassChooser chooser = chooserFactory.createWithInnerClassesScopeChooser("Select Main Class", searchScope, (ClassFilter)new MainClassFilter(), aClass);
        chooser.showDialog();
        return chooser.getSelected();
    }

    public static void setupMainClassField(final Project project, final TextFieldWithBrowseButton field) {
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PsiClass selected = ManifestFileUtil.selectMainClass(project, field.getText());
                if (selected != null) {
                    field.setText(selected.getQualifiedName());
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/elements/ManifestFileUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findManifestFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestManifestFileDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestBaseDir";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readManifest";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateManifest";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createManifestFileConfiguration";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createManifestFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addManifestFileToLayout";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MainClassFilter
    implements ClassFilter {
        private MainClassFilter() {
        }

        public boolean isAccepted(PsiClass aClass) {
            return (Boolean)ReadAction.compute(() -> PsiMethodUtil.MAIN_CLASS.value((Object)aClass) && PsiMethodUtil.hasMainMethod((PsiClass)aClass));
        }
    }
}

